/*
 * Decompiled with CFR 0.152.
 */
package heuser.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class Update {
    private static String appName;
    private static String old_ver;
    private static String loc;
    private static boolean upToDate;
    public static boolean error;
    private static String errorMsg;
    private String onlineVersion;
    private static String onlineLoc;
    private static String onlineName;

    public static boolean newVersionAvailable(String string, String string2, String string3) {
        new Update(string, string2, string3);
        return upToDate;
    }

    public static void installNew() {
        new Update();
    }

    public Update() {
        if (appName.length() == 0) {
            return;
        }
        this.downloadNewVersion();
        this.install(this.prepareFiles(this.checkOS()));
    }

    public Update(String string, String string2, String string3) {
        appName = string;
        old_ver = string2;
        loc = string3;
        this.deleteUpdateScript();
        upToDate = this.newerAvailable();
    }

    public static String getErrors() {
        return errorMsg;
    }

    private boolean newerAvailable() {
        this.retrieveAppInfo();
        if (errorMsg.length() != 0) {
            return false;
        }
        return this.firstNewer(this.onlineVersion, old_ver);
    }

    private void retrieveAppInfo() {
        try {
            URL uRL = new URL(loc + appName + ".cvr");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            this.onlineVersion = bufferedReader.readLine();
            onlineLoc = bufferedReader.readLine();
            onlineName = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.logError("Error connecting server and / or reading information file.\n");
        }
    }

    private boolean firstNewer(String string, String string2) {
        int n;
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(".")));
        if (n2 > (n = Integer.parseInt(string2.substring(0, string2.indexOf("."))))) {
            return true;
        }
        if (n2 < n) {
            return false;
        }
        String string3 = string.substring(string.indexOf(".") + 1);
        String string4 = string2.substring(string2.indexOf(".") + 1);
        if (!string3.endsWith(".")) {
            string3 = string3 + ".";
        }
        if (!string4.endsWith(".")) {
            string4 = string4 + ".";
        }
        if (string4.length() == 1 && string3.length() > 1) {
            return true;
        }
        if (string3.length() == 1 && string4.length() > 1) {
            return false;
        }
        if (string4.length() == 1 && string3.length() == 1) {
            return false;
        }
        return this.firstNewer(string3, string4);
    }

    private void downloadNewVersion() {
        try {
            int n;
            URL uRL = new URL(loc + onlineLoc + onlineName);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(onlineName);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n);
            }
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logError("Error downloading new version.");
        }
    }

    private String prepareFiles(String string) {
        File file;
        String[] stringArray = new String[]{"@del " + appName + "_" + old_ver + ".jar", "@start javaw -jar " + onlineName};
        if (string.equals("Linux")) {
            stringArray[0] = "#bin/bash" + System.getProperty("line.separator") + "rm " + appName + "_" + old_ver + ".jar";
            stringArray[1] = "java -jar " + onlineName;
        }
        if ((file = string.equals("Windows") || string.equals("DOS") ? new File("update_" + appName + ".bat") : new File("update_" + appName + ".sh")).exists()) {
            file.delete();
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i]);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            this.logError("Error creating batch file. Check space and / or permissions.\n");
        }
        return file.getAbsolutePath();
    }

    private void deleteUpdateScript() {
        File file = new File("update_" + appName + ".bat");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File("update_" + appName + ".sh")).exists()) {
            file.delete();
        }
    }

    private void install(String string) {
        if (error) {
            return;
        }
        try {
            Runtime.getRuntime().exec(string);
            Runtime.getRuntime().exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String checkOS() {
        String string = System.getProperty("os.name");
        if (string.indexOf("Windows") != -1) {
            return "Windows";
        }
        if (string.indexOf("DOS") != -1) {
            return "DOS";
        }
        if (string.indexOf("Linux") != -1) {
            return "Linux";
        }
        return "Other";
    }

    private void logError(String string) {
        errorMsg = errorMsg + string;
        error = true;
    }

    static {
        error = false;
        errorMsg = "";
    }
}

