/* UserEditor.java - jfig.gui.UserEditor
 *
 * 29.12.01 - use as testbed for CreateFreehandCommand
 * 25.09.98 - first version
 *
 * (C) 1998 F.N.Hendrich, hendrich@informatik.uni-hamburg.de
 *
 * a simple subclass of ModularUserEditor to be used as the main jfig editor
 */

package jfig.gui;

import java.awt.*;
import java.awt.event.*;


/**
 * example subclass of ModularEditor to demonstrate user extensions.
 */
public class  UserEditor 
       extends  ModularEditor {

  Menu      userMenu;
  MenuItem  zoom85MI, zoom163MI, zoomValueMI;
  MenuItem  freehandMI;

  StringDialog  zoomDialog;


  public void buildUserMenu() {
    userMenu  = new Menu( "User" );
    zoom85MI    = new MenuItem( "zoom 85%" );
    zoom163MI   = new MenuItem( "zoom 163%" );
    zoomValueMI = new MenuItem( "zoom value..." );
    freehandMI  = new MenuItem( "create freehand line..." );

    userMenu.add( zoom85MI );
    userMenu.add( zoom163MI );
    userMenu.add( zoomValueMI );
    userMenu.add( freehandMI );
    this.getMenuBar().add( userMenu );
  
    zoom85MI.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        getObjectCanvas().getTrafo().set_zoom( 0.85 );
        setZoomMessage();
        objectCanvas.doFullRedraw();
      }
    });   
    zoom163MI.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        getObjectCanvas().getTrafo().set_zoom( 1.63 );
        setZoomMessage();
        getObjectCanvas().doFullRedraw();
      }
    });
    zoomValueMI.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        if (zoomDialog == null) createZoomDialog();
        zoomDialog.show();
      }
    });

    freehandMI.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        if (!checkCanCancel()) return;
        command = new jfig.commands.CreateFreehandCommand( UserEditor.this, objectCanvas );
      }
    });
  }

  public void createZoomDialog() {
    zoomDialog = new StringDialog( this.getFrame(), 
                                "Specify zoom factor:",
                                "1.0",
                                15 );
    zoomDialog.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        String s = (String) evt.getActionCommand();
        if (s.equals( "Cancel" )) {
           zoomDialog.setVisible( false );
           return;
        }
        else { // OK or <ENTER>
           double d = 1.0;
           try {
             d = Double.valueOf(zoomDialog.getText()).doubleValue();
           }
           catch( Exception e ) {
             d = 2.0; 
           }
           getObjectCanvas().getTrafo().set_zoom( d );
           setZoomMessage();
           getObjectCanvas().doFullRedraw(); 

           zoomDialog.setVisible( false );
           return;
        }
      }
    });
  }


  public static void main( String argv[] ) {
    String  fname = null;
    boolean debug = false;
    for( int i=0; i < argv.length; i++ ) {
       if   (argv[0].equals( "-v" )) debug = true;
       else fname = argv[i];
    }
    jfig.utils.ExceptionTracer.setEnabled( debug );
    UserEditor  editor = new UserEditor();
    editor.getFrame().setTitle( "UserDefined jfig 1.0" );
    editor.buildUserMenu();
    editor.setInitialWindowSize();

    if (fname != null) editor.doParseFile( fname, false );
  }
}
