/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.launch;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class JaxoSplashWindow
extends Component
implements AWTEventListener {
    private static final long serialVersionUID = 7526471155622776147L;
    private final Object lock = new Object();
    private Frame frame;
    private final Image image;
    private boolean painted;
    private final String windowTitle;

    public JaxoSplashWindow(String title) {
        this.windowTitle = title;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.image = Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("resources/icons/start.png"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.frame != null) {
                return;
            }
            MediaTracker t = new MediaTracker(this);
            t.addImage(this.image, 0);
            try {
                t.waitForAll();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            int width = this.image.getWidth(this);
            int height = this.image.getHeight(this);
            if (width > 0 && height > 0) {
                this.frame = new Frame(this.windowTitle);
                this.frame.setUndecorated(true);
                this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("resources/icons/frame.png")));
                this.frame.setAlwaysOnTop(true);
                this.frame.add(this);
                this.frame.setSize(width, height);
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
                this.frame.getToolkit().addAWTEventListener(this, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(int remaining) {
        Object object = this.lock;
        synchronized (object) {
            if (this.frame != null) {
                if (remaining > 0) {
                    final Frame f = this.frame;
                    Timer t = new Timer(remaining, new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            f.dispose();
                        }
                    });
                    t.setRepeats(false);
                    t.start();
                } else {
                    this.frame.dispose();
                }
                this.frame.getToolkit().removeAWTEventListener(this);
                this.frame = null;
                this.painted = false;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToFront() {
        Object object = this.lock;
        synchronized (object) {
            if (this.frame != null) {
                this.frame.toFront();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, null);
        Object object = this.lock;
        synchronized (object) {
            this.painted = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilPainted(long wait) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long now;
            if (this.painted || this.frame == null) {
                return;
            }
            long old = System.currentTimeMillis();
            for (long remaining = wait; remaining > 0L; remaining -= now - old) {
                this.lock.wait(remaining);
                if (this.painted || this.frame == null) {
                    return;
                }
                now = System.currentTimeMillis();
                old = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDispatched(AWTEvent e) {
        if (e.getSource() instanceof Dialog && e.getID() == 102) {
            Object object = this.lock;
            synchronized (object) {
                if (this.frame != null) {
                    this.frame.setAlwaysOnTop(false);
                    ((Dialog)e.getSource()).toFront();
                }
            }
        }
    }
}

