/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.menu;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoUtils;

public final class JaxoMenuUtils {
    private static final boolean USE_CUSTOM_CHECKMARK = true;
    private static final ImageIcon CHECKMARK_ICON = JaxoUtils.newImageIcon("checkmark.png");
    private static final String I18N_KEY = "Jaxo.i18NKey";

    private JaxoMenuUtils() {
    }

    public static JMenuItem newCheckmarkMenuItem() {
        return new JMenuItem();
    }

    public static JMenuItem newCheckmarkMenuItem(String text) {
        return new JMenuItem(text);
    }

    public static boolean isChecked(JMenuItem m) {
        return m.getIcon() != null;
    }

    public static void setChecked(JMenuItem m, boolean value) {
        m.setIcon(value ? CHECKMARK_ICON : null);
    }

    public static void updateLanguage(JMenuItem m) {
        if (m.getClientProperty(I18N_KEY) != null) {
            m.setText(JaxoLanguage.translate((String)m.getClientProperty(I18N_KEY)));
        }
    }

    public static void setLanguageKey(JMenuItem m, String key) {
        m.putClientProperty(I18N_KEY, key);
    }

    public static void setAccelerator(JMenuItem m, char keyChar) {
        m.setAccelerator(KeyStroke.getKeyStroke(keyChar));
    }

    public static void setAccelerator(JMenuItem m, int keyCode, int modifiers) {
        m.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public static void setActionCommand(JMenuItem m, int mode) {
        m.setActionCommand(JaxoConstants.getModeAsString(mode));
    }
}

