/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.Location;

public class JaxoColorChooser
implements JaxoLocalized {
    private static JaxoDictionary language = new JaxoDictionary(JaxoColorChooser.class);
    private final EventListenerList listeners;
    private ChangeEvent event;
    private boolean adjusting;
    private final Component parent;
    private boolean permanent;
    private JColorChooser chooser;
    private final JaxoColorSelectionModel selection;
    private JDialog dialog;
    private int mode;
    private boolean cancelled;
    private String dialogTitle;
    private boolean optional;
    private JCheckBox noColorBox;

    public JaxoColorChooser(Component parentc) {
        this.parent = parentc;
        this.selection = new JaxoColorSelectionModel();
        this.listeners = new EventListenerList();
        this.mode = 0;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        this.chooser = null;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] pairs = this.listeners.getListenerList();
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != ChangeListener.class) continue;
            if (this.event == null) {
                this.event = new ChangeEvent(this);
            }
            ((ChangeListener)pairs[i + 1]).stateChanged(this.event);
        }
    }

    private void updateNoColor() {
        if (this.noColorBox != null) {
            this.noColorBox.setSelected(this.selection.isNoColor());
            this.noColorBox.setVisible(this.optional);
            this.noColorBox.revalidate();
        }
    }

    public void setColor(Color value) {
        this.selection.setSelectedColor(value);
    }

    public Color getColor() {
        return this.selection.getColor();
    }

    public final boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean value) {
        this.optional = value;
        this.updateNoColor();
    }

    public void setOptionalColor(Color value) {
        this.setOptional(value == null);
        this.setColor(value);
    }

    public final boolean isAdjusting() {
        return this.adjusting;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean hasChanged() {
        return !this.isCancelled() && this.selection.hasChanged();
    }

    public final int getMode() {
        return this.mode;
    }

    public void setMode(int value) {
        if (this.mode != value) {
            int old = this.mode;
            this.mode = value;
            if (old == 2 || this.mode == 2) {
                this.dispose();
            } else if (this.chooser != null) {
                ((JaxoColorPanel)this.chooser.getChooserPanels()[0]).setGrayScalesAllowed(this.mode == 0);
            }
        }
    }

    public void updateLanguage() {
        this.dispose();
    }

    public final boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean value) {
        if (value != this.permanent) {
            this.permanent = value;
            if (!this.permanent && this.dialog != null && !this.dialog.isVisible()) {
                this.dispose();
            }
        }
    }

    public final String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String value) {
        this.dialogTitle = value;
    }

    protected void createComponents() {
        if (this.chooser != null) {
            return;
        }
        this.noColorBox = new JCheckBox(language.value("noColor"));
        this.noColorBox.setAlignmentX(0.5f);
        this.noColorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoColorChooser.this.selection.setNoColor(JaxoColorChooser.this.noColorBox.isSelected());
            }
        });
        this.chooser = new JColorChooser(this.selection){
            private static final long serialVersionUID = 7526471155622L;

            public AbstractColorChooserPanel removeChooserPanel(AbstractColorChooserPanel p) {
                AbstractColorChooserPanel[] old = this.getChooserPanels();
                for (int i = 0; i < old.length; ++i) {
                    if (old[i] != p) continue;
                    super.removeChooserPanel(p);
                    break;
                }
                return p;
            }

            public void updateUI() {
                super.updateUI();
                if (JaxoColorChooser.this.mode != 2) {
                    this.setChooserPanels(new AbstractColorChooserPanel[]{new JaxoColorPanel()});
                }
            }
        };
        if (this.mode != 2) {
            ((JaxoColorPanel)this.chooser.getChooserPanels()[0]).setGrayScalesAllowed(this.mode == 0);
            this.chooser.setPreviewPanel(new JaxoColorPreviewPanel(this.chooser));
        }
        JButton ok = new JButton(language.value("/Accept"));
        ok.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent evt) {
                JaxoColorChooser.this.cancelled = false;
                JaxoColorChooser.this.dialog.setVisible(false);
            }
        });
        JButton reset = new JButton(language.value("/Reset"));
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoColorChooser.this.selection.reset();
            }
        });
        Object[] optionButtons = new Object[]{ok, reset, language.value("/Cancel")};
        Object[] message = new Object[]{this.chooser, this.noColorBox};
        JOptionPane p = new JOptionPane(message, -1, 2, null, optionButtons, optionButtons[0]);
        this.dialog = p.createDialog(this.parent, "");
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                if (!JaxoColorChooser.this.permanent) {
                    JaxoColorChooser.this.dispose();
                }
            }
        });
        this.dialog.setDefaultCloseOperation(1);
    }

    public void show() {
        this.show(new Location.RelativeTo(this.parent));
    }

    public void show(Location l) {
        this.createComponents();
        this.selection.commit();
        this.updateNoColor();
        this.adjusting = true;
        this.cancelled = true;
        this.dialog.setTitle(JaxoDialogs.translatedWindowTitle(this.dialogTitle == null ? language.value("defaultTitle") : this.dialogTitle));
        this.dialog.pack();
        l.setLocation(this.dialog);
        this.fireStateChanged();
        this.dialog.setVisible(true);
        if (this.cancelled) {
            this.selection.reset();
        }
        this.adjusting = false;
        this.fireStateChanged();
    }

    private static class JaxoColorPreviewPanel
    extends JComponent {
        private static final long serialVersionUID = 7526471155622776147L;
        private final JColorChooser chooser;
        private int cachedWidth = -1;

        JaxoColorPreviewPanel(JColorChooser colorChooser) {
            this.chooser = colorChooser;
            this.setFont(new Font("SansSerif", 1, 24));
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setSize(this.getPreferredSize());
        }

        public void removeNotify() {
            this.cachedWidth = -1;
            super.removeNotify();
        }

        public Dimension getMinimumSize() {
            return this.isMinimumSizeSet() ? super.getMinimumSize() : this.getPreferredSize();
        }

        public final Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Insets n = this.getInsets();
            FontMetrics m = this.getFontMetrics(this.getFont());
            int width = this.cachedWidth;
            if (width == -1) {
                width = 0;
                for (int i = 0; i < JaxoColor.getColorCount(); ++i) {
                    width = Math.max(width, m.stringWidth(language.message("previewText1%0", language.value("/" + JaxoColor.getColorName(i)))));
                }
                this.cachedWidth = width;
            }
            return new Dimension(n.left + n.right + width * 5 / 4, n.top + n.bottom + m.getHeight() * 3 / 2);
        }

        protected final void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            String name = "";
            Color clr = this.chooser.getColor();
            g2.setFont(this.getFont());
            g2.setColor(clr);
            if (JaxoPrefs.getBooleanPref("prefANTIALIAS")) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            FontMetrics m = g2.getFontMetrics();
            Insets n = this.getInsets();
            int y = (this.getHeight() - n.top - n.bottom - m.getHeight()) / 2;
            if (JaxoColor.isDefinedColor(clr)) {
                name = language.message("previewText%0", language.value("/" + JaxoColor.getColorName(clr)));
                g2.drawString(name, n.left + y, n.top + y + m.getAscent());
            } else {
                name = language.value("previewText");
                g2.drawString(name, n.left + y, n.top + y + m.getAscent());
                if (((JaxoColorPanel)this.chooser.getChooserPanels()[0]).areGrayScalesAllowed()) {
                    Color col = JaxoColor.getClosestColorTo(this.chooser.getColor(), 0);
                    g2.setColor(col);
                    g2.drawString(language.value("/" + JaxoColor.getColorName(col)), n.left + y + m.stringWidth(name), n.top + y + m.getAscent());
                } else {
                    Color col = JaxoColor.getClosestColorTo(this.chooser.getColor(), 1);
                    g2.setColor(col);
                    g2.drawString(language.value("/" + JaxoColor.getColorName(col)), n.left + y + m.stringWidth(name), n.top + y + m.getAscent());
                }
            }
        }
    }

    private static class JaxoColorPanel
    extends AbstractColorChooserPanel {
        private static final long serialVersionUID = 7526471155622776147L;
        private static final Dimension ICON_SIZE = new Dimension(25, 25);
        private boolean grayScalesAllowed = true;
        private JToggleButton[] jaxButton;
        private JToggleButton extra;

        JaxoColorPanel() {
            this.setLayout(new GridLayout(7, 12));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        }

        public final boolean areGrayScalesAllowed() {
            return this.grayScalesAllowed;
        }

        public void setGrayScalesAllowed(boolean value) {
            if (value != this.grayScalesAllowed) {
                this.grayScalesAllowed = value;
                this.updateGrayScales();
            }
        }

        public final void updateChooser() {
            Color color = this.getColorFromModel();
            for (int i = 0; i < this.jaxButton.length; ++i) {
                if (!color.equals(JaxoColor.getColor(i))) continue;
                this.jaxButton[i].setSelected(true);
                return;
            }
            this.extra.setSelected(true);
        }

        protected void updateGrayScales() {
            int i = 0;
            do {
                if (!JaxoColor.isGrayScale(JaxoColor.getColor(i))) continue;
                if (this.grayScalesAllowed) {
                    this.add((Component)this.jaxButton[i], i);
                    continue;
                }
                this.remove(this.jaxButton[i]);
            } while (++i < JaxoColor.getColorCount());
            this.revalidate();
            this.repaint();
        }

        protected void buildChooser() {
            this.jaxButton = new JToggleButton[JaxoColor.getColorCount()];
            JaxoColorListener jcl = new JaxoColorListener();
            ButtonGroup boxOfJaxoColors = new ButtonGroup();
            AbstractBorder border = new AbstractBorder(){
                private static final long serialVersionUID = 7526471155622L;
                private Border line = BorderFactory.createLineBorder(Color.black, 4);

                public boolean isBorderOpaque() {
                    return false;
                }

                public Insets getBorderInsets(Component c) {
                    return this.line.getBorderInsets(c);
                }

                public Insets getBorderInsets(Component c, Insets insets) {
                    return ((AbstractBorder)this.line).getBorderInsets(c, insets);
                }

                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    if (c instanceof JToggleButton && ((JToggleButton)c).isSelected()) {
                        this.line.paintBorder(c, g, x, y, width, height);
                    }
                }
            };
            for (int i = 0; i < JaxoColor.getColorCount(); ++i) {
                ImageIcon jaxBox = JaxoUtils.getChooserImageIcon(JaxoColor.getColor(i), ICON_SIZE);
                String colorName = language.value("/" + JaxoColor.getColorName(JaxoColor.getColor(i)));
                this.jaxButton[i] = new JToggleButton(jaxBox);
                this.jaxButton[i].putClientProperty("Jaxo.color", JaxoColor.getColor(i));
                this.jaxButton[i].addActionListener(jcl);
                this.jaxButton[i].setBorder(border);
                this.jaxButton[i].setContentAreaFilled(false);
                this.jaxButton[i].setToolTipText(colorName);
                boxOfJaxoColors.add(this.jaxButton[i]);
                this.add(this.jaxButton[i]);
            }
            this.extra = new JToggleButton();
            boxOfJaxoColors.add(this.extra);
            this.updateGrayScales();
        }

        public final String getDisplayName() {
            return language.value("chooserPanelTitle");
        }

        public final Icon getSmallDisplayIcon() {
            return null;
        }

        public final Icon getLargeDisplayIcon() {
            return null;
        }

        public boolean isExtraSelected() {
            this.updateChooser();
            return this.extra.isSelected();
        }

        class JaxoColorListener
        implements ActionListener {
            JaxoColorListener() {
            }

            public final void actionPerformed(ActionEvent e) {
                JToggleButton source = (JToggleButton)e.getSource();
                JaxoColorPanel.this.getColorSelectionModel().setSelectedColor((Color)source.getClientProperty("Jaxo.color"));
            }
        }
    }

    private class JaxoColorSelectionModel
    extends DefaultColorSelectionModel {
        private static final long serialVersionUID = 7526471155622776147L;
        private Color committedColor;
        private boolean noColor;

        JaxoColorSelectionModel() {
            super(Color.black);
            this.committedColor = this.getColor();
            this.noColor = false;
        }

        public void reset() {
            this.setSelectedColor(this.committedColor);
        }

        public void commit() {
            this.committedColor = this.getColor();
        }

        public boolean isEqualColor(Color c) {
            return c == null ? this.noColor : c.equals(this.getSelectedColor());
        }

        public void setSelectedColor(Color c) {
            if ((JaxoColorChooser.this.dialog == null || !JaxoColorChooser.this.dialog.isVisible()) && c != null && c.equals(this.getSelectedColor())) {
                return;
            }
            boolean oldNoColor = this.noColor;
            this.noColor = c == null;
            super.setSelectedColor(this.noColor ? Color.black : c);
            if (this.noColor != oldNoColor) {
                this.fireStateChanged();
                JaxoColorChooser.this.updateNoColor();
            }
        }

        public boolean hasChanged() {
            return this.noColor ? this.committedColor != null : !this.getSelectedColor().equals(this.committedColor);
        }

        public void setNoColor(boolean value) {
            this.setSelectedColor(value ? null : Color.black);
        }

        public boolean isNoColor() {
            return this.noColor;
        }

        public final Color getColor() {
            return this.noColor ? null : this.getSelectedColor();
        }

        protected void fireStateChanged() {
            super.fireStateChanged();
            JaxoColorChooser.this.fireStateChanged();
        }
    }
}

