/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.panel.JaxoChooseFile;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.plugin.JaxoImportPlugin;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoLooknFeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoImportPanel
implements JaxoLocalized {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoImportPanel.class);
    private final JDialog dialog;
    private final Component parent;
    private List<JaxoImportPlugin> imports;
    private JComboBox chooseFileFormat;
    private JTextField chooseFileName;
    private JaxoImportPlugin oldSelectedImport;
    private JComponent configurationPanelParent;
    private JButton importButton;
    private JButton cancelButton;
    private JLabel fileFormatLabel;
    private JLabel fileNameLabel;
    private JaxoGraph importedGraph;

    public JaxoImportPanel(Component parentc, List<JaxoImportPlugin> imp) {
        this.parent = parentc;
        this.imports = new ArrayList<JaxoImportPlugin>(imp);
        this.dialog = JaxoDialogs.newDialog(this.parent, "", true);
    }

    public void setImports(List<JaxoImportPlugin> impts) {
        this.imports = new ArrayList<JaxoImportPlugin>(impts);
    }

    @Override
    public void updateLanguage() {
        if (this.importButton == null) {
            return;
        }
        this.importButton.setText(LANGUAGE.value("/Import"));
        this.cancelButton.setText(LANGUAGE.value("/Cancel"));
        this.fileFormatLabel.setText(LANGUAGE.label("/File_format"));
        this.fileNameLabel.setText(LANGUAGE.label("/File_name"));
        this.configurationPanelParent.setBorder(this.getImportPanelBorder());
        for (int i = 0; i < this.chooseFileFormat.getItemCount(); ++i) {
            Object o = this.chooseFileFormat.getItemAt(i);
            if (!(o instanceof JaxoImportPlugin)) continue;
            ((JaxoImportPlugin)o).updateLanguage();
        }
        this.dialog.setTitle(JaxoDialogs.windowTitle(LANGUAGE, "/Import"));
    }

    public void show() {
        this.importedGraph = null;
        this.setupFileFormatComboBox();
        JPanel optionsPanel = this.getOptionsPanel();
        this.updateSelectedImport();
        this.dialog.getContentPane().removeAll();
        this.dialog.getContentPane().add(optionsPanel);
        this.dialog.getContentPane().add((Component)this.getButtonPanel(), "Last");
        this.updateLanguage();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.setVisible(true);
    }

    private JPanel getOptionsPanel() {
        this.chooseFileName = new JTextField(24);
        JPanel optionsPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints labels = new GridBagConstraints();
        GridBagConstraints components = new GridBagConstraints();
        labels.anchor = 22;
        components.fill = 1;
        labels.gridx = 0;
        labels.gridy = 0;
        components.gridx = 1;
        components.gridy = 0;
        this.fileFormatLabel = new JLabel("", 11);
        optionsPanel.add((Component)this.fileFormatLabel, labels);
        optionsPanel.add((Component)this.chooseFileFormat, components);
        ++labels.gridy;
        ++components.gridy;
        JPanel chooseFileNamePanel = JaxoDialogs.newLineBoxLayoutPanel();
        JButton openFileChooser = new JButton("...");
        chooseFileNamePanel.add(this.chooseFileName);
        chooseFileNamePanel.add(openFileChooser);
        openFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoImportPanel.this.chooseFileName();
            }
        });
        this.fileNameLabel = new JLabel("", 11);
        optionsPanel.add((Component)this.fileNameLabel, labels);
        optionsPanel.add((Component)chooseFileNamePanel, components);
        ++labels.gridy;
        ++components.gridy;
        this.configurationPanelParent = new JPanel(new BorderLayout(), false){
            private static final long serialVersionUID = 7526471155622L;

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        components.gridx = 0;
        components.gridwidth = 2;
        components.weightx = 1.0;
        components.weighty = 1.0;
        optionsPanel.add((Component)this.configurationPanelParent, components);
        components.gridx = 1;
        components.gridwidth = 1;
        components.weighty = 0.0;
        ++labels.gridy;
        ++components.gridy;
        components.gridx = 1;
        components.gridwidth = 1;
        components.weighty = 0.0;
        ++labels.gridy;
        ++components.gridy;
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        optionsPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "pressed");
        optionsPanel.getActionMap().put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 75264711556227767L;

            public final void actionPerformed(ActionEvent e) {
                JaxoImportPanel.this.cancelButtonClicked();
            }
        });
        return optionsPanel;
    }

    private JPanel getButtonPanel() {
        this.importButton = new JButton();
        this.importButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoImportPanel.this.importButtonClicked();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoImportPanel.this.cancelButtonClicked();
            }
        });
        JPanel buttonPanel = new JPanel(false);
        buttonPanel.add(this.importButton);
        buttonPanel.add(this.cancelButton);
        return buttonPanel;
    }

    private void setupFileFormatComboBox() {
        DefaultComboBoxModel fileFormats = new DefaultComboBoxModel(){
            private static final long serialVersionUID = 7526471155622777L;

            public void setSelectedItem(Object value) {
                if (value instanceof JaxoImportPlugin) {
                    super.setSelectedItem(value);
                } else {
                    int selectedIndex;
                    int index = this.getIndexOf(value);
                    if (index < (selectedIndex = this.getIndexOf(this.getSelectedItem())) && index > 0) {
                        this.setSelectedItem(this.getElementAt(index - 1));
                    } else if (index > selectedIndex && index < this.getSize() - 1) {
                        this.setSelectedItem(this.getElementAt(index + 1));
                    }
                }
            }
        };
        boolean addSeparator = false;
        for (JaxoImportPlugin o : this.imports) {
            if (o instanceof List) {
                if (addSeparator) {
                    fileFormats.addElement(new Object());
                }
                Iterator j = ((List)((Object)o)).iterator();
                while (j.hasNext()) {
                    fileFormats.addElement(j.next());
                }
                addSeparator = true;
                continue;
            }
            if (addSeparator) {
                fileFormats.addElement(new Object());
            }
            fileFormats.addElement(o);
            addSeparator = false;
        }
        this.chooseFileFormat = new JComboBox(fileFormats);
        this.chooseFileFormat.setMaximumRowCount(20);
        this.chooseFileFormat.setSelectedIndex(0);
        this.chooseFileFormat.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                if (JaxoImportPanel.this.oldSelectedImport != JaxoImportPanel.this.chooseFileFormat.getSelectedItem()) {
                    JaxoImportPanel.this.updateSelectedImport();
                    JaxoImportPanel.this.oldSelectedImport = (JaxoImportPlugin)JaxoImportPanel.this.chooseFileFormat.getSelectedItem();
                }
            }
        });
        this.oldSelectedImport = (JaxoImportPlugin)this.chooseFileFormat.getSelectedItem();
        this.chooseFileFormat.setRenderer(new BasicComboBoxRenderer(){
            private static final long serialVersionUID = 7526471155622777L;
            private JSeparator separator = new JSeparator();
            {
                JaxoLooknFeel.registerComponent(this);
                JaxoLooknFeel.registerComponent(this.separator);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
                if (!(value instanceof JaxoImportPlugin)) {
                    return this.separator;
                }
                JaxoImportPlugin e = (JaxoImportPlugin)value;
                return super.getListCellRendererComponent((JList<?>)list, e.getFormatName(), index, selected, focused);
            }
        });
    }

    private CompoundBorder getImportPanelBorder() {
        String title = LANGUAGE.value("/Options");
        return BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), new JaxoTitledBorder(title)), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    private void chooseFileName() {
        String extension = this.getSelectedImport().getFileExtension();
        String describe = this.getSelectedImport().getFileExtensionDescription();
        JaxoChooseFile c = new JaxoChooseFile(this.parent);
        c.setApproveText(LANGUAGE.value("fileChooser.approveText"));
        c.setDialogTitle(LANGUAGE.value("fileChooser.dialogTitle"));
        String fileName = c.chooseFile(new String[]{extension}, describe, this.chooseFileName.getText()).trim();
        if (fileName.length() > 0) {
            this.chooseFileName.setText(fileName);
            this.addExtension();
        }
    }

    private void updateSelectedImport() {
        this.cutExtension();
        this.addExtension();
        this.configurationPanelParent.add(this.getSelectedImport().getConfigurationPanel());
        this.configurationPanelParent.removeAll();
        this.configurationPanelParent.revalidate();
        this.configurationPanelParent.repaint();
        if (this.dialog.isVisible()) {
            Dimension d1 = this.dialog.getPreferredSize();
            Dimension d2 = this.dialog.getSize();
            d2.width = Math.max(d2.width, d1.width);
            d2.height = Math.max(d2.height, d1.height);
            this.dialog.setSize(d2);
        }
    }

    private JaxoImportPlugin getSelectedImport() {
        JaxoImportPlugin e = (JaxoImportPlugin)this.chooseFileFormat.getSelectedItem();
        if (e != null) {
            e.setParentComponent(this.dialog);
        }
        return e;
    }

    private void cutExtension() {
        String extension = this.oldSelectedImport.getFileExtension();
        String fileName = this.chooseFileName.getText().trim();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && fileName.substring(index + 1).equals(extension)) {
            fileName = fileName.substring(0, index);
            this.chooseFileName.setText(fileName);
        }
    }

    private void addExtension() {
        String extension = this.getSelectedImport().getFileExtension();
        String fileName = this.chooseFileName.getText();
        String newFileName = JaxoIO.withExtension(fileName.trim(), extension);
        if (!newFileName.equals(fileName)) {
            this.chooseFileName.setText(newFileName);
        }
    }

    private void importButtonClicked() {
        JaxoImportPlugin e = this.getSelectedImport();
        if (e == null) {
            this.dialog.dispose();
            return;
        }
        this.cutExtension();
        this.addExtension();
        String fileName = this.chooseFileName.getText().trim();
        if (this.chooseFileName.getText().length() == 0) {
            this.chooseFileName();
            fileName = this.chooseFileName.getText().trim();
            if (fileName.length() == 0) {
                return;
            }
        }
        e.commitConfiguration();
        this.importedGraph = e.importGraph(fileName);
        this.dialog.dispose();
    }

    private void cancelButtonClicked() {
        this.dialog.dispose();
    }

    public JaxoGraph getImportedGraph() {
        return this.importedGraph;
    }
}

