/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.border.TitledBorder;
import net.sf.jaxodraw.gui.panel.button.JaxoColorButton;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoLanguage;

public class JaxoColorEditPanel
extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JaxoColorButton colorButton;
    private transient JCheckBox filledBox;

    public JaxoColorEditPanel() {
        this(1, false, JaxoColor.BLACK, true);
    }

    public JaxoColorEditPanel(Color buttonColor) {
        this(1, false, buttonColor, true);
    }

    public JaxoColorEditPanel(int type, boolean disabled, Color buttonColor) {
        this(type, disabled, buttonColor, true);
    }

    public JaxoColorEditPanel(boolean disabled, Color buttonColor, boolean filled) {
        this(3, disabled, buttonColor, filled);
    }

    private JaxoColorEditPanel(int type, boolean disabled, Color buttonColor, boolean filled) {
        int check = type;
        if (check < 1 || check > 3) {
            check = 1;
        }
        this.colorButton = new JaxoColorButton(buttonColor);
        String title = this.getTitle(check);
        TitledBorder panelBorder = this.createI18NBorder(title);
        if (disabled) {
            super.setEnabled(false);
            panelBorder.setTitleColor(JaxoColor.GRAYSCALE165);
            this.colorButton.setEnabled(false);
        }
        this.colorButton.setActionCommand(this.getActionCommand(check));
        this.setBorder(panelBorder);
        this.add(this.colorButton);
        if (check == 3) {
            this.setLayout(new GridLayout(2, 0, 0, 10));
            this.filledBox = new JCheckBox(JaxoLanguage.translate("JaxoColorEditPanel.fillColor.filled"));
            this.filledBox.setSelected(filled);
            this.filledBox.setActionCommand("Filled");
            this.add(this.filledBox);
        } else {
            this.setLayout(new GridLayout(1, 0));
        }
    }

    public void setColor(Color color) {
        this.colorButton.setColor(color);
    }

    public Color getColor() {
        return this.colorButton.getColor();
    }

    public void setEnabled(boolean value) {
        if (this.colorButton.isEnabled() != value) {
            this.colorButton.setEnabled(value);
            TitledBorder b = this.createBorder(((TitledBorder)this.getBorder()).getTitle());
            if (!value) {
                b.setTitleColor(JaxoColor.GRAYSCALE165);
            }
            this.setBorder(b);
        }
        super.setEnabled(value);
    }

    public void addEditPanelListener(JaxoEditPanelListener listener) {
        if (listener != null) {
            this.colorButton.addActionListener(listener);
            if (this.filledBox != null) {
                this.filledBox.addActionListener(listener);
            }
        }
    }

    private String getActionCommand(int type) {
        String result = "Color";
        if (type == 2) {
            result = "Line_color";
        } else if (type == 3) {
            result = "Fill_color";
        }
        return result;
    }

    private String getTitle(int type) {
        String result = "JaxoColorEditPanel.color.title";
        if (type == 2) {
            result = "JaxoColorEditPanel.lineColor.title";
        } else if (type == 3) {
            result = "JaxoColorEditPanel.fillColor.title";
        }
        return result;
    }
}

