/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.gui.panel.edit.Jaxo2PointsEditPanel;
import net.sf.jaxodraw.gui.panel.edit.Jaxo3PointsEditPanel;
import net.sf.jaxodraw.gui.panel.edit.Jaxo4PointsEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoArrowEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoCenterSizeEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoColorEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoDLEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoDashEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.gui.panel.edit.JaxoLatexAlignPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoLatexFontSizePanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanelListener;
import net.sf.jaxodraw.gui.panel.edit.JaxoPSFontPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoPositionEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoRotationEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoScaleEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoStretchingEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoStrokeEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoSymmEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoTextEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoWiggleEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoXYREditPanel;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoOptionsPanel
extends JPanel
implements JaxoObjectEditPanel {
    private static List<Integer> rotationAngles = new ArrayList<Integer>(4);
    private static final long serialVersionUID = 7526471155622776147L;
    private final GridBagConstraints panelConstraints = new GridBagConstraints();
    private JaxoEditPanelListener internalListener;
    private JaxoObject object;
    private JaxoObject backup;
    private String title;
    private Icon icon;
    private ChangeEvent event;

    public JaxoOptionsPanel(JaxoObject ob) {
        super(new GridBagLayout());
        this.panelConstraints.insets = new Insets(5, 5, 5, 5);
        this.setObject(ob);
    }

    public static List<Integer> getRotationAngleDefaults() {
        return rotationAngles;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] pairs = this.listenerList.getListenerList();
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != ChangeListener.class) continue;
            if (this.event == null) {
                this.event = new ChangeEvent(this);
            }
            ((ChangeListener)pairs[i + 1]).stateChanged(this.event);
        }
    }

    public final void setObject(JaxoObject value) {
        if (value != this.object) {
            this.object = value;
            this.backup = this.object.copy();
            this.internalListener = new JaxoOptionsPanelListener(this.object, new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JaxoOptionsPanel.this.fireStateChanged();
                }
            });
            this.updatePanels();
        }
    }

    public final JaxoObject getObject() {
        return this.object;
    }

    @Override
    public final void add3PointsPanel(Point[] points, int gridx, int gridy) {
        this.add3PointsPanel(points, gridx, gridy, 1);
    }

    @Override
    public final void add3PointsPanel(Point[] points, int gridx, int gridy, int gridwidth) {
        Jaxo3PointsEditPanel panel = new Jaxo3PointsEditPanel(points);
        this.addPanel(panel, gridx, gridy, gridwidth);
    }

    @Override
    public final void add4PointsPanel(Point[] points, int gridx, int gridy) {
        this.add4PointsPanel(points, gridx, gridy, 1);
    }

    @Override
    public final void add4PointsPanel(Point[] points, int gridx, int gridy, int gridwidth) {
        Jaxo4PointsEditPanel panel = new Jaxo4PointsEditPanel(points);
        this.addPanel(panel, gridx, gridy, gridwidth);
    }

    @Override
    public final void addPositionPanel(int x, int y, int gridx, int gridy) {
        JaxoPositionEditPanel panel = new JaxoPositionEditPanel(x, y);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void add2PointsPanel(Point[] points, int gridx, int gridy) {
        Jaxo2PointsEditPanel panel = new Jaxo2PointsEditPanel(points);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addXYRPanel(int x, int y, int r, int gridx, int gridy) {
        JaxoXYREditPanel panel = new JaxoXYREditPanel(x, y, r);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addCenterSizePanel(int x, int y, int w, int h, int gridx, int gridy) {
        JaxoCenterSizeEditPanel panel = new JaxoCenterSizeEditPanel(x, y, w, h);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addDashPanel(float dash, int gridx, int gridy) {
        JaxoDashEditPanel panel = new JaxoDashEditPanel(dash);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addStrokePanel(float width, int gridx, int gridy) {
        JaxoStrokeEditPanel panel = new JaxoStrokeEditPanel(width);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addReScalePanel(int gridx, int gridy) {
        JaxoScaleEditPanel finalScalePanel = new JaxoScaleEditPanel();
        this.addPanel(finalScalePanel, gridx, gridy);
    }

    @Override
    public final void addWigglePanel(int amp, int wiggles, int gridx, int gridy) {
        JaxoWiggleEditPanel panel = new JaxoWiggleEditPanel(amp, wiggles);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addWigglePanel(int amp, int gridx, int gridy) {
        JaxoWiggleEditPanel wigglePanel = new JaxoWiggleEditPanel(amp);
        this.addPanel(wigglePanel, gridx, gridy);
    }

    @Override
    public final void addSymmPanel(boolean symm, int gridx, int gridy) {
        JaxoSymmEditPanel symPanel = new JaxoSymmEditPanel(symm);
        this.addPanel(symPanel, gridx, gridy);
    }

    @Override
    public final void addStretchingPanel(boolean noFreqStretching, int gridx, int gridy) {
        JaxoStretchingEditPanel panel = new JaxoStretchingEditPanel(noFreqStretching);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addRotationPanel(int angle, int gridx, int gridy) {
        JaxoRotationEditPanel panel = new JaxoRotationEditPanel(angle);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addArrowPanel(boolean arrow, boolean flip, float oldPosition, int gridx, int gridy) {
        JaxoArrowEditPanel arrowPanel = new JaxoArrowEditPanel(arrow, flip, oldPosition);
        this.addPanel(arrowPanel, gridx, gridy);
    }

    @Override
    public final void addArrowOptionsEditPanel(JaxoArrow arrow, int gridx, int gridy) {
        this.addPanel(arrow.getEditPanel(), gridx, gridy);
    }

    @Override
    public final void addDoubleLinePanel(boolean dLine, float dlSep, int gridx, int gridy) {
        JaxoDLEditPanel dlPanel = new JaxoDLEditPanel(dLine, dlSep);
        this.addPanel(dlPanel, gridx, gridy);
    }

    @Override
    public final void addLineColorPanel(Color color, int gridx, int gridy) {
        int type = 2;
        JaxoColorEditPanel panel = new JaxoColorEditPanel(2, false, color);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addFillLineColorPanels(Color color, Color fillColor, boolean isFilled, int fillX, int fillY, int lineX, int lineY) {
        boolean disable = JaxoColor.isGrayScale(fillColor);
        JaxoColorEditPanel linePanel = new JaxoColorEditPanel(2, disable, color);
        this.addPanel(linePanel, lineX, lineY);
        JaxoColorEditPanel fillPanel = new JaxoColorEditPanel(false, fillColor, isFilled);
        this.addPanel(fillPanel, fillX, fillY);
        final WeakReference<JaxoColorEditPanel> weakLinePanel = new WeakReference<JaxoColorEditPanel>(linePanel);
        final WeakReference<JaxoColorEditPanel> weakFillPanel = new WeakReference<JaxoColorEditPanel>(fillPanel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JaxoColorEditPanel l = (JaxoColorEditPanel)weakLinePanel.get();
                JaxoColorEditPanel f = (JaxoColorEditPanel)weakFillPanel.get();
                if (l == null || f == null) {
                    JaxoOptionsPanel.this.removeChangeListener(this);
                } else if (JaxoPrefs.getIntPref("prefCOLORSPACE") == 2) {
                    l.setEnabled(true);
                } else {
                    boolean isGrayScale = JaxoColor.isGrayScale(f.getColor());
                    if (isGrayScale) {
                        l.setColor(JaxoColor.BLACK);
                    }
                    l.setEnabled(!isGrayScale);
                }
            }
        });
    }

    @Override
    public final void addColorPanel(Color color, int type, int gridx, int gridy) {
        JaxoColorEditPanel colorPanel = new JaxoColorEditPanel(type, false, color);
        this.addPanel(colorPanel, gridx, gridy);
    }

    @Override
    public final void addTextPanel(String text, int gridx, int gridy) {
        JaxoTextEditPanel textPanel = new JaxoTextEditPanel(text);
        this.addPanel(textPanel, gridx, gridy);
    }

    @Override
    public final void addPSFontPanel(Font font, int gridx, int gridy, int gridwidth) {
        JaxoPSFontPanel fontPanel = new JaxoPSFontPanel(font);
        this.addPanel(fontPanel, gridx, gridy, gridwidth);
    }

    @Override
    public final void addLatexAlignPanel(int allign, int gridx, int gridy) {
        JaxoLatexAlignPanel panel = new JaxoLatexAlignPanel(allign);
        this.addPanel(panel, gridx, gridy);
    }

    @Override
    public final void addLatexFontSizePanel(int size, int gridx, int gridy) {
        JaxoLatexFontSizePanel panel = new JaxoLatexFontSizePanel(size);
        this.addPanel(panel, gridx, gridy);
    }

    private void addPanel(JaxoEditPanel panel, int gridx, int gridy) {
        this.addPanel(panel, gridx, gridy, 1);
    }

    private void addPanel(JaxoEditPanel panel, int gridx, int gridy, int gridwidth) {
        if (panel == null) {
            return;
        }
        panel.addEditPanelListener(this.internalListener);
        this.panelConstraints.gridx = gridx;
        this.panelConstraints.gridy = gridy;
        this.panelConstraints.gridwidth = gridwidth;
        this.add((Component)panel, this.panelConstraints);
    }

    @Override
    public final void show(Component parent, Location l) {
        this.showDialog(parent, l);
    }

    @Override
    public boolean hasChanged() {
        return this.backup != null && !this.backup.isCopy(this.object);
    }

    @Override
    public void setTitleAndIcon(String newTitle, String newIcon) {
        this.title = JaxoLanguage.translate(newTitle);
        this.icon = JaxoUtils.newImageIcon(newIcon);
    }

    protected void resetObject() {
        this.object.setState(this.backup);
        this.updatePanels();
    }

    private void updatePanels() {
        this.removeAll();
        this.object.prepareEditPanel(this);
        this.revalidate();
        this.repaint();
        this.fireStateChanged();
    }

    protected final void showDialog(Component parent, Location l) {
        JButton reset = new JButton(JaxoLanguage.translate("Reset"));
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoOptionsPanel.this.resetObject();
            }
        });
        Object[] optionButtons = new Object[]{JaxoLanguage.translate("Accept"), reset, JaxoLanguage.translate("Cancel")};
        JOptionPane p = new JOptionPane(this, -1, 2, this.icon, optionButtons, optionButtons[0]);
        JDialog d = p.createDialog(parent, this.title);
        l.setLocation(d);
        d.setVisible(true);
        d.dispose();
        if (!optionButtons[0].equals(p.getValue())) {
            this.object.setState(this.backup);
            this.fireStateChanged();
        }
    }

    static {
        rotationAngles.add(-135);
        rotationAngles.add(-90);
        rotationAngles.add(-45);
        rotationAngles.add(0);
        rotationAngles.add(45);
        rotationAngles.add(90);
        rotationAngles.add(135);
        rotationAngles.add(180);
        rotationAngles = Collections.unmodifiableList(rotationAngles);
    }
}

