/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import net.sf.jaxodraw.gui.panel.JaxoPrefsPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.gui.swing.JaxoFontStyleRenderer;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerComboBox;
import net.sf.jaxodraw.object.text.JaxoPSText;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoPrefs;

public class JaxoPSFontPanel
extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JComboBox famcomb = new JComboBox<Object>(JaxoPrefsPanel.getSystemFonts().toArray());
    private transient JComboBox sizecomb;
    private transient JComboBox stycomb;

    public JaxoPSFontPanel() {
        this(new Font(JaxoPrefs.getStringPref("prefPSFAMILY"), JaxoPrefs.getIntPref("prefPSSTYLE"), JaxoPrefs.getIntPref("prefPSSIZE")));
    }

    public JaxoPSFontPanel(Font font) {
        int fontStyle;
        int fontSize;
        int fontIndex;
        this.famcomb.setName("psfontname");
        if (font == null) {
            fontIndex = -1;
        } else {
            fontIndex = JaxoPrefsPanel.getSystemFonts().indexOf(font.getFamily());
            if (fontIndex == -1) {
                fontIndex = 0;
            }
        }
        this.famcomb.setSelectedIndex(fontIndex);
        JPanel textFamilyPanel = new JPanel();
        JLabel textFamilyLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.family"), 11);
        textFamilyPanel.add(textFamilyLabel);
        textFamilyPanel.add(this.famcomb);
        final JSpinner size = this.getSpinner(1, 1, 300, 2, (String)null);
        this.sizecomb = new JaxoSpinnerComboBox(size, JaxoPSText.getFontSizeDefaults());
        this.sizecomb.setName("psfontsize");
        if (font == null) {
            fontSize = JaxoPrefs.getIntPref("prefPSSIZE");
            size.setEnabled(false);
            this.sizecomb.setEnabled(false);
        } else {
            fontSize = font.getSize();
        }
        size.setValue(fontSize);
        JPanel textSizePanel = new JPanel();
        JLabel textSizeLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.size"), 11);
        textSizePanel.add(textSizeLabel);
        textSizePanel.add(this.sizecomb);
        this.stycomb = new JComboBox<Object>(JaxoPSText.getFontStyles().toArray());
        this.stycomb.setName("psfontstyle");
        this.stycomb.setRenderer(new JaxoFontStyleRenderer());
        if (font == null) {
            fontStyle = JaxoPrefs.getIntPref("prefPSSTYLE");
            this.stycomb.setEnabled(false);
        } else {
            fontStyle = font.getStyle();
        }
        this.stycomb.setSelectedItem(fontStyle);
        this.famcomb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!size.isEnabled()) {
                    size.setEnabled(true);
                    JaxoPSFontPanel.this.sizecomb.setEnabled(true);
                    JaxoPSFontPanel.this.stycomb.setEnabled(true);
                }
            }
        });
        JPanel textStylePanel = new JPanel();
        JLabel textStyleLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.style"), 11);
        textStylePanel.add(textStyleLabel);
        textStylePanel.add(this.stycomb);
        this.setLayout(new BorderLayout());
        this.setBorder(this.createI18NBorder("JaxoPSFontPanel.title"));
        this.add("Before", textFamilyPanel);
        this.add("Center", textSizePanel);
        this.add("After", textStylePanel);
    }

    public void addEditPanelListener(JaxoEditPanelListener listener) {
        if (listener != null) {
            this.famcomb.addItemListener(listener);
            this.sizecomb.addItemListener(listener);
            this.stycomb.addItemListener(listener);
        }
    }
}

