/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;

public class JaxoXYREditPanel
extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner spxin;
    private transient JSpinner spyin;
    private transient JSpinner sprad;

    public JaxoXYREditPanel() {
        this(200, 200, 200);
    }

    public JaxoXYREditPanel(int x, int y, int r) {
        Dimension size = new Dimension(120, 20);
        GridLayout layout = new GridLayout(0, 2);
        JPanel pxin = new JPanel();
        pxin.setLayout(layout);
        SpinnerNumberModel modelXin = new SpinnerNumberModel();
        modelXin.setValue(x);
        JLabel xin = this.createLabel("X: ");
        pxin.add(xin);
        this.spxin = new JaxoFixedJSpinner(modelXin);
        this.spxin.setName("spxin");
        pxin.add(this.spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(layout);
        SpinnerNumberModel modelYin = new SpinnerNumberModel();
        modelYin.setValue(y);
        JLabel yin = this.createLabel("Y: ");
        pyin.add(yin);
        this.spyin = new JaxoFixedJSpinner(modelYin);
        this.spyin.setName("spyin");
        pyin.add(this.spyin);
        JPanel prad = new JPanel();
        prad.setLayout(layout);
        SpinnerNumberModel modelrad = new SpinnerNumberModel(r, 0, Integer.MAX_VALUE, 1);
        JLabel rad = this.createI18NLabel("JaxoXYREditPanel.radius");
        prad.add(rad);
        this.sprad = new JaxoFixedJSpinner(modelrad);
        this.sprad.setName("sprad");
        prad.add(this.sprad);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        pxin.setPreferredSize(size);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pyin.setPreferredSize(size);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.gridheight = 2;
        sc.insets = new Insets(0, 0, 5, 5);
        prad.setPreferredSize(size);
        dimSPanel.add((Component)prad, sc);
        this.setLineBoxLayout();
        TitledBorder dimSTitle = this.createI18NBorder("JaxoXYREditPanel.title");
        this.setBorder(dimSTitle);
        this.add(dimSPanel);
    }

    public void addEditPanelListener(JaxoEditPanelListener listener) {
        if (listener != null) {
            this.spxin.addChangeListener(listener);
            this.spyin.addChangeListener(listener);
            this.sprad.addChangeListener(listener);
        }
    }
}

