/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.swing;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLooknFeel;

public class JaxoFontStyleRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoFontStyleRenderer.class);
    private String none;
    private String plain;
    private String bold;
    private String italic;
    private String boldItalic;

    public JaxoFontStyleRenderer() {
        JaxoLooknFeel.registerComponent(this);
    }

    public void updateUI() {
        super.updateUI();
        this.none = LANGUAGE.value("/FontStyle.none");
        this.plain = LANGUAGE.value("/FontStyle.plain");
        this.bold = LANGUAGE.value("/FontStyle.bold");
        this.italic = LANGUAGE.value("/FontStyle.italic");
        this.boldItalic = LANGUAGE.value("/FontStyle.boldItalic");
    }

    public void setFont(Font font) {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        Object newValue = value;
        if (newValue == null) {
            newValue = -1;
        }
        int style = (Integer)newValue;
        switch (style) {
            case 0: {
                text = this.plain;
                break;
            }
            case 1: {
                text = this.bold;
                break;
            }
            case 2: {
                text = this.italic;
                break;
            }
            case 3: {
                text = this.boldItalic;
                break;
            }
            default: {
                text = this.none;
            }
        }
        super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        if (style >= 0) {
            super.setFont(list.getFont().deriveFont((Integer)newValue));
        } else {
            super.setFont(list.getFont());
        }
        return this;
    }
}

