/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.io.imports.JaxoAxodraw4J;
import net.sf.jaxodraw.io.imports.JaxoImport;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLog;

public final class JaxoImportAxodraw
extends JaxoImport {
    private final JaxoDictionary language = new JaxoDictionary(JaxoImportAxodraw.class);
    private static final String PLUGIN_ID = JaxoImportAxodraw.class.getName();
    private String fileDescription = this.language.value("fileDescription");
    private String description = this.language.value("description");

    public String getFormatName() {
        return "LaTeX (axodraw4j)";
    }

    public String getFileExtension() {
        return "tex";
    }

    public String getFileExtensionDescription() {
        return this.fileDescription;
    }

    public String getShortName() {
        return "axodraw-import";
    }

    public String pluginId() {
        return PLUGIN_ID;
    }

    public void updateLanguage() {
        this.fileDescription = this.language.value("fileDescription");
        this.description = this.language.value("description");
    }

    public JaxoGraph importGraph(InputStream inputStream) throws JaxoPluginExecutionException {
        JaxoGraph openedGraph = new JaxoGraph();
        JaxoAxodraw4J axo = new JaxoAxodraw4J();
        BufferedReader in = null;
        String charsetName = this.getCharsetName();
        if (charsetName == null) {
            in = new BufferedReader(new InputStreamReader(inputStream));
        } else {
            try {
                in = new BufferedReader(new InputStreamReader(inputStream, charsetName));
            }
            catch (UnsupportedEncodingException ex) {
                if (JaxoLog.isLoggable(JaxoLog.DEBUG)) {
                    JaxoLog.debug("Unsupported encoding: " + charsetName + ", using system default.");
                }
                in = new BufferedReader(new InputStreamReader(inputStream));
            }
        }
        try {
            boolean somethingMissing;
            String str;
            boolean[] isValid = axo.getValid();
            while ((str = in.readLine()) != null) {
                str = str.trim();
                axo.checkRequired(str);
                isValid = axo.getValid();
                if (!isValid[2]) continue;
            }
            openedGraph.setPackageList(axo.getPackages());
            isValid = axo.getValid();
            boolean bl = somethingMissing = !isValid[0] || !isValid[1] || !isValid[2];
            if (somethingMissing) {
                String missing = "";
                if (!isValid[0]) {
                    missing = "\\documentclass";
                } else if (!isValid[1]) {
                    missing = "\\begin{document}";
                } else if (!isValid[2]) {
                    missing = "\\begin{picture}";
                }
                String msg = this.language.message("missingCommand%0", missing);
                throw new JaxoPluginExecutionException(msg, this);
            }
            while ((str = in.readLine()) != null) {
                openedGraph.addObject(axo.getJaxoObject(str.trim()));
            }
            openedGraph.setDescription(axo.getComment());
        }
        catch (IOException e) {
            throw new JaxoPluginExecutionException(this.language.value("parsingFailed"), e, in);
        }
        finally {
            this.close(in);
        }
        openedGraph.setSaved(false);
        return openedGraph;
    }

    public String description() {
        return this.description;
    }
}

