/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxoObject
implements Serializable,
Cloneable,
Shape,
PropertyChangeListener {
    public static final int SELECT_NONE = -1;
    public static final int SELECT_P1 = 0;
    public static final DecimalFormat D_FORMAT = new DecimalFormat("######.###", new DecimalFormatSymbols(new Locale("en", "US")));
    public static final DecimalFormat GRAY_SCALE_FORMAT = new DecimalFormat("#.###", new DecimalFormatSymbols(new Locale("en", "US")));
    private static final long serialVersionUID = 2L;
    private static final int POINT_COUNT = 1;
    private Color color;
    private int x;
    private int y;
    private transient GeneralPath gp = new GeneralPath();
    private transient boolean marked;
    private transient PropertyChangeSupport pceListeners = new PropertyChangeSupport(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        JaxoObject jaxoObject = this;
        synchronized (jaxoObject) {
            this.pceListeners.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        JaxoObject jaxoObject = this;
        synchronized (jaxoObject) {
            this.pceListeners.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pceListeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected static void setTransient(Class<?> c, String[] propertyNames) {
        BeanInfo b = null;
        try {
            b = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        PropertyDescriptor[] pp = b.getPropertyDescriptors();
        for (int i = 0; i < pp.length; ++i) {
            for (int j = 0; j < propertyNames.length; ++j) {
                if (!propertyNames[j].equals(pp[i].getName())) continue;
                pp[i].setValue("transient", Boolean.TRUE);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.gp = new GeneralPath();
        this.pceListeners = new PropertyChangeSupport(this);
    }

    public int getPointCount() {
        return 1;
    }

    public void setPointCount(int value) {
        if (value != this.getPointCount()) {
            throw new IllegalArgumentException();
        }
    }

    public Point[] getPoints() {
        int count = this.getPointCount();
        Point[] result = new Point[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new Point(this.getX(i), this.getY(i));
        }
        return result;
    }

    public void setPoints(Point[] value) {
        this.setPointCount(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.setX(i, value[i].x);
            this.setY(i, value[i].y);
        }
    }

    public int getX(int index) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        return this.x;
    }

    public int getY(int index) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        return this.y;
    }

    public void setX(int index, int value) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        this.x = value;
    }

    public void setY(int index, int value) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        this.y = value;
    }

    public int getX() {
        return this.getX(0);
    }

    public void setX(int newX) {
        this.setX(0, newX);
    }

    public int getY() {
        return this.getY(0);
    }

    public void setY(int newY) {
        this.setY(0, newY);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        Color old = this.getColor();
        this.color = c;
        this.firePropertyChange("color", old, c);
    }

    public void setLocation(int newX, int newY) {
        this.setX(newX);
        this.setY(newY);
    }

    protected final GeneralPath getGeneralPath() {
        return this.gp;
    }

    public final void setAsMarked(boolean mark) {
        this.marked = mark;
    }

    public final boolean isMarked() {
        return this.marked;
    }

    public void moveBy(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            this.setX(this.getX() + deltaX);
            this.setY(this.getY() + deltaY);
        }
    }

    public void setXPosition(int newX) {
        this.moveBy(newX - this.getX(), 0);
    }

    public void setYPosition(int newY) {
        this.moveBy(0, newY - this.getY());
    }

    public void paintVisualAid(JaxoGraphics2D g2) {
    }

    public boolean isCopy(JaxoObject comp) {
        boolean equalColors;
        boolean isCopy = false;
        boolean bl = this.getColor() == null ? comp.getColor() == null : (equalColors = this.getColor().equals(comp.getColor()));
        if (comp.getX() == this.getX() && comp.getY() == this.getY() && equalColors) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoObject temp) {
        this.setX(temp.getX());
        this.setY(temp.getY());
        this.setColor(temp.getColor());
    }

    public void setState(JaxoObject o) {
        this.copyFrom(o);
    }

    public float smallestDistanceTo(int px, int py) {
        int distX = px - this.getX();
        int distY = py - this.getY();
        return (float)Math.sqrt(distX * distX + distY * distY);
    }

    public JaxoObject copy() {
        try {
            JaxoObject copy = (JaxoObject)super.clone();
            copy.gp = new GeneralPath();
            copy.marked = false;
            copy.pceListeners = new PropertyChangeSupport(copy);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public boolean isAround(int select, int clickX, int clickY, JaxoHandle handle) {
        return handle.contains(this.getX(select), this.getY(select), clickX, clickY);
    }

    public int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        if (this.isAround(0, clickX, clickY, h)) {
            return 0;
        }
        return -1;
    }

    public Rectangle2D getBoundsWithHandles(JaxoHandle h) {
        Rectangle2D result = this.getBounds2D();
        for (int i = 0; i < this.getPointCount(); ++i) {
            result.add(h.getBounds(this.getX(i), this.getY(i)));
        }
        return result;
    }

    protected Point2D getLaTexLocation(float scaleFactor, int canvasHeight) {
        Point2D.Float startVec = new Point2D.Float();
        ((Point2D)startVec).setLocation((float)this.getX() / scaleFactor, (float)(canvasHeight - this.getY()) / scaleFactor);
        return startVec;
    }

    public void setPreferences() {
        this.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefCOLOR"), JaxoPrefs.getIntPref("prefCOLORSPACE")));
    }

    public final String getName() {
        String className = this.getClass().getName();
        int firstChar = className.lastIndexOf(46) + 1;
        if (firstChar > 0) {
            className = className.substring(firstChar);
        }
        return className;
    }

    public final void setParameter(String name, Class<?> type, Object value, boolean failOnError) {
        block7: {
            if (name.length() == 0) {
                throw new IllegalArgumentException("Empty parameter name");
            }
            String method = this.setterName(name);
            try {
                Method setter = this.getClass().getMethod(method, type);
                setter.invoke((Object)this, value);
            }
            catch (InvocationTargetException e) {
                if (failOnError) {
                    throw new UnsupportedOperationException(e);
                }
            }
            catch (NoSuchMethodException e) {
                if (failOnError) {
                    throw new UnsupportedOperationException(e);
                }
            }
            catch (IllegalAccessException e) {
                if (!failOnError) break block7;
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public final void setParameter(String name, Class<?> type, Object value) {
        this.setParameter(name, type, value, true);
    }

    public final void setParameter(String name, int value) {
        this.setParameter(name, Integer.TYPE, value);
    }

    public final void setParameter(String name, float value) {
        this.setParameter(name, Float.TYPE, Float.valueOf(value));
    }

    public final void setParameter(String name, boolean value) {
        this.setParameter(name, Boolean.TYPE, value);
    }

    public final void setParameter(String name, Color value) {
        this.setParameter(name, Color.class, value);
    }

    public final void setParameter(String name, String value) {
        this.setParameter(name, String.class, value);
    }

    private String setterName(String paramName) {
        return "set" + this.capitalize(paramName);
    }

    private String capitalize(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        Class<Object> clazz = newValue.getClass();
        if (clazz == Float.class) {
            clazz = Float.TYPE;
        } else if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        } else if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        }
        this.setParameter(name, clazz, newValue, false);
    }

    @Override
    public boolean contains(double x0, double y0) {
        return this.getBounds().contains(x0, y0);
    }

    @Override
    public boolean contains(double x0, double y0, double w, double h) {
        return this.getBounds().contains(x0, y0, w, h);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getBounds().contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.getBounds().contains(r);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.getGeneralPath().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getGeneralPath().getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(double x0, double y0, double w, double h) {
        return this.getBounds().intersects(x0, y0, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.getBounds().intersects(r);
    }

    public abstract void paint(JaxoGraphics2D var1);

    public abstract void paintHandles(JaxoGraphics2D var1, JaxoHandle var2, int var3);

    public abstract boolean canBeSelected(int var1, int var2);

    public abstract String latexCommand(float var1, Dimension var2);

    public abstract String latexWidth();

    public abstract void rescaleObject(int var1, int var2, float var3);

    public abstract void prepareEditPanel(JaxoObjectEditPanel var1);

    static {
        JaxoObject.setTransient(JaxoObject.class, new String[]{"x", "y"});
    }
}

