/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.jaxodraw.object.JaxoObject;

public final class JaxoObjectFactory {
    private static final Map<Integer, String> OBJECT_KEYS = new HashMap<Integer, String>(42);

    private JaxoObjectFactory() {
    }

    public static JaxoObject newObject(int type) {
        String objectId = OBJECT_KEYS.get(type);
        if (objectId == null) {
            throw new NoSuchElementException("No object for this type!");
        }
        return JaxoObjectFactory.getObject(objectId);
    }

    public static JaxoObject newObject(String objectId) {
        if (!OBJECT_KEYS.containsValue(objectId)) {
            throw new NoSuchElementException("No object for this id!");
        }
        return JaxoObjectFactory.getObject(objectId);
    }

    public static JaxoObject newObject(int type, Point[] location) {
        JaxoObject newob = JaxoObjectFactory.newObject(type);
        newob.setPreferences();
        newob.setPoints(location);
        return newob;
    }

    public static void addObjectType(int type, String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("objectId can't be null!");
        }
        if (OBJECT_KEYS.containsValue(objectId)) {
            throw new IllegalArgumentException("duplicate objectId!");
        }
        if (OBJECT_KEYS.containsKey(type)) {
            throw new IllegalArgumentException("type already in use!");
        }
        OBJECT_KEYS.put(type, objectId);
    }

    private static JaxoObject getObject(String objectId) {
        try {
            return (JaxoObject)Class.forName(objectId).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such object: " + objectId, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access: " + objectId, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate: " + objectId, e);
        }
    }

    static {
        OBJECT_KEYS.put(3, "net.sf.jaxodraw.object.line.JaxoFLine");
        OBJECT_KEYS.put(4, "net.sf.jaxodraw.object.loop.JaxoFLoop");
        OBJECT_KEYS.put(5, "net.sf.jaxodraw.object.arc.JaxoFArc");
        OBJECT_KEYS.put(6, "net.sf.jaxodraw.object.line.JaxoSLine");
        OBJECT_KEYS.put(7, "net.sf.jaxodraw.object.loop.JaxoSLoop");
        OBJECT_KEYS.put(8, "net.sf.jaxodraw.object.arc.JaxoSArc");
        OBJECT_KEYS.put(9, "net.sf.jaxodraw.object.line.JaxoGLine");
        OBJECT_KEYS.put(10, "net.sf.jaxodraw.object.loop.JaxoGLoop");
        OBJECT_KEYS.put(11, "net.sf.jaxodraw.object.arc.JaxoGArc");
        OBJECT_KEYS.put(12, "net.sf.jaxodraw.object.line.JaxoPLine");
        OBJECT_KEYS.put(13, "net.sf.jaxodraw.object.loop.JaxoPLoop");
        OBJECT_KEYS.put(14, "net.sf.jaxodraw.object.arc.JaxoPArc");
        OBJECT_KEYS.put(15, "net.sf.jaxodraw.object.line.JaxoGlLine");
        OBJECT_KEYS.put(16, "net.sf.jaxodraw.object.loop.JaxoGlLoop");
        OBJECT_KEYS.put(17, "net.sf.jaxodraw.object.arc.JaxoGlArc");
        OBJECT_KEYS.put(18, "net.sf.jaxodraw.object.bezier.JaxoFBezier");
        OBJECT_KEYS.put(19, "net.sf.jaxodraw.object.bezier.JaxoPBezier");
        OBJECT_KEYS.put(20, "net.sf.jaxodraw.object.bezier.JaxoGlBezier");
        OBJECT_KEYS.put(21, "net.sf.jaxodraw.object.bezier.JaxoSBezier");
        OBJECT_KEYS.put(22, "net.sf.jaxodraw.object.bezier.JaxoGBezier");
        OBJECT_KEYS.put(230, "net.sf.jaxodraw.object.fill.JaxoBox");
        OBJECT_KEYS.put(231, "net.sf.jaxodraw.object.fill.JaxoBlob");
        OBJECT_KEYS.put(233, "net.sf.jaxodraw.object.line.JaxoZigZagLine");
        OBJECT_KEYS.put(234, "net.sf.jaxodraw.object.text.JaxoPSText");
        OBJECT_KEYS.put(235, "net.sf.jaxodraw.object.text.JaxoLatexText");
        OBJECT_KEYS.put(336, "net.sf.jaxodraw.object.vertex.JaxoVertexT1");
        OBJECT_KEYS.put(337, "net.sf.jaxodraw.object.vertex.JaxoVertexT2");
        OBJECT_KEYS.put(338, "net.sf.jaxodraw.object.vertex.JaxoVertexT3");
        OBJECT_KEYS.put(339, "net.sf.jaxodraw.object.vertex.JaxoVertexT4");
        OBJECT_KEYS.put(340, "net.sf.jaxodraw.object.vertex.JaxoVertexT5");
        OBJECT_KEYS.put(341, "net.sf.jaxodraw.object.vertex.JaxoVertexT6");
    }
}

