/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoObjectList<E extends JaxoObject>
extends ArrayList<E>
implements JaxoList<E> {
    private static final long serialVersionUID = 314159L;

    public JaxoObjectList() {
    }

    public JaxoObjectList(Collection<? extends E> c) {
        super(c);
    }

    public JaxoObjectList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void paint(JaxoGraphics2D g) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ((JaxoObject)i.next()).paint(g);
        }
    }

    @Override
    public void paintClipped(JaxoGraphics2D g) {
        for (JaxoObject o : this) {
            Rectangle b = o.getBounds();
            if ((b.width != 0 || b.height != 0) && !g.hitClip(b.x, b.y, b.width, b.height)) continue;
            o.paint(g);
        }
    }

    @Override
    public void paintExcept(Collection<? extends E> excludes, JaxoGraphics2D g) {
        for (JaxoObject o : this) {
            if (excludes.contains(o)) continue;
            o.paint(g);
        }
    }

    @Override
    public void paintClippedExcept(Collection<? extends E> excludes, JaxoGraphics2D g) {
        for (JaxoObject o : this) {
            if (excludes.contains(o)) continue;
            Rectangle b = o.getBounds();
            if ((b.width != 0 || b.height != 0) && !g.hitClip(b.x, b.y, b.width, b.height)) continue;
            o.paint(g);
        }
    }

    @Override
    public JaxoList<E> copyOf() {
        int size = this.size();
        JaxoObjectList<JaxoObject> copyObjectList = new JaxoObjectList<JaxoObject>(size);
        for (int i = 0; i < size; ++i) {
            copyObjectList.add(((JaxoObject)this.get(i)).copy());
        }
        return copyObjectList;
    }

    @Override
    public boolean isCopy(JaxoList<E> list) {
        if (list == null) {
            return false;
        }
        boolean isCopy = false;
        int length = this.size();
        if (length == list.size()) {
            boolean tmp = true;
            for (int i = 0; i < length; ++i) {
                JaxoObject ob1 = (JaxoObject)this.get(i);
                JaxoObject ob2 = (JaxoObject)list.get(i);
                boolean bl = tmp && (ob1 == null ? ob2 == null : ob1.isCopy(ob2)) ? true : (tmp = false);
                if (!tmp) break;
            }
            isCopy = tmp;
        }
        return isCopy;
    }

    @Override
    public void moveAllObjects(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            ((JaxoObject)this.get(i)).moveBy(deltaX, deltaY);
        }
    }

    @Override
    public void setColor(Color c) {
        for (int i = 0; i < this.size(); ++i) {
            ((JaxoObject)this.get(i)).setColor(c);
        }
    }

    @Override
    public void move(int index, int newIndex) {
        if (index == newIndex) {
            return;
        }
        JaxoObject o = (JaxoObject)this.remove(index);
        this.add(newIndex, o);
    }

    @Override
    public boolean toEnd(E object) {
        boolean isLastElement = true;
        int i = this.lastIndexOf(object);
        if (i != this.size() - 1) {
            this.remove(i);
            this.add(object);
            isLastElement = false;
        }
        return isLastElement;
    }

    @Override
    public boolean toFront(E object) {
        boolean isFirstElement = true;
        int i = this.indexOf(object);
        if (i != 0) {
            this.remove(i);
            this.add(0, object);
            isFirstElement = false;
        }
        return isFirstElement;
    }

    @Override
    public boolean removeMarkedObjects() {
        boolean modified = false;
        for (int i = this.size() - 1; i > -1; --i) {
            JaxoObject ob = (JaxoObject)this.get(i);
            if (!ob.isMarked()) continue;
            modified = this.remove(ob);
        }
        return modified;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bBox = null;
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            JaxoObject ob = (JaxoObject)this.get(i);
            Rectangle add = ob.getBounds();
            if (bBox == null) {
                bBox = new Rectangle(add);
                continue;
            }
            bBox.add(add);
        }
        return bBox;
    }

    @Override
    public Rectangle getBoundsExcept(Collection<? extends E> excludes) {
        Rectangle bBox = null;
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            JaxoObject ob = (JaxoObject)this.get(i);
            if (excludes.contains(ob)) continue;
            Rectangle add = ob.getBounds();
            if (bBox == null) {
                bBox = new Rectangle(add);
                continue;
            }
            bBox.add(add);
        }
        return bBox;
    }

    @Override
    public Rectangle intersection(Rectangle inside) {
        Rectangle intersect = null;
        Rectangle bounds = this.getBounds();
        if (inside != null && bounds != null && (intersect = inside.intersection(bounds)).isEmpty()) {
            intersect = null;
        }
        return intersect;
    }
}

