/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arc;

import java.awt.Point;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.Jaxo3PointObject;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoArcObject
extends Jaxo3PointObject {
    private static final long serialVersionUID = 2L;
    private static final double DEFAULT_CUTOFF = Math.PI / 180;

    public final void setArcPts(int x1, int y1, int x2, int y2, int p3, int q3) {
        this.setLocation(x1, y1, x2, y2, p3, q3);
    }

    public boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoArcObject && super.isCopy(comp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoArcObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoArcObject)o);
    }

    public void paintVisualAid(JaxoGraphics2D g2) {
        g2.drawLine(this.getX(), this.getY(), this.getX2(), this.getY2());
        g2.drawLine(this.getX2(), this.getY2(), this.getX3(), this.getY3());
        g2.drawLine(this.getX3(), this.getY3(), this.getX(), this.getY());
    }

    protected final double[] getArcParameters() {
        double[] params = new double[5];
        if (this.isSingular() || this.isOneLine()) {
            params[0] = Double.NaN;
            params[1] = Double.NaN;
            params[2] = Double.POSITIVE_INFINITY;
            params[3] = 0.0;
            params[4] = 0.0;
        } else {
            Point2D.Double cp = this.getCenterPoint();
            double startAngle = Math.atan2((double)this.getY() - cp.y, (double)this.getX() - cp.x);
            params[0] = cp.x;
            params[1] = cp.y;
            params[2] = this.getRadius(cp);
            params[3] = -Math.toDegrees(this.getOpeningAngle(cp));
            params[4] = -Math.toDegrees(startAngle);
        }
        return params;
    }

    public boolean isSingular() {
        return this.tooSingular(Math.PI / 180);
    }

    protected boolean tooSingular(double epsilon) {
        Point[] pp = this.getPoints();
        if (pp[0].equals(pp[1]) || pp[0].equals(pp[2]) || pp[2].equals(pp[1])) {
            return true;
        }
        double dist12 = Math.sqrt((pp[0].x - pp[1].x) * (pp[0].x - pp[1].x) + (pp[0].y - pp[1].y) * (pp[0].y - pp[1].y));
        double dist23 = Math.sqrt((pp[2].x - pp[1].x) * (pp[2].x - pp[1].x) + (pp[2].y - pp[1].y) * (pp[2].y - pp[1].y));
        double dist31 = Math.sqrt((pp[2].x - pp[0].x) * (pp[2].x - pp[0].x) + (pp[2].y - pp[0].y) * (pp[2].y - pp[0].y));
        double phi1 = Math.acos((double)((pp[1].x - pp[0].x) * (pp[2].x - pp[0].x) + (pp[1].y - pp[0].y) * (pp[2].y - pp[0].y)) / dist12 / dist31);
        double phi2 = Math.acos((double)((pp[0].x - pp[1].x) * (pp[2].x - pp[1].x) + (pp[0].y - pp[1].y) * (pp[2].y - pp[1].y)) / dist12 / dist23);
        boolean aligned = Math.abs(phi1) < epsilon || Math.abs(Math.PI - phi1) < epsilon;
        return Math.abs(phi2) < epsilon && aligned;
    }

    public JaxoArrow.Coordinates arrowCoordinates() {
        if (this.isSingular()) {
            return new JaxoArrow.Coordinates(Double.NaN, Double.NaN, 0.0);
        }
        if (this.isOneLine()) {
            double length = Math.sqrt((this.getX() - this.getX3()) * (this.getX() - this.getX3()) + (this.getY() - this.getY3()) * (this.getY() - this.getY3()));
            float arp = this.getArrowPosition();
            double theta = Math.atan2(this.getY2() - this.getY(), this.getX2() - this.getX());
            double x = (double)this.getX() + (double)arp * length * Math.cos(theta);
            double y = (double)this.getY() + (double)arp * length * Math.sin(theta);
            if (this.isFlip()) {
                theta += Math.PI;
            }
            return new JaxoArrow.Coordinates(x, y, theta);
        }
        Point2D.Double cp = this.getCenterPoint();
        Point2D.Double ap = this.getArcPoint(this.getArrowPosition(), cp);
        double theta = Math.atan2(ap.y - cp.y, ap.x - cp.x);
        theta = this.isClockwise(cp) ? (theta += 1.5707963267948966) : (theta -= 1.5707963267948966);
        if (this.isFlip()) {
            theta += Math.PI;
        }
        return new JaxoArrow.Coordinates(ap.x, ap.y, theta);
    }

    public final boolean isClockwise() {
        if (this.isOneLine()) {
            return true;
        }
        return this.isClockwise(this.getCenterPoint());
    }

    private boolean isClockwise(Point2D.Double cp) {
        return this.isClockwise(cp, this.getMidArcPoint(cp));
    }

    private boolean isClockwise(Point2D.Double cp, Point2D.Double mp) {
        double dir = ((double)this.getX() - cp.x) * (mp.y - cp.y) - ((double)this.getY() - cp.y) * (mp.x - cp.x);
        return dir >= 0.0;
    }

    public final double getArcLength() {
        if (this.isSingular()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isOneLine()) {
            return Math.sqrt((this.getX() - this.getX3()) * (this.getX() - this.getX3()) + (this.getY() - this.getY3()) * (this.getY() - this.getY3()));
        }
        Point2D.Double cp = this.getCenterPoint();
        Point2D.Double mp = this.getMidArcPoint(cp);
        double rsq = ((double)this.getX() - cp.x) * ((double)this.getX() - cp.x) + ((double)this.getY() - cp.y) * ((double)this.getY() - cp.y);
        double ang = Math.acos((((double)this.getX() - cp.x) * (mp.x - cp.x) + ((double)this.getY() - cp.y) * (mp.y - cp.y)) / rsq);
        return 2.0 * ang * Math.sqrt(rsq);
    }

    public final double getOpeningAngle() {
        if (this.isSingular()) {
            return Math.PI * 2;
        }
        if (this.isOneLine()) {
            return 0.0;
        }
        return this.getOpeningAngle(this.getCenterPoint());
    }

    private double getOpeningAngle(Point2D.Double cp) {
        return this.getOpeningAngle(cp, this.getMidArcPoint(cp));
    }

    private double getOpeningAngle(Point2D.Double cp, Point2D.Double mp) {
        double rsq = ((double)this.getX() - cp.x) * ((double)this.getX() - cp.x) + ((double)this.getY() - cp.y) * ((double)this.getY() - cp.y);
        double ang = Math.acos((((double)this.getX() - cp.x) * (mp.x - cp.x) + ((double)this.getY() - cp.y) * (mp.y - cp.y)) / rsq);
        if (!this.isClockwise(cp, mp)) {
            ang = -ang;
        }
        return 2.0 * ang;
    }

    public final double getRadius() {
        if (this.isOneLine() || this.isSingular()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getRadius(this.getCenterPoint());
    }

    private double getRadius(Point2D.Double cp) {
        return Math.sqrt(((double)this.getX() - cp.x) * ((double)this.getX() - cp.x) + ((double)this.getY() - cp.y) * ((double)this.getY() - cp.y));
    }

    public final Point2D.Double getEquidistantPoint(int i, int n) {
        if (this.isSingular()) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        if (this.isOneLine()) {
            double dx = (double)(this.getX3() - this.getX()) / (double)n;
            double dy = (double)(this.getY3() - this.getY()) / (double)n;
            return new Point2D.Double((double)this.getX() + (double)i * dx, (double)this.getY() + (double)i * dy);
        }
        Point2D.Double cp = this.getCenterPoint();
        Point2D.Double mp = this.getMidArcPoint(cp);
        double rsq = ((double)this.getX() - cp.x) * ((double)this.getX() - cp.x) + ((double)this.getY() - cp.y) * ((double)this.getY() - cp.y);
        double ang = Math.acos((((double)this.getX() - cp.x) * (mp.x - cp.x) + ((double)this.getY() - cp.y) * (mp.y - cp.y)) / rsq);
        double dphi = 2.0 * ang / (double)n;
        double phi1 = Math.atan2((double)this.getY() - cp.y, (double)this.getX() - cp.x);
        double radius = Math.sqrt(rsq);
        Point2D.Double point = new Point2D.Double();
        if (this.isClockwise(cp, mp)) {
            double px = cp.x + radius * Math.cos(phi1 + (double)i * dphi);
            double py = cp.y + radius * Math.sin(phi1 + (double)i * dphi);
            point.setLocation(px, py);
        } else {
            double px = cp.x + radius * Math.cos(phi1 - (double)i * dphi);
            double py = cp.y + radius * Math.sin(phi1 - (double)i * dphi);
            point.setLocation(px, py);
        }
        return point;
    }

    public Point2D.Float[] getEquidistantPoints(int n) {
        Point2D.Float[] points = new Point2D.Float[n + 1];
        if (this.isSingular()) {
            Point2D.Float nan = new Point2D.Float(Float.NaN, Float.NaN);
            for (int i = 0; i <= n; ++i) {
                points[i] = nan;
            }
            return points;
        }
        if (this.isOneLine()) {
            float dx = (float)(this.getX3() - this.getX()) / (float)n;
            float dy = (float)(this.getY3() - this.getY()) / (float)n;
            for (int i = 0; i <= n; ++i) {
                points[i] = new Point2D.Float((float)this.getX() + (float)i * dx, (float)this.getY() + (float)i * dy);
            }
            return points;
        }
        Point2D.Double cp = this.getCenterPoint();
        Point2D.Double mp = this.getMidArcPoint(cp);
        double rsq = ((double)this.getX() - cp.x) * ((double)this.getX() - cp.x) + ((double)this.getY() - cp.y) * ((double)this.getY() - cp.y);
        double ang = Math.acos((((double)this.getX() - cp.x) * (mp.x - cp.x) + ((double)this.getY() - cp.y) * (mp.y - cp.y)) / rsq);
        double dphi = 2.0 * ang / (double)n;
        double phi1 = Math.atan2((double)this.getY() - cp.y, (double)this.getX() - cp.x);
        double radius = Math.sqrt(rsq);
        int sign = 1;
        if (!this.isClockwise(cp, mp)) {
            sign = -1;
        }
        points[0] = new Point2D.Float(this.getX(), this.getY());
        for (int i = 1; i <= n; ++i) {
            double px = cp.x + radius * Math.cos(phi1 + (double)(sign * i) * dphi);
            double py = cp.y + radius * Math.sin(phi1 + (double)(sign * i) * dphi);
            points[i] = new Point2D.Float((float)px, (float)py);
        }
        return points;
    }

    public final Point2D.Double getArcPoint(double t) {
        if (this.isSingular()) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        if (this.isOneLine()) {
            return new Point2D.Double((double)this.getX() + t * (double)(this.getX3() - this.getX()), (double)this.getY() + t * (double)(this.getY3() - this.getY()));
        }
        return this.getArcPoint(t, this.getCenterPoint());
    }

    private Point2D.Double getArcPoint(double t, Point2D.Double cp) {
        double par = JaxoGeometry.curveParameter(t) * this.getOpeningAngle(cp);
        double phi1 = Math.atan2((double)this.getY() - cp.y, (double)this.getX() - cp.x);
        double radius = this.getRadius(cp);
        double px = cp.x + radius * Math.cos(phi1 + par);
        double py = cp.y + radius * Math.sin(phi1 + par);
        return new Point2D.Double(px, py);
    }

    public final Point2D.Double getCenterPoint() {
        if (this.isOneLine() || this.isSingular()) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        double aa = this.getX2() - this.getX();
        double bb = this.getY2() - this.getY();
        double cc = this.getX3() - this.getX();
        double dd = this.getY3() - this.getY();
        double ee = aa * (double)(this.getX() + this.getX2()) + bb * (double)(this.getY() + this.getY2());
        double ff = cc * (double)(this.getX() + this.getX3()) + dd * (double)(this.getY() + this.getY3());
        double gg = 2.0 * (aa * (double)(this.getY3() - this.getY2()) - bb * (double)(this.getX3() - this.getX2()));
        double px = (dd * ee - bb * ff) / gg;
        double py = (aa * ff - cc * ee) / gg;
        return new Point2D.Double(px, py);
    }

    public final Point2D.Double getMidArcPoint() {
        if (this.isSingular()) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        if (this.isOneLine()) {
            return new Point2D.Double((double)(this.getX() + this.getX3()) / 2.0, (double)(this.getY() + this.getY3()) / 2.0);
        }
        return this.getMidArcPoint(this.getCenterPoint());
    }

    private Point2D.Double getMidArcPoint(Point2D.Double cp) {
        double rel2;
        double rel1;
        double px2;
        double px1;
        double py2;
        double py1;
        Point2D.Double p1 = new Point2D.Double(this.getX(), this.getY());
        Point2D.Double p2 = new Point2D.Double(this.getX2(), this.getY2());
        Point2D.Double p3 = new Point2D.Double(this.getX3(), this.getY3());
        double rsq = (p1.x - cp.x) * (p1.x - cp.x) + (p1.y - cp.y) * (p1.y - cp.y);
        double x13 = (p3.x + p1.x) / 2.0;
        double y13 = (p3.y + p1.y) / 2.0;
        if (this.getX() == this.getX3()) {
            py1 = y13;
            py2 = y13;
            px1 = cp.x - Math.sqrt(rsq - (y13 - cp.y) * (y13 - cp.y));
            px2 = cp.x + Math.sqrt(rsq - (y13 - cp.y) * (y13 - cp.y));
            rel1 = p2.x - p1.x;
            rel2 = px2 - p1.x;
        } else if (this.getY() == this.getY3()) {
            px1 = x13;
            px2 = x13;
            py1 = cp.y - Math.sqrt(rsq - (x13 - cp.x) * (x13 - cp.x));
            py2 = cp.y + Math.sqrt(rsq - (x13 - cp.x) * (x13 - cp.x));
            rel1 = p2.y - p1.y;
            rel2 = py2 - p1.y;
        } else {
            double ma = (p3.y - p1.y) / (p3.x - p1.x);
            double a = 1.0 + 1.0 / ma / ma;
            double b = 2.0 * cp.y / ma - 2.0 * cp.x - 2.0 * y13 / ma - 2.0 * x13 / ma / ma;
            double c = cp.x * cp.x + x13 * x13 / ma / ma + y13 * y13 + 2.0 * y13 * x13 / ma - 2.0 * cp.y * x13 / ma - 2.0 * cp.y * y13 + cp.y * cp.y - rsq;
            double rad = Math.sqrt(b * b - 4.0 * a * c);
            px1 = (-b + rad) / 2.0 / a;
            px2 = (-b - rad) / 2.0 / a;
            py1 = -(px1 - x13) / ma + y13;
            py2 = -(px2 - x13) / ma + y13;
            rel1 = ma * (px2 - p1.x) + p1.y - py2;
            rel2 = ma * (p2.x - p1.x) + p1.y - p2.y;
        }
        double px = px1;
        double py = py1;
        if (rel1 * rel2 > 0.0) {
            px = px2;
            py = py2;
        }
        return new Point2D.Double(px, py);
    }
}

