/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arc;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.arc.JaxoArcObject;
import net.sf.jaxodraw.object.line.JaxoGlLine;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoGlArc
extends JaxoArcObject
implements JaxoWiggleObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public void copyFrom(JaxoGlArc temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoGlArc)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoGlArc)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoGlArc) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        GeneralPath gp = this.getObjectPath();
        if (gp != null) {
            g2.setColor(this.getColor());
            g2.setStroke(this.getStroke());
            g2.draw(gp);
        }
    }

    public Rectangle getBounds() {
        GeneralPath gp = this.getObjectPath();
        if (gp == null) {
            Rectangle r = new Rectangle(this.getX(), this.getY(), 0, 0);
            r.add(this.getX2(), this.getY2());
            r.add(this.getX3(), this.getY3());
            return r;
        }
        return this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        if (this.isSingular()) {
            return "% Singular GluonArc, ignored!" + JaxoUtils.LINE_SEPARATOR;
        }
        double nwin = this.getWiggles();
        if (nwin > 1000.0) {
            return "% Enormous GluonArc, ignored!" + JaxoUtils.LINE_SEPARATOR;
        }
        if (this.isOneLine()) {
            JaxoGlLine line = new JaxoGlLine();
            line.setLocation(this.getX(), this.getY(), this.getX3(), this.getY3());
            line.setStrokeWidth(this.getStrokeWidth());
            line.setAmp(this.getAmp());
            line.setWiggles(this.getWiggles());
            line.setDoubleLine(this.isDoubleLine());
            line.setDLSeparation(this.getDLSeparation());
            return line.latexCommand(scale, canvasDim);
        }
        double[] par = this.getArcParameters();
        double cx = par[0] / (double)scale;
        double cy = ((double)canvasDim.height - par[1]) / (double)scale;
        double r = par[2] / (double)scale;
        double ea = par[3] + par[4];
        double sa = par[4];
        boolean clockwise = par[3] < 0.0;
        double amp = (double)this.getAmp() / (2.0 * (double)scale);
        String options = this.getOptionsCommand(clockwise);
        return "\\GluonArc" + options + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")" + "(" + D_FORMAT.format(r) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + ")" + "{" + D_FORMAT.format(amp) + "}" + "{" + D_FORMAT.format(nwin) + "}";
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        float f = this.getFrequency();
        double arcLength = this.getArcLength();
        int n = (int)Math.round(arcLength * (double)f);
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.getArcLength());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setWigglesFromFrequency(0.08f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add3PointsPanel(this.getPoints(), 0, 0, 2);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 1);
        editPanel.addLineColorPanel(this.getColor(), 2, 1);
        editPanel.setTitleAndIcon("Gluon_arc_parameters", "gluonarc.png");
    }

    private GeneralPath getObjectPath() {
        if (this.isSingular()) {
            return null;
        }
        GeneralPath path = this.getGeneralPath();
        path.reset();
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        int wiggles = this.getWiggles();
        if (wiggles > 1000) {
            return null;
        }
        if (this.isOneLine()) {
            return this.gluonLine(path);
        }
        double[] par = this.getArcParameters();
        float cx = (float)par[0];
        float cy = (float)par[1];
        float radius = (float)par[2];
        float oa = (float)Math.abs(Math.toRadians(par[3]));
        float sa = (float)(-Math.toRadians(par[4]));
        boolean clockwise = par[3] < 0.0;
        float amp = 0.5f * (float)this.getAmp();
        if (this.isDoubleLine()) {
            float ds = this.getDLSeparation() / 2.0f;
            this.appendFullArc(path, radius + ds, wiggles, amp, sa, oa, cx, cy, clockwise);
            this.appendFullArc(path, radius - ds, wiggles, amp, sa, oa, cx, cy, clockwise);
        } else {
            this.appendFullArc(path, radius, wiggles, amp, sa, oa, cx, cy, clockwise);
        }
        return path;
    }

    private void appendFullArc(GeneralPath gp, float rad, int n, float a, float sa, float oa, float cx, float cy, boolean clock) {
        float cos = (float)Math.cos(sa);
        float sin = (float)Math.sin(sa);
        float r = rad;
        float absa = Math.abs(a);
        float delta = oa / (float)(n + 1);
        float y = -1.0f;
        if (clock) {
            y = 1.0f;
        }
        gp.moveTo(r * cos + cx, r * sin + cy);
        this.polarCurveTo(gp, r + 0.5f * a, y * (0.05f * delta), (float)((double)(r + a) / Math.cos(0.45 * (double)delta)), y * (0.25f * delta), r + a, y * (0.7f * delta), cos, sin, cx, cy);
        this.polarCurveTo(gp, (float)((double)(r + a) / Math.cos(0.3 * (double)delta + 0.9 * (double)absa / (double)r)), y * (delta + 0.9f * absa / r), (float)((double)(r - a) / Math.cos(0.9 * (double)absa / (double)r)), y * (delta + 0.9f * absa / r), r - a, y * delta, cos, sin, cx, cy);
        for (int j = 2; j <= n; ++j) {
            float thetaj = (float)(j - 1) * delta;
            this.polarCurveTo(gp, (float)((double)(r - a) / Math.cos(0.9 * (double)absa / (double)r)), y * (thetaj - 0.9f * absa / r), (float)((double)(r + a) / Math.cos(0.5 * (double)delta + 0.9 * (double)absa / (double)r)), y * (thetaj - 0.9f * absa / r), r + a, y * (thetaj + 0.5f * delta), cos, sin, cx, cy);
            this.polarCurveTo(gp, (float)((double)(r + a) / Math.cos(0.5 * (double)delta + 0.9 * (double)absa / (double)r)), y * (thetaj + delta + 0.9f * absa / r), (float)((double)(r - a) / Math.cos(0.9 * (double)absa / (double)r)), y * (thetaj + delta + 0.9f * absa / r), r - a, y * (thetaj + delta), cos, sin, cx, cy);
        }
        this.polarCurveTo(gp, (float)((double)(r - a) / Math.cos(0.9 * (double)absa / (double)r)), y * (oa - delta - 0.9f * absa / r), (float)((double)(r + a) / Math.cos(0.3 * (double)delta + 0.9 * (double)absa / (double)r)), y * (oa - delta - 0.9f * absa / r), r + a, y * (oa - 0.7f * delta), cos, sin, cx, cy);
        this.polarCurveTo(gp, (float)((double)(r + a) / Math.cos(0.45 * (double)delta)), y * (oa - 0.25f * delta), r + 0.5f * a, y * (oa - 0.05f * delta), r, y * oa, cos, sin, cx, cy);
    }

    private void polarCurveTo(GeneralPath gp, float r1, float th1, float r2, float th2, float r3, float th3, float cos, float sin, float cx, float cy) {
        float x1 = (float)((double)r1 * Math.cos(th1));
        float y1 = (float)((double)r1 * Math.sin(th1));
        float x2 = (float)((double)r2 * Math.cos(th2));
        float y2 = (float)((double)r2 * Math.sin(th2));
        float x3 = (float)((double)r3 * Math.cos(th3));
        float y3 = (float)((double)r3 * Math.sin(th3));
        gp.curveTo(x1 * cos - y1 * sin + cx, x1 * sin + y1 * cos + cy, x2 * cos - y2 * sin + cx, x2 * sin + y2 * cos + cy, x3 * cos - y3 * sin + cx, x3 * sin + y3 * cos + cy);
    }

    private GeneralPath gluonLine(GeneralPath gp) {
        if (this.isDoubleLine()) {
            float sep = this.getDLSeparation() / 2.0f;
            this.appendFullLine(gp, sep);
            this.appendFullLine(gp, -sep);
        } else {
            this.appendFullLine(gp, 0.0f);
        }
        return gp;
    }

    private void appendFullLine(GeneralPath gp, float sep) {
        float length = (float)Math.sqrt((this.getX3() - this.getX()) * (this.getX3() - this.getX()) + (this.getY3() - this.getY()) * (this.getY3() - this.getY()));
        int n = this.getWiggles();
        float delta = length / (float)(n + 1);
        float amp = -0.5f * (float)this.getAmp();
        float absamp = Math.abs(amp);
        float sin = (float)(this.getY3() - this.getY()) / length;
        float cos = (float)(this.getX3() - this.getX()) / length;
        gp.moveTo(this.getX(), (float)this.getY() + sep);
        float x1 = 0.05f * delta;
        float x2 = 0.25f * delta;
        float x3 = 0.7f * delta;
        float y1 = 0.5f * amp + sep;
        float y2 = amp + sep;
        float y3 = amp + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        x1 = delta + 0.9f * absamp;
        x2 = delta + 0.9f * absamp;
        x3 = delta;
        y1 = amp + sep;
        y2 = -amp + sep;
        y3 = -amp + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        for (int j = 1; j < n; ++j) {
            float xj = (float)j * delta;
            x1 = xj - 0.9f * absamp;
            x2 = xj - 0.9f * absamp;
            x3 = xj + 0.5f * delta;
            y1 = -amp + sep;
            y2 = amp + sep;
            y3 = amp + sep;
            this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
            x1 = xj + 0.9f * absamp + delta;
            x2 = xj + 0.9f * absamp + delta;
            x3 = xj + delta;
            y1 = amp + sep;
            y2 = -amp + sep;
            y3 = -amp + sep;
            this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        }
        x1 = length - delta - 0.9f * absamp;
        x2 = length - delta - 0.9f * absamp;
        x3 = length - 0.7f * delta;
        y1 = -amp + sep;
        y2 = amp + sep;
        y3 = amp + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        x1 = length - 0.25f * delta;
        x2 = length - 0.05f * delta;
        x3 = length;
        y1 = amp + sep;
        y2 = 0.5f * amp + sep;
        y3 = 0.0f + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
    }

    private void curveTo(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3, float cos, float sin) {
        gp.curveTo(x1 * cos - y1 * sin + (float)this.getX(), x1 * sin + y1 * cos + (float)this.getY(), x2 * cos - y2 * sin + (float)this.getX(), x2 * sin + y2 * cos + (float)this.getY(), x3 * cos - y3 * sin + (float)this.getX(), x3 * sin + y3 * cos + (float)this.getY());
    }

    private String getOptionsCommand(boolean clockwise) {
        StringBuffer buffer = new StringBuffer(128);
        if (this.isDoubleLine()) {
            String dlsep = D_FORMAT.format(this.getDLSeparation());
            buffer.append("double,sep=").append(dlsep);
        }
        if (clockwise) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append("clock");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, '[');
            buffer.append(']');
        }
        return buffer.toString();
    }
}

