/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.bezier;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.bezier.JaxoBezierObject;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoFBezier
extends JaxoBezierObject {
    private static final long serialVersionUID = 314159L;

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoFBezier) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getObjectPath());
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    public Rectangle getBounds() {
        Rectangle bb = this.getStroke().createStrokedShape(new Area(this.getObjectPath())).getBounds();
        if (this.isPaintArrow()) {
            bb.add(this.getArrow().getBounds(this.arrowCoordinates()));
        }
        return bb;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        String arrowCommand = "";
        String jdIdentifier = "%JaxoID:FBez";
        Point2D latexP1 = JaxoFBezier.getLatexPoint(this.getX(), this.getY(), scale, canvasHeight);
        Point2D latexP2 = JaxoFBezier.getLatexPoint(this.getX2(), this.getY2(), scale, canvasHeight);
        Point2D latexP3 = JaxoFBezier.getLatexPoint(this.getX3(), this.getY3(), scale, canvasHeight);
        Point2D latexP4 = JaxoFBezier.getLatexPoint(this.getX4(), this.getY4(), scale, canvasHeight);
        String command = JaxoFBezier.bezierLatexCommand("", latexP1, latexP2, latexP3, latexP4);
        if (this.isPaintArrow()) {
            float k = 0.0025f;
            float arrowPosition = this.getArrowPosition();
            Point2D b1 = this.getPointOnCurve(arrowPosition - 0.0025f);
            Point2D b2 = this.getPointOnCurve(arrowPosition + 0.0025f);
            Point2D startPoint = JaxoFBezier.getLatexPoint(b1.getX(), b1.getY(), scale, canvasHeight);
            Point2D endPoint = JaxoFBezier.getLatexPoint(b2.getX(), b2.getY(), scale, canvasHeight);
            String arrowcmd = this.getArrowCommand(scale);
            arrowCommand = "\\Line" + arrowcmd + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")" + "(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")";
            jdIdentifier = jdIdentifier + arrowcmd;
        }
        return command + arrowCommand + jdIdentifier;
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add4PointsPanel(this.getPoints(), 0, 0, 2);
        editPanel.addLineColorPanel(this.getColor(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addArrowPanel(this.isPaintArrow(), this.isFlip(), this.getArrowPosition(), 1, 1);
        editPanel.addArrowOptionsEditPanel(this.getArrow(), 2, 1);
        editPanel.setTitleAndIcon("Fermion_bezier_parameters", "bezierf.png");
    }

    private GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        gp.moveTo(this.getX(), this.getY());
        gp.curveTo(this.getX2(), this.getY2(), this.getX3(), this.getY3(), this.getX4(), this.getY4());
        return gp;
    }
}

