/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.line;

import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.line.JaxoLineObject;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoGlLine
extends JaxoLineObject
implements JaxoWiggleObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public void copyFrom(JaxoGlLine temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoGlLine)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoGlLine)o);
    }

    public boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoGlLine) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D startPoint = this.getLaTexStartPoint(scale, canvasHeight);
        Point2D endPoint = this.getLaTexEndPoint(scale, canvasHeight);
        if ((int)endPoint.getX() == (int)startPoint.getX() && (int)endPoint.getY() == (int)startPoint.getY()) {
            return "%";
        }
        float amplitude = (float)this.getAmp() / (2.0f * scale);
        float windings = this.getWiggles();
        String options = this.getAxo4JOptions(scale);
        return "\\Gluon" + options + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")" + "(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")" + "{" + D_FORMAT.format(amplitude) + "}" + "{" + D_FORMAT.format(windings) + "}";
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        int n = (int)Math.round(this.length() * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.length());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setPaintArrow(false);
        this.setArrowPosition(0.0f);
        this.setWigglesFromFrequency(0.08f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add2PointsPanel(this.getPoints(), 0, 0);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 1, 1);
        editPanel.addColorPanel(this.getColor(), 2, 2, 1);
        editPanel.setTitleAndIcon("Gluon_line_parameters", "gluon.png");
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        if (this.isDoubleLine()) {
            float sep = this.getDLSeparation() / 2.0f;
            this.appendFullLine(gp, sep);
            this.appendFullLine(gp, -sep);
        } else {
            this.appendFullLine(gp, 0.0f);
        }
        return gp;
    }

    private void appendFullLine(GeneralPath gp, float sep) {
        float length = (float)this.length();
        int n = this.getWiggles();
        float delta = length / (float)(n + 1);
        float amp = -0.5f * (float)this.getAmp();
        float absamp = Math.abs(amp);
        float sin = (float)this.getRelh() / length;
        float cos = (float)this.getRelw() / length;
        gp.moveTo(this.getX(), (float)this.getY() + sep);
        float x1 = 0.05f * delta;
        float x2 = 0.25f * delta;
        float x3 = 0.7f * delta;
        float y1 = 0.5f * amp + sep;
        float y2 = amp + sep;
        float y3 = amp + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        x1 = delta + 0.9f * absamp;
        x2 = delta + 0.9f * absamp;
        x3 = delta;
        y1 = amp + sep;
        y2 = -amp + sep;
        y3 = -amp + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        for (int j = 1; j < n; ++j) {
            float xj = (float)j * delta;
            x1 = xj - 0.9f * absamp;
            x2 = xj - 0.9f * absamp;
            x3 = xj + 0.5f * delta;
            y1 = -amp + sep;
            y2 = amp + sep;
            y3 = amp + sep;
            this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
            x1 = xj + 0.9f * absamp + delta;
            x2 = xj + 0.9f * absamp + delta;
            x3 = xj + delta;
            y1 = amp + sep;
            y2 = -amp + sep;
            y3 = -amp + sep;
            this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        }
        x1 = length - delta - 0.9f * absamp;
        x2 = length - delta - 0.9f * absamp;
        x3 = length - 0.7f * delta;
        y1 = -amp + sep;
        y2 = amp + sep;
        y3 = amp + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
        x1 = length - 0.25f * delta;
        x2 = length - 0.05f * delta;
        x3 = length;
        y1 = amp + sep;
        y2 = 0.5f * amp + sep;
        y3 = 0.0f + sep;
        this.curveTo(gp, x1, y1, x2, y2, x3, y3, cos, sin);
    }

    private void curveTo(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3, float cos, float sin) {
        gp.curveTo(x1 * cos - y1 * sin + (float)this.getX(), x1 * sin + y1 * cos + (float)this.getY(), x2 * cos - y2 * sin + (float)this.getX(), x2 * sin + y2 * cos + (float)this.getY(), x3 * cos - y3 * sin + (float)this.getX(), x3 * sin + y3 * cos + (float)this.getY());
    }

    protected String getAxo4JOptions(float scale) {
        String optioncmd = "";
        if (this.isDoubleLine()) {
            optioncmd = "[double,sep=" + D_FORMAT.format(this.getDLSeparation()) + "]";
        }
        return optioncmd;
    }
}

