/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.camera;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.gerhardb.lib.io.FileUtil;

public class CameraPreferences {
    private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/camera/CameraPreferences");
    private static final String LOG_DIRECTORY = "logDirectory";
    private static final String LOG_NUMBER = "logNumber";
    private static final String RELABEL_NUMBER = "relabelNumber";
    private static final String DIR_UTIL_UNIQUE_CAM = "uniqueRenamingCamera";
    private static final String DIR_UTIL_EXIF_RENAME = "exifRenaming";

    private CameraPreferences() {
    }

    public static String getLogDirectory() {
        String rtnMe = FileUtil.checkDirectory(clsPrefs.get(LOG_DIRECTORY, System.getProperty("user.home")));
        if (rtnMe == null) {
            rtnMe = System.getProperty("user.home");
        }
        return rtnMe;
    }

    public static void setLogDirectory(String dir) {
        String validated = FileUtil.safeValidateDirectory(dir);
        if (validated != null) {
            clsPrefs.put(LOG_DIRECTORY, validated);
        } else {
            clsPrefs.remove(LOG_DIRECTORY);
        }
    }

    public static int getNextLogNumber() {
        int count = clsPrefs.getInt(LOG_NUMBER, 0);
        ++count;
        try {
            CameraPreferences.setLogNumber(count);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static void setLogNumber(int setting) throws Exception {
        clsPrefs.putInt(LOG_NUMBER, setting);
        clsPrefs.flush();
    }

    public static int getRelabelNumber() {
        return clsPrefs.getInt(RELABEL_NUMBER, 0);
    }

    public static void setRelabelNumber(int setting) throws Exception {
        clsPrefs.putInt(RELABEL_NUMBER, setting);
        clsPrefs.flush();
    }

    public static boolean getUniqueRenamingCamera() {
        return clsPrefs.getBoolean(DIR_UTIL_UNIQUE_CAM, false);
    }

    public static void setUniqueRenamingCamera(boolean setting) {
        clsPrefs.putBoolean(DIR_UTIL_UNIQUE_CAM, setting);
    }

    public static boolean getExifRenaming() {
        return clsPrefs.getBoolean(DIR_UTIL_EXIF_RENAME, false);
    }

    public static void setExifRenaming(boolean setting) {
        clsPrefs.putBoolean(DIR_UTIL_EXIF_RENAME, setting);
    }

    public static void flush() {
        try {
            clsPrefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }
}

