/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.dirtools;

import com.saic.isd.printscreen.Util;
import com.saic.isd.util.report.Report;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.dirtools.WorkerDedup;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;

public class DirDedupPanel
extends JPanelRows {
    private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/dirtools/DirDedupPanel");
    private static String SACRED_STABLE_DIR = "SACRED_STABLE_DIR";
    private static String DEDUP_TARGET_DIR = "DEDUP_TARGET_DIR";
    WorkerDedup myWorker;
    JLabel myCurrentAction = new JLabel("Idle");
    private static final int DIR_COL_WIDTH = 50;
    JTextField sacredStableDirFld;
    JTextField dedupTargetDirFld;
    JButton myStartBtn = new JButton(Jibs.getString("CameraPanel.3"));
    JButton myStopBtn = new JButton(Jibs.getString("CameraPanel.16"));
    JCheckBox myCheckFileContents = new JCheckBox("Use File Name Only");

    public DirDedupPanel() {
        this.myCheckFileContents.setSelected(false);
        String stableDir = FileUtil.checkDirectory(clsPrefs.get(SACRED_STABLE_DIR, System.getProperty("user.home")));
        if (stableDir == null) {
            stableDir = System.getProperty("user.home");
        }
        this.sacredStableDirFld = new JTextField(stableDir);
        this.sacredStableDirFld.setColumns(50);
        JButton btnSacredStable = new JButton("...");
        btnSacredStable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = DirDedupPanel.this.sacredStableDirFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = DirDedupPanel.this.lookupDir("Stable Directory", dir);
                DirDedupPanel.this.sacredStableDirFld.setText(dir);
                DirDedupPanel.setPrefsDirectory(SACRED_STABLE_DIR, dir);
            }
        });
        String dedupTarget = FileUtil.checkDirectory(clsPrefs.get(DEDUP_TARGET_DIR, System.getProperty("user.home")));
        if (dedupTarget == null) {
            dedupTarget = System.getProperty("user.home");
        }
        this.dedupTargetDirFld = new JTextField(dedupTarget);
        this.dedupTargetDirFld.setColumns(50);
        JButton btnDedupTarget = new JButton("...");
        btnDedupTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = DirDedupPanel.this.dedupTargetDirFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = DirDedupPanel.this.lookupDir("Target Dedup Directory", dir);
                DirDedupPanel.this.dedupTargetDirFld.setText(dir);
                DirDedupPanel.setPrefsDirectory(DEDUP_TARGET_DIR, dir);
            }
        });
        this.myStopBtn.setEnabled(false);
        final JButton btnReport = new JButton(Jibs.getString("report"));
        btnReport.setEnabled(false);
        this.myStartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirDedupPanel.this.doWork();
                btnReport.setEnabled(true);
                DirDedupPanel.this.myStopBtn.setEnabled(true);
            }
        });
        this.myStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirDedupPanel.this.myWorker.stop();
                DirDedupPanel.this.myStopBtn.setEnabled(false);
            }
        });
        btnReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String text = Util.getTextFromFile(DirDedupPanel.this.myWorker.myLogFile);
                    Report.showReport(Jibs.getString("CameraPanel.30"), text, false);
                }
                catch (Exception ex) {
                    Report.showReport(Jibs.getString("CameraPanel.20"), ex.getMessage(), false);
                }
            }
        });
        JPanel currentRow = super.topRow();
        currentRow.add(new JLabel("Removes from the dedup directory any files found in stable directory."));
        currentRow = super.nextRow();
        currentRow.add(new JLabel("Stable Directory (won't be changed): "));
        currentRow.add(this.sacredStableDirFld);
        currentRow.add(btnSacredStable);
        currentRow = super.nextRow();
        currentRow.add(new JLabel("Dedup Directory (remove from here): "));
        currentRow.add(this.dedupTargetDirFld);
        currentRow.add(btnDedupTarget);
        currentRow = super.nextRow();
        currentRow.add(this.myCheckFileContents);
        currentRow = super.nextRow();
        currentRow.add(this.myStartBtn);
        currentRow.add(this.myStopBtn);
        currentRow.add(btnReport);
        currentRow = super.nextRow();
        currentRow.add(new JLabel("  " + Jibs.getString("CameraPanel.18") + Jibs.getString("colon") + " "));
        currentRow.add(this.myCurrentAction);
    }

    private String lookupDir(String msg, String prior) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(msg);
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(prior));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                return chooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void doWork() {
        try {
            this.myWorker = new WorkerDedup(this, this.sacredStableDirFld.getText(), this.dedupTargetDirFld.getText(), !this.myCheckFileContents.isSelected());
            Thread t = new Thread(this.myWorker);
            t.start();
        }
        catch (WorkerDedup.WorkerDedupException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("CameraPanel.25"), 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("CameraPanel.25"), 0);
            ex.printStackTrace();
        }
    }

    static void setPrefsDirectory(String pref, String dir) {
        String validated = FileUtil.safeValidateDirectory(dir);
        if (validated != null) {
            clsPrefs.put(pref, validated);
        } else {
            clsPrefs.remove(pref);
        }
    }
}

