/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.VPDMainPanel;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.dirtree.rdp.StatusBarManager;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class ViewerPreferencesDialog
extends JDialog {
    SortScreen mySortScreen;
    VPDMainPanel myMainPanel;
    TreePanel myTreePanel;
    StatusBarManager.AutocopyFilenamePanel myAutocopyFilenamePanel;
    ExifPanel myExifPanel;

    public ViewerPreferencesDialog(SortScreen owner, int index) {
        super(owner, Jibs.getString("ViewerPreferencesDialog.12"), true);
        this.mySortScreen = owner;
        this.myMainPanel = new VPDMainPanel(this.mySortScreen);
        this.myTreePanel = new TreePanel();
        this.myAutocopyFilenamePanel = this.mySortScreen.getLST().getStatusBarManager().getAutocopyFilenamePanel();
        this.myExifPanel = new ExifPanel();
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.14"), this.myMainPanel.setUpScreen());
        jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.15"), this.mySortScreen.getPathManager().directoryPanel());
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        thePanel.add((Component)this.getOkCancelPanel(), "South");
        this.setContentPane(thePanel);
        this.pack();
        jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.11"), this.myTreePanel);
        jTabbed.addTab("Other", this.myAutocopyFilenamePanel);
        jTabbed.addTab("EXIF", this.myExifPanel);
        jTabbed.setSelectedIndex(index);
        SwingUtils.centerOnScreen(this);
        this.setVisible(true);
    }

    private void save() {
        this.myMainPanel.save();
        this.myExifPanel.save();
        this.myAutocopyFilenamePanel.save();
        this.myTreePanel.save();
        ViewerPreferences.flush();
        super.setVisible(false);
        super.dispose();
        this.mySortScreen.repaint();
    }

    private void cancel() {
        super.setVisible(false);
        super.dispose();
    }

    private JPanel getOkCancelPanel() {
        JButton btnSave = new JButton(Jibs.getString("save"));
        btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerPreferencesDialog.this.save();
            }
        });
        JButton btnCancel = new JButton(Jibs.getString("cancel"));
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerPreferencesDialog.this.cancel();
            }
        });
        JPanel okPanel = new JPanel();
        okPanel.add(btnSave);
        okPanel.add(btnCancel);
        return okPanel;
    }

    class ExifPanel
    extends JPanel {
        JCheckBox showExifPanelChkBox;
        JCheckBox showExifWarningChkBox;

        ExifPanel() {
            super(new BorderLayout());
            this.showExifPanelChkBox = new JCheckBox("Show EXIF information on left of picture on main screen (restart JIBS to see change)");
            this.showExifWarningChkBox = new JCheckBox("Show EXIF warnings on save");
            this.showExifPanelChkBox.setSelected(ViewerPreferences.isExifPanelShowing());
            this.showExifWarningChkBox.setSelected(ViewerPreferences.showExifWarning());
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            editorPane.setDisabledTextColor(Color.black);
            editorPane.setEditorKit(JEditorPane.createEditorKitForContentType(Jibs.getString("ViewerPreferencesDialog.96")));
            editorPane.setText(this.getInfo());
            JScrollPane center = new JScrollPane(editorPane, 20, 31);
            super.add((Component)this.showExifPanelChkBox, "North");
            super.add((Component)center, "Center");
            super.add((Component)this.showExifWarningChkBox, "South");
        }

        void save() {
            ViewerPreferences.setExifPanelShowing(this.showExifPanelChkBox.isSelected());
            ViewerPreferences.setShowExifWarning(this.showExifWarningChkBox.isSelected());
        }

        private String getInfo() {
            StringBuffer myResults = new StringBuffer(3000);
            myResults.append("<html>");
            myResults.append("<b><i>What's the problem?</i></b><br>");
            myResults.append("The current save mechanism loses all picture metadata. This will be fixed in an upcoming release; however, its timing is dependent on finding a java image library which will support saving EXIF data.<p>");
            myResults.append("<b><i>What's metadata?</i></b><br>");
            myResults.append("Camera's record extra information with pictures like the model of camera and the date and time of the picture. That is all metadata. Specifically, EXIF metadata.<br><br>");
            myResults.append("<b><i>Does losing the metadata affect the quality of my pictures?</i></b><br>");
            myResults.append("No.<p>");
            myResults.append("<b><i>Is there anything else I should know?</i></b><br>");
            myResults.append("Be sure do any renaming your pictures based on the EXIF metadata prior to saving.<p>");
            myResults.append("If you change pictures from the main viewer (rotate, grow, shrink), and then save the picture, the metadata (EXIF) information which your camera stored ");
            myResults.append("with the picture will be lost.  This does not affect the ");
            myResults.append("image quality, but could make it harder for some image ");
            myResults.append("manipulation programs to automatically enhance your picture's ");
            myResults.append("quality.  It also make it impossible to rename the file using ");
            myResults.append("the EXIF information.  So do renames before doing rotations.<p>");
            myResults.append("</html>");
            return myResults.toString();
        }
    }

    class TreePanel
    extends JPanelRows {
        JCheckBox myCountImagesBox = new JCheckBox(Jibs.getString("ViewerPreferencesDialog.10"));
        boolean priorCountTarget = ViewerPreferences.countImageFilesInNodes();

        TreePanel() {
            this.myCountImagesBox.setSelected(ViewerPreferences.countImageFilesInNodes());
            this.myCountImagesBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int picked;
                    if (TreePanel.this.myCountImagesBox.isSelected() && !ViewerPreferences.countImageFilesInNodes() && (picked = JOptionPane.showConfirmDialog(TreePanel.this, Jibs.getString("ViewerPreferencesDialog.73"), Jibs.getString("ViewerPreferencesDialog.60"), 2)) == 2) {
                        TreePanel.this.myCountImagesBox.setSelected(false);
                    }
                }
            });
            JPanel aRow = super.topRow();
            aRow.add(this.myCountImagesBox);
        }

        void save() {
            ViewerPreferences.setCountImageFilesInNodes(this.myCountImagesBox.isSelected());
            ViewerPreferences.flush();
            if (this.priorCountTarget != this.myCountImagesBox.isSelected()) {
                ViewerPreferencesDialog.this.mySortScreen.getLST().getTree().setCountTargetFiles(this.myCountImagesBox.isSelected());
                ViewerPreferencesDialog.this.mySortScreen.getTreeManager().reloadAllNodes();
            }
        }
    }
}

