/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.contact;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import org.gerhardb.jibs.viewer.contact.CSO;
import org.gerhardb.jibs.viewer.contact.ContactSheet;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;

class DrawAPic {
    private Font myFont;
    private FontRenderContext myFontRenderContext;
    private Graphics2D myG2;
    private int myPicBoxWidth;
    private int myPicBoxHeight;
    private CSO myCSO;
    private static int KILOBYTE = 1024;
    private static int MEGABYTE = 0x100000;
    private ContactSheet myContactSheet;

    DrawAPic(Graphics2D g2, Font font, int width, int height, CSO cso, ContactSheet cs) {
        this.myG2 = g2;
        this.myFont = font;
        this.myPicBoxWidth = width;
        this.myPicBoxHeight = height;
        this.myCSO = cso;
        this.myContactSheet = cs;
    }

    void print(File imageFile, int picCntList, int Xoffset, int Yoffset) {
        int textX;
        int xCenterPic;
        this.myFontRenderContext = this.myG2.getFontRenderContext();
        BufferedImage buff = null;
        buff = ImageFactory.getImageFactory().getImageEZ(imageFile);
        if (buff == null) {
            return;
        }
        float textHeight = 0.0f;
        TextLayout tlName = null;
        TextLayout tlSize = null;
        if (this.myCSO.showPictureName()) {
            int picNumber = picCntList + 1;
            String name = null;
            name = this.myCSO.numberPictures() ? Integer.toString(picNumber) + ": " + imageFile.getName() : imageFile.getName();
            tlName = new TextLayout(name, this.myFont, this.myFontRenderContext);
            textHeight = textHeight + tlName.getAscent() + tlName.getDescent();
        }
        if (this.myCSO.showPictureSize()) {
            long length = imageFile.length();
            String units = null;
            if (length < (long)KILOBYTE) {
                units = "B";
            } else if (length < (long)MEGABYTE) {
                length = (long)Math.ceil((float)length / (float)KILOBYTE);
                units = "KB";
            } else {
                length = (long)Math.ceil((float)length / (float)MEGABYTE);
                units = "MB";
            }
            String size = buff.getHeight() + "x" + buff.getWidth() + "  " + length + units;
            tlSize = new TextLayout(size, this.myFont, this.myFontRenderContext);
            textHeight = textHeight + tlSize.getAscent() + tlSize.getDescent();
        }
        int frameOneSide = 0;
        int frameTwoSides = 0;
        if (this.myCSO.showPictureFrame() > 0) {
            frameOneSide = this.myContactSheet.scaleDPI(this.myCSO.showPictureFrame());
            frameTwoSides = frameOneSide * 2;
        }
        int shadow = 0;
        if (this.myCSO.showPictureShadow() > 0) {
            shadow = this.myContactSheet.scaleDPI(this.myCSO.showPictureShadow());
        }
        int netPicHeight = this.myPicBoxHeight - (int)textHeight - frameTwoSides - shadow;
        int netPicWidth = this.myPicBoxWidth - frameTwoSides - shadow;
        BufferedImage sized = ImageChangeUtil.fitAspectFill(buff, netPicWidth, netPicHeight);
        int xCenterImg = (int)(((float)this.myPicBoxWidth - (float)sized.getWidth()) / 2.0f);
        int imgX = Xoffset + xCenterImg;
        int imgY = Yoffset + frameOneSide;
        int frameX = imgX - frameOneSide;
        int frameY = Yoffset;
        int frameWidth = sized.getWidth() + frameTwoSides;
        int frameHeight = sized.getHeight() + frameTwoSides;
        if (this.myCSO.showPictureShadow() > 0) {
            int x = frameX + shadow;
            int y = frameY + shadow;
            int width = frameWidth;
            int height = frameHeight;
            Color c = this.myCSO.getTextColor();
            Color fill = new Color(c.getRed(), c.getGreen(), c.getBlue(), 125);
            this.myG2.setColor(fill);
            this.myG2.fillRect(x, y, width, height);
            this.myG2.setColor(this.myCSO.getTextColor());
        }
        if (this.myCSO.showPictureFrame() > 0) {
            this.myG2.fillRect(frameX, frameY, frameWidth, frameHeight);
        }
        BufferedImageOp op = null;
        this.myG2.drawImage(sized, op, imgX, imgY);
        int textY = Yoffset + frameTwoSides + sized.getHeight();
        if (tlName != null) {
            xCenterPic = (int)(((double)this.myPicBoxWidth - tlName.getBounds().getWidth()) / 2.0);
            textX = Xoffset + xCenterPic;
            textY = (int)((float)textY + tlName.getAscent());
            tlName.draw(this.myG2, textX, textY);
            textY = (int)((float)textY + tlName.getDescent());
        }
        if (tlSize != null) {
            xCenterPic = (int)(((double)this.myPicBoxWidth - tlSize.getBounds().getWidth()) / 2.0);
            textX = Xoffset + xCenterPic;
            textY = (int)((float)textY + tlSize.getAscent());
            tlSize.draw(this.myG2, textX, textY);
        }
    }
}

