/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.frame;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.PicInfoDialogBase;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.image.ImageUtilDrew;
import org.gerhardb.lib.swing.JPanelRows;

public class SaverActions {
    private SortScreen mySortScreen;
    private Action mySavePictureAction = new SavePictureAction();
    private Action mySaveAsPictureAction = new SaveAsPictureAction();
    private Action myRotateRightAction = new RotateRightAction();
    private Action myRotateLeftAction = new RotateLeftAction();
    private Action myShrinkAction = new ShrinkAction();
    private Action myGrowAction = new GrowAction();

    SaverActions(SortScreen ss) {
        this.mySortScreen = ss;
    }

    public void enableSave(boolean enabled) {
        this.mySavePictureAction.setEnabled(enabled);
    }

    public void enableSaveAs(boolean enabled) {
        this.mySaveAsPictureAction.setEnabled(enabled);
    }

    public void enableRotation(boolean enabled) {
        this.myRotateRightAction.setEnabled(enabled);
        this.myRotateLeftAction.setEnabled(enabled);
    }

    public void enableShrinkGrow(boolean enabled) {
        this.myShrinkAction.setEnabled(enabled);
        this.myGrowAction.setEnabled(enabled);
    }

    public boolean cancelSaveForExif(File sampleFile) {
        ArrayList exifTags;
        if (ViewerPreferences.showExifWarning() && (exifTags = ImageUtilDrew.getExifTags(this.mySortScreen.getScroller().getCurrentFile())).size() > 0) {
            return this.cancelSaveForExifDialog(sampleFile);
        }
        return false;
    }

    public boolean cancelSaveForExifDialog(File sampleFile) {
        JCheckBox showAgainChkBox = new JCheckBox(Jibs.getString("ViewerPreferencesDialog.93"));
        JOptionPane pane = new JOptionPane(this.warningPanel(showAgainChkBox), 2, 0);
        Object[] options = new String[]{Jibs.getString("SaverActions.0"), Jibs.getString("SaverActions.1"), Jibs.getString("SaverActions.2")};
        pane.setOptions(options);
        pane.setInitialSelectionValue(options[1]);
        pane.setInitialValue(options[1]);
        boolean reshow = true;
        Object selectedValue = null;
        while (reshow) {
            reshow = false;
            JDialog dialog = pane.createDialog(this.mySortScreen, Jibs.getString("SaverActions.3"));
            dialog.setVisible(true);
            selectedValue = pane.getValue();
            if (selectedValue == null) {
                return true;
            }
            if (((String)options[2]).equals(selectedValue)) {
                PicInfoDialogBase info = new PicInfoDialogBase((Frame)this.mySortScreen, this.mySortScreen.getScroller());
                info.display(sampleFile, null, -1, -1, false);
                reshow = true;
            }
            dialog.setVisible(false);
            dialog.dispose();
        }
        boolean showAgain = showAgainChkBox.isSelected();
        ViewerPreferences.setShowExifWarning(showAgain);
        return ((String)options[1]).equals(selectedValue);
    }

    public Action getSavePictureAction() {
        return this.mySavePictureAction;
    }

    public Action getSaveAsPictureAction() {
        return this.mySaveAsPictureAction;
    }

    public Action getRotateRightAction() {
        return this.myRotateRightAction;
    }

    public Action getRotateLeftAction() {
        return this.myRotateLeftAction;
    }

    public Action getShrinkAction() {
        return this.myShrinkAction;
    }

    public Action getGrowAction() {
        return this.myGrowAction;
    }

    private JPanel warningPanel(JCheckBox showAgainChkBox) {
        showAgainChkBox.setSelected(ViewerPreferences.showExifWarning());
        JPanelRows rtnMe = new JPanelRows();
        JPanel aRow = rtnMe.topRow();
        aRow.add(new JLabel(Jibs.getString("SaverActions.4")));
        aRow = rtnMe.nextRow();
        aRow.add(new JLabel(Jibs.getString("SaverActions.5")));
        aRow = rtnMe.nextRow();
        aRow.add(new JLabel(Jibs.getString("SaverActions.6")));
        aRow = rtnMe.nextRow();
        aRow.add(showAgainChkBox);
        return rtnMe;
    }

    private class GrowAction
    extends AbstractAction {
        private GrowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(3));
            ((SaverActions)SaverActions.this).mySortScreen.myShow.getSaver().grow();
            SaverActions.this.mySortScreen.getScroller().editedImage();
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class ShrinkAction
    extends AbstractAction {
        private ShrinkAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(3));
            ((SaverActions)SaverActions.this).mySortScreen.myShow.getSaver().shrink();
            SaverActions.this.mySortScreen.getScroller().editedImage();
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class RotateLeftAction
    extends AbstractAction {
        private RotateLeftAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(3));
            ((SaverActions)SaverActions.this).mySortScreen.myShow.getSaver().rotateLeft();
            SaverActions.this.mySortScreen.getScroller().editedImage();
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class RotateRightAction
    extends AbstractAction {
        private RotateRightAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(3));
            ((SaverActions)SaverActions.this).mySortScreen.myShow.getSaver().rotateRight();
            SaverActions.this.mySortScreen.getScroller().editedImage();
            SaverActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class SaveAsPictureAction
    extends AbstractAction {
        private SaveAsPictureAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ((SaverActions)SaverActions.this).mySortScreen.myShow.getSaver().save(true);
        }

        public void setEnabled(boolean setEnabled) {
            super.setEnabled(setEnabled);
        }
    }

    private class SavePictureAction
    extends AbstractAction {
        private SavePictureAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ((SaverActions)SaverActions.this).mySortScreen.myShow.getSaver().save(false);
        }

        public void setEnabled(boolean setEnabled) {
            super.setEnabled(setEnabled);
        }
    }
}

