/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.frame;

import java.awt.Color;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectedItemCountListener
implements ListSelectionListener {
    JList myList;
    int myCurrentCount;
    JLabel myLabel = new JLabel("  0 selected  ");
    Color myDefaultBackgroundColor = this.myLabel.getBackground();
    DecimalFormat myFormatter = new DecimalFormat();
    JButton myButton;

    SelectedItemCountListener(JList list, JButton button) {
        this.myList = list;
        this.myButton = button;
        this.myList.addListSelectionListener(this);
        this.myLabel.setToolTipText("Displays the number of items selected");
        this.myLabel.setOpaque(true);
        this.myLabel.setBorder(new BevelBorder(1));
        this.myButton.setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        int count = this.myList.getSelectedIndices().length;
        if (this.myCurrentCount != count) {
            this.myCurrentCount = count;
            this.myLabel.setText("  " + this.myFormatter.format(this.myCurrentCount) + " selected" + "  ");
            if (this.myCurrentCount == 0) {
                this.myButton.setEnabled(false);
                this.myLabel.setBackground(this.myDefaultBackgroundColor);
            } else {
                this.myButton.setEnabled(true);
                this.myLabel.setBackground(Color.cyan);
            }
        }
    }

    JLabel getToolBarLabel() {
        return this.myLabel;
    }
}

