/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.frame;

import javax.swing.JButton;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.playlist.SlideShowListener;
import org.gerhardb.lib.util.Icons;

public class SlideShowManager {
    SortScreen mySortScreen;
    JButton myFullScreenBtn;
    JButton myFullScreenSlideShowBtn;
    JButton mySlideShowBtn;

    public SlideShowManager(SortScreen ss) {
        this.mySortScreen = ss;
        this.myFullScreenBtn = this.mySortScreen.myActions.getToolBarButton("view", "full");
        this.myFullScreenSlideShowBtn = this.mySortScreen.myActions.getToolBarButton("view", "fullmovie");
        this.mySlideShowBtn = this.mySortScreen.myActions.getToolBarButton("view", "movie");
    }

    public JButton getFullScreenButton() {
        return this.myFullScreenBtn;
    }

    public JButton getFullScreenSlideShowButton() {
        return this.myFullScreenSlideShowBtn;
    }

    public JButton getSlideShowButton() {
        return this.mySlideShowBtn;
    }

    void setSlideShowButtons(boolean enabled) {
        this.myFullScreenBtn.setEnabled(enabled);
        this.myFullScreenSlideShowBtn.setEnabled(enabled);
        this.mySlideShowBtn.setEnabled(enabled);
    }

    void flipSlideShow() {
        if (this.mySortScreen.getScroller().isSlideShowRunning()) {
            this.mySortScreen.getScroller().stopSlideShow();
            String resourseKey = "SortScreen.menu.view.movie.label";
            String retrieved = Jibs.getString(resourseKey);
            this.mySlideShowBtn.getAction().putValue("Name", retrieved);
            this.mySlideShowBtn.setText(null);
        } else {
            this.mySortScreen.myShow.startSlideShow();
            String resourseKey = "SortScreen.menu.view.movie.stop";
            String retrieved = Jibs.getString(resourseKey);
            this.mySlideShowBtn.getAction().putValue("Name", retrieved);
            this.mySlideShowBtn.setText(null);
        }
    }

    void setupSlideShowListener() {
        this.mySortScreen.getScroller().addSlideShowListener(new SlideShowListener(){

            public void slideShow(boolean running) {
                if (running) {
                    SlideShowManager.this.mySlideShowBtn.setIcon(Icons.icon(20));
                    SlideShowManager.this.mySlideShowBtn.setToolTipText(Jibs.getString("MovieManager.8"));
                } else {
                    SlideShowManager.this.mySlideShowBtn.setIcon(Icons.icon(19));
                    SlideShowManager.this.mySlideShowBtn.setToolTipText(Jibs.getString("MovieManager.9"));
                }
            }
        });
    }
}

