/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.classic;

import com.saic.isd.printscreen.ImageSelection;
import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.ISave;
import org.gerhardb.jibs.viewer.frame.SaverActions;
import org.gerhardb.jibs.viewer.shows.classic.Single;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.io.FileSaveAs;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.print.PageableImage;
import org.gerhardb.lib.print.PageablePreviewer;
import org.gerhardb.lib.print.PrintUtils;

public class SingleSaver
implements ISave {
    BufferedImage myOriginalImage;
    BufferedImage myAdjustedImage;
    IOImage myIOImage;
    SaverActions mySaverActions;
    JFrame myJFrame;
    Single myShow;
    Scroller myScroller;
    private int myShrinkGrow = 10;
    private int mySizedShrinkGrow = 0;
    private int myRotation = 0;

    SingleSaver(SaverActions sa, JFrame f, Single show, Scroller scroller) {
        this.mySaverActions = sa;
        this.myJFrame = f;
        this.myShow = show;
        this.myScroller = scroller;
    }

    public void rotateRight() {
        this.myRotation += 90;
        if (this.myRotation == 360) {
            this.myRotation = 0;
        }
        this.mySaverActions.enableSave(true);
        this.adjustImage(this.myRotation, this.mySizedShrinkGrow);
    }

    public void rotateLeft() {
        this.myRotation -= 90;
        if (this.myRotation == -360) {
            this.myRotation = 0;
        }
        this.mySaverActions.enableSave(true);
        this.adjustImage(this.myRotation, this.mySizedShrinkGrow);
    }

    public void shrink() {
        if (this.mySizedShrinkGrow <= -90) {
            return;
        }
        this.mySizedShrinkGrow -= this.myShrinkGrow;
        this.mySaverActions.enableSave(true);
        this.adjustImage(this.myRotation, this.mySizedShrinkGrow);
    }

    public void grow() {
        this.mySizedShrinkGrow += this.myShrinkGrow;
        this.mySaverActions.enableSave(true);
        this.adjustImage(this.myRotation, this.mySizedShrinkGrow);
    }

    public void resetToolbar() {
        this.resetToolbar(true);
    }

    public void save(boolean saveAs) {
        if (this.mySaverActions.cancelSaveForExif(this.myScroller.getCurrentFile())) {
            return;
        }
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (saveAs) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(this.getCurrentFile());
                chooser.setDialogTitle(Jibs.getString("SingleSaver.1"));
                chooser.setFileSelectionMode(2);
                int returnVal = chooser.showSaveDialog(this.myScroller.getFocusComponent());
                if (returnVal == 0) {
                    try {
                        File oldFile = this.getCurrentFile();
                        File saveAsFile = chooser.getSelectedFile();
                        if (FileSaveAs.PossibleDuplicateNameOK(saveAsFile, this.myJFrame)) {
                            File oldDir = oldFile.getParentFile();
                            String saveAsPath = saveAsFile.getAbsolutePath();
                            this.myScroller.getCurrentIOImage().save(this.myAdjustedImage, saveAsPath);
                            File newFile = this.getCurrentFile();
                            File newDir = newFile.getParentFile();
                            if (newDir.equals(oldDir)) {
                                this.myScroller.reloadScroller();
                                this.myScroller.jumpTo(newFile);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                this.myScroller.getCurrentIOImage().save(this.myAdjustedImage);
            }
            this.resetToolbar(true);
            this.myScroller.requestFocus();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.myScroller.getFocusComponent(), Jibs.getString("SingleSaver.2") + Jibs.getString("colon") + " " + ex.getMessage(), Jibs.getString("SingleSaver.3"), 0);
        }
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void copy() {
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(3));
        BufferedImage image = this.getCurrentImage();
        ImageSelection clip = new ImageSelection(image);
        Clipboard clipboard = this.myJFrame.getToolkit().getSystemClipboard();
        clipboard.setContents(clip, clip);
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void preview() {
        if (this.myScroller.getCurrentIOImage() == null) {
            return;
        }
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(3));
        BufferedImage image = this.getCurrentImage();
        String description = this.myScroller.getCurrentIOImage().getFile().toString();
        System.out.println("SingleSaver Preview ====> " + description);
        PageableImage pi = new PageableImage(description, image);
        new PageablePreviewer(pi, null, false);
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void print() {
        if (this.myScroller.getCurrentIOImage() == null) {
            return;
        }
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(3));
        BufferedImage image = this.getCurrentImage();
        String description = this.myScroller.getCurrentIOImage().getFile().toString();
        PrintUtils.printPic(description, image, this.myJFrame);
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void adjustImage(int rotation, int shrinkGrow) {
        if (this.myScroller.getCurrentIOImage() == null) {
            return;
        }
        this.myAdjustedImage = this.myOriginalImage;
        switch (rotation) {
            case 0: {
                break;
            }
            case 90: {
                this.myAdjustedImage = ImageChangeUtil.rotateRight(this.myAdjustedImage);
                break;
            }
            case -90: {
                this.myAdjustedImage = ImageChangeUtil.rotateLeft(this.myAdjustedImage);
                break;
            }
            case -180: 
            case 180: {
                this.myAdjustedImage = ImageChangeUtil.flip(this.myAdjustedImage);
                break;
            }
            case 270: {
                this.myAdjustedImage = ImageChangeUtil.rotateLeft(this.myAdjustedImage);
                break;
            }
            case -270: {
                this.myAdjustedImage = ImageChangeUtil.rotateRight(this.myAdjustedImage);
            }
        }
        if (shrinkGrow != 0) {
            float scale = (float)shrinkGrow / 100.0f + 1.0f;
            if (scale <= 0.0f) {
                scale = 0.1f;
            }
            this.myAdjustedImage = ImageChangeUtil.scale(this.myAdjustedImage, scale);
        }
    }

    private void resetToolbar(boolean resetRotationShrinkGrow) {
        if (resetRotationShrinkGrow) {
            this.mySizedShrinkGrow = 0;
            this.myRotation = 0;
        }
        this.mySaverActions.enableSave(false);
        boolean showing = true;
        if (this.myScroller.getValueZeroBased() < 0) {
            showing = false;
        } else if (this.myScroller.getValueZeroBased() >= this.myScroller.getSize()) {
            showing = false;
        }
        this.mySaverActions.enableSaveAs(showing);
        this.mySaverActions.enableRotation(showing);
        this.mySaverActions.enableShrinkGrow(showing);
        if (showing && this.myShow.iCanResize()) {
            this.mySaverActions.enableShrinkGrow(true);
        } else {
            this.mySaverActions.enableShrinkGrow(false);
        }
    }

    private File getCurrentFile() {
        IOImage image = this.myScroller.getCurrentIOImage();
        if (image == null) {
            return null;
        }
        return image.getFile();
    }

    protected BufferedImage getCurrentImage() {
        int index = this.myScroller.getValueZeroBased();
        if (index < 0 || index >= this.myScroller.getSize()) {
            this.myOriginalImage = null;
            return this.myOriginalImage;
        }
        if (this.myScroller.getCurrentIOImage() == this.myIOImage) {
            return this.myAdjustedImage;
        }
        this.myIOImage = null;
        this.myOriginalImage = null;
        this.myAdjustedImage = null;
        this.resetToolbar(false);
        if (index > -1) {
            IOImage current = null;
            try {
                current = this.myScroller.getCurrentIOImage();
                if (current != null) {
                    this.myIOImage = current;
                    this.myAdjustedImage = this.myOriginalImage = current.getImage();
                } else {
                    System.out.println("myScroller.getCurrentIOImage() returned null ");
                }
            }
            catch (Exception ex) {
                System.out.println("Scroller.getCurrentImage FAILED");
                if (current != null) {
                    if (current.getFile().exists()) {
                        System.out.println("Problem loading image for: " + current.getFile().getAbsolutePath());
                    } else {
                        System.out.println("Missing File: " + current.getFile().getAbsolutePath());
                    }
                }
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return this.myAdjustedImage;
    }
}

