/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.comic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.IRevert;
import org.gerhardb.jibs.viewer.PicInfoDialog;
import org.gerhardb.jibs.viewer.shows.comic.MagnifiedPanel;
import org.gerhardb.jibs.viewer.shows.comic.ThumbnailImage;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.playlist.ScrollerSlider;

public class ComicScreen
implements ScrollerListener,
IRevert {
    static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/viewer/shows/comic");
    static final String DIVIDER_LOCATION = "DIVIDER_LOCATION";
    static final String DISPLAY_SLIDER = "DISPLAY_SLIDER";
    static final Color BACKGROUND_COLOR = Color.black;
    private IFrame myParentFrame;
    private boolean iShowFullScreen;
    JFrame mySurfaceFrame;
    private JPanel mySurfacePanel = new JPanel(new BorderLayout());
    private MagnifiedPanel myMagnifiedPanel = new MagnifiedPanel();
    private ThumbnailImage myThumbnailImage = new ThumbnailImage();
    private JPanel myBottomPanel = new JPanel(new BorderLayout());
    private GraphicsEnvironment myGE = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private GraphicsDevice myGD = this.myGE.getDefaultScreenDevice();
    JSplitPane mySplitPane;
    ComicMouseAdapter myComicMouseAdapter = new ComicMouseAdapter();

    public ComicScreen(IFrame mf) {
        this(mf, true);
    }

    public ComicScreen(IFrame mf, boolean showFullScreen) {
        this.myParentFrame = mf;
        this.iShowFullScreen = showFullScreen;
        this.myParentFrame.setWaitCursor(true);
        this.myParentFrame.getScroller().setEndMessages(true);
        this.mySplitPane = new JSplitPane(1, this.myThumbnailImage, this.myMagnifiedPanel);
        if (this.iShowFullScreen) {
            this.mySurfaceFrame = new JFrame(this.myGD.getDefaultConfiguration());
            this.mySurfaceFrame.setUndecorated(true);
        } else {
            this.mySurfaceFrame = new JFrame("JIBS Comic Viewer");
            this.mySurfaceFrame.setUndecorated(false);
        }
        this.mySurfaceFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.myBottomPanel.setVisible(clsPrefs.getBoolean(DISPLAY_SLIDER, true));
        ScrollerSlider slider = new ScrollerSlider(0, this.myParentFrame.getScroller());
        this.myBottomPanel.add((Component)slider, "Center");
        this.mySurfacePanel.add((Component)this.mySplitPane, "Center");
        this.mySurfacePanel.add((Component)this.myBottomPanel, "South");
        this.mySurfaceFrame.setContentPane(this.mySurfacePanel);
        this.mySurfaceFrame.addKeyListener(new CompicKeyAdapater());
        this.mySurfaceFrame.addKeyListener(this.myParentFrame.getScroller().getScrollerKeyListener());
        this.myThumbnailImage.addMouseListener(this.myComicMouseAdapter);
        this.myMagnifiedPanel.myMagnifiedImage.addMouseListener(this.myComicMouseAdapter);
        this.scrollerChanged(null);
        this.myParentFrame.getScroller().addScrollerListener(this);
        this.mySplitPane.setDividerLocation(clsPrefs.getInt(DIVIDER_LOCATION, 200));
        try {
            if (this.iShowFullScreen) {
                this.myGD.setFullScreenWindow(this.mySurfaceFrame);
                this.myParentFrame.getScroller().setAutoFocus(this.mySurfaceFrame);
            } else {
                this.mySurfaceFrame.setBounds(new Rectangle(10, 10, 1200, 600));
                this.mySurfaceFrame.setVisible(true);
                this.mySurfaceFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent evt) {
                        System.out.println("Comic setting prefs");
                        try {
                            clsPrefs.putInt(ComicScreen.DIVIDER_LOCATION, ComicScreen.this.mySplitPane.getDividerLocation());
                            clsPrefs.flush();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            this.mySurfaceFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.myMagnifiedPanel.myMagnifiedImage.requestFocus(true);
            this.mySurfaceFrame.requestFocus();
            this.mySurfaceFrame.setCursor(Cursor.getPredefinedCursor(0));
            this.myParentFrame.setWaitCursor(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JFrame getFrame() {
        return this.mySurfaceFrame;
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        if (!this.myParentFrame.getScroller().getValueIsAdjusting()) {
            BufferedImage image = null;
            try {
                image = this.myParentFrame.getScroller().getCurrentImage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (image == null) {
                image = this.myParentFrame.getScroller().getBeyondBounds();
                if (image != null) {
                    this.myMagnifiedPanel.myMagnifiedImage.setImage(image);
                    this.myThumbnailImage.setImage(image);
                }
                return;
            }
            this.myMagnifiedPanel.myMagnifiedImage.setImage(image);
            this.myThumbnailImage.setImage(image);
        }
    }

    public void revert() {
        if (!this.iShowFullScreen) {
            return;
        }
        this.myParentFrame.getScroller().stopSlideShow();
        this.myParentFrame.getScroller().removeScrollerListener(this);
        System.out.println("Comic setting prefs");
        try {
            clsPrefs.putInt(DIVIDER_LOCATION, this.mySplitPane.getDividerLocation());
            clsPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mySurfaceFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.myMagnifiedPanel.myMagnifiedImage.setBackground(BACKGROUND_COLOR);
        this.myMagnifiedPanel.myMagnifiedImage.setImage(null);
        this.myThumbnailImage.setImage(null);
        Runnable runSwitch = new Runnable(){

            public void run() {
                ComicScreen.this.myGD.setFullScreenWindow(null);
                ComicScreen.this.mySurfaceFrame.setVisible(false);
                ComicScreen.this.mySurfaceFrame.dispose();
                ComicScreen.this.myParentFrame.setWaitCursor(true);
                ComicScreen.this.myParentFrame.gotoRegularScreen();
                ComicScreen.this.myParentFrame.setWaitCursor(false);
            }
        };
        EventQueue.invokeLater(runSwitch);
    }

    public boolean isFullScreen() {
        return this.iShowFullScreen;
    }

    private void toggleBottom() {
        if (this.myBottomPanel.isShowing()) {
            this.myBottomPanel.setVisible(false);
            this.mySurfacePanel.revalidate();
            try {
                clsPrefs.putBoolean(DISPLAY_SLIDER, false);
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.myBottomPanel.setVisible(true);
            this.mySurfacePanel.revalidate();
            try {
                clsPrefs.putBoolean(DISPLAY_SLIDER, true);
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class ComicMouseAdapter
    extends MouseAdapter {
        private ComicMouseAdapter() {
        }

        public void mousePressed(MouseEvent event) {
            System.out.println("COMIC MOUSE PRESSED");
            if (event.isPopupTrigger() || event.getButton() == 2 || event.getButton() == 3) {
                if (ComicScreen.this.myParentFrame.getScroller().isBeyond()) {
                    return;
                }
                int width = -1;
                int height = -1;
                try {
                    BufferedImage image = ComicScreen.this.myParentFrame.getScroller().getCurrentImage();
                    width = image.getWidth();
                    height = image.getHeight();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                new PicInfoDialog(ComicScreen.this.myParentFrame.getScroller().getCurrentFile(), ComicScreen.this.mySurfaceFrame, ((ComicScreen)ComicScreen.this).myMagnifiedPanel.myMagnifiedImage, ComicScreen.this, ComicScreen.this.myParentFrame.getActions().getToolBarButton("file", "trash"), ComicScreen.this.myParentFrame.getActions().getToolBarButton("file", "park"), true, width, height, true, ComicScreen.this.myParentFrame.getScroller());
            } else {
                ComicScreen.this.myParentFrame.getScroller().down();
            }
        }
    }

    private class CompicKeyAdapater
    extends KeyAdapter {
        private CompicKeyAdapater() {
        }

        public void keyPressed(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 10: {
                    if ((event.getModifiersEx() & 0x80) == 128) {
                        ComicScreen.this.revert();
                    }
                    if ((event.getModifiersEx() & 0x200) == 512) {
                        ComicScreen.this.revert();
                    }
                    event.consume();
                    return;
                }
                case 38: {
                    ((ComicScreen)ComicScreen.this).myMagnifiedPanel.myMagnifiedImage.up();
                    event.consume();
                    break;
                }
                case 40: {
                    ((ComicScreen)ComicScreen.this).myMagnifiedPanel.myMagnifiedImage.down();
                    event.consume();
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 112: {
                    ComicScreen.this.revert();
                    ComicScreen.this.myParentFrame.showHelp();
                    event.consume();
                    return;
                }
                case 27: 
                case 113: {
                    ComicScreen.this.revert();
                    event.consume();
                    return;
                }
                case 114: {
                    ComicScreen.this.toggleBottom();
                    event.consume();
                    return;
                }
                case 38: 
                case 40: {
                    event.consume();
                    break;
                }
                case 33: {
                    ComicScreen.this.myParentFrame.getScroller().up();
                    event.consume();
                    break;
                }
                case 34: {
                    ComicScreen.this.myParentFrame.getScroller().down();
                    event.consume();
                    break;
                }
                case 36: {
                    ((ComicScreen)ComicScreen.this).myMagnifiedPanel.myMagnifiedImage.allUp();
                    event.consume();
                    break;
                }
                case 35: {
                    ((ComicScreen)ComicScreen.this).myMagnifiedPanel.myMagnifiedImage.allDown();
                    event.consume();
                }
            }
        }
    }
}

