/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.thumbs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gerhardb.jibs.viewer.PicInfoDialog;
import org.gerhardb.jibs.viewer.shows.thumbs.Thumbnails;
import org.gerhardb.jibs.viewer.sorter.TileConstants;
import org.gerhardb.jibs.viewer.sorter.TilePanel;
import org.gerhardb.lib.dirtree.filelist.FileDrag;
import org.gerhardb.lib.dirtree.filelist.LinklessDragListener;
import org.gerhardb.lib.image.ImageChangeUtil;

class Picture
extends JComponent
implements MouseListener,
ListSelectionListener,
DropTargetListener {
    private static int PADDING = 5;
    private static int PADDINGx2 = PADDING * 2;
    private int myCellIndex;
    private Thumbnails myPanel;
    private BufferedImage myThumbnail;
    private String myName;
    private boolean iAmCurrentPicture = false;
    private File myFile;
    private int myScrollerIndex;
    private static int myPriorClickedIndex = -1;
    ListSelectionModel myListPicks;
    private static Color ROTATION = new Color(175, 255, 175);

    public Picture(Thumbnails panel, int index) {
        this.myPanel = panel;
        this.myCellIndex = index;
        this.addMouseListener(this);
        super.setOpaque(false);
        this.myPanel.myViewerFrame.getFileList().addListSelectionListener(this);
        this.myListPicks = this.myPanel.myViewerFrame.getFileList().getSelectionModel();
        FileDrag trans = this.myPanel.myFileList.getTransferable();
        DragSourceListener dsl = this.myPanel.myFileList.getTransferable().getDragSourceListener();
        PictureLinklessDragListener dgl = new PictureLinklessDragListener(dsl, trans, this.myPanel.myDragSource);
        this.myPanel.myDragSource.createDefaultDragGestureRecognizer(this, 3, dgl);
        new DropTarget(this, this);
    }

    void setImage(BufferedImage image, String name, File file, int scrollIndex) {
        this.myName = name;
        this.myThumbnail = image;
        this.myFile = file;
        this.myScrollerIndex = scrollIndex;
        this.repaint();
    }

    void setCurrentPicture(boolean current) {
        this.iAmCurrentPicture = current;
        this.repaint();
    }

    int getScrollerIndex() {
        return this.myScrollerIndex;
    }

    public boolean isRefreshNeeded() {
        if (this.myScrollerIndex < 0) {
            return false;
        }
        if (this.myFile == null) {
            return true;
        }
        return !this.myFile.equals(this.myPanel.myViewerFrame.getScroller().getFile(this.myScrollerIndex));
    }

    protected void paintComponent(Graphics graphics) {
        Graphics g = graphics.create();
        Graphics2D g2 = (Graphics2D)g;
        if (this.myListPicks.isSelectedIndex(this.myScrollerIndex)) {
            this.setBackground(this.myPanel.mySelectedColor);
        } else if (this.iAmCurrentPicture) {
            this.setBackground(Color.pink);
        } else {
            this.setBackground(Color.gray);
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.myScrollerIndex >= 0 && this.myPanel.myCache.getRotation(this.myScrollerIndex) != 0) {
            g.setColor(ROTATION);
            int bandHeight = this.getHeight() / 5;
            int bandWidth = this.getWidth() / 5;
            g.fillRect(0, 0, bandWidth, bandHeight);
            g.fillRect(this.getWidth() - bandWidth, this.getHeight() - bandHeight, this.getWidth(), this.getHeight());
        }
        if (this.myThumbnail != null) {
            g2.setPaint(Color.BLACK);
            String msg = Integer.toString(this.myPanel.getScrollBarIndex(this.myCellIndex)) + ": " + this.myName;
            Dimension textSize = Picture.setFont(g, msg, super.getWidth());
            int imgHeight = super.getHeight() - (int)textSize.getHeight() - PADDINGx2;
            int imgWidth = super.getWidth() - PADDINGx2;
            int topOfText = 0;
            if (imgWidth > 0 && imgHeight > 0) {
                BufferedImage rotatedThumbnail = this.myPanel.myThumbnailSaver.myCache.getRotatedImage(this.myScrollerIndex, this.myThumbnail);
                BufferedImage sizedRotated = ImageChangeUtil.fitAspectDown(rotatedThumbnail, imgWidth, imgHeight);
                int centerX = (super.getWidth() - sizedRotated.getWidth()) / 2;
                int centerY = (super.getHeight() - sizedRotated.getHeight()) / 2;
                g.drawImage(sizedRotated, centerX, centerY, this);
                topOfText = centerY + sizedRotated.getHeight();
            }
            if (textSize.getWidth() > 0.0) {
                int textX = (int)(((double)super.getWidth() - textSize.getWidth()) / 2.0);
                FontMetrics fm = g.getFontMetrics();
                int textY = topOfText + fm.getMaxAscent();
                g.drawString(msg, textX, textY);
            }
        }
        TilePanel.clsTilePanel.clip(this.myFile, g2, super.getWidth(), super.getHeight());
        g.dispose();
    }

    private static Dimension setFont(Graphics g, String msg, int box_width) {
        FontMetrics fm;
        int msg_width;
        int type_size = 12;
        int type_size_min = 4;
        do {
            Font f = new Font("Default", 0, type_size);
            g.setFont(f);
        } while ((msg_width = (fm = g.getFontMetrics()).stringWidth(msg)) >= box_width && (type_size -= 2) >= type_size_min);
        if (type_size < type_size_min) {
            return new Dimension(0, 0);
        }
        return new Dimension(msg_width, fm.getHeight());
    }

    private void flipSelection() {
        if (this.myListPicks.isSelectedIndex(this.myScrollerIndex)) {
            this.myListPicks.removeSelectionInterval(this.myScrollerIndex, this.myScrollerIndex);
            myPriorClickedIndex = -1;
        } else {
            this.myListPicks.addSelectionInterval(this.myScrollerIndex, this.myScrollerIndex);
            myPriorClickedIndex = this.myScrollerIndex;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.flipSelection();
            this.myPanel.myViewerFrame.getScroller().setValue(this.myScrollerIndex);
            this.myPanel.myViewerFrame.gotoFullScreen(false);
        } else if (2 == event.getButton() || 3 == event.getButton()) {
            if (this.myFile != null) {
                new PicInfoDialog(this.myFile, this.myPanel.myViewerFrame.getFrame(), this.myPanel, this.myPanel, this.myPanel.myViewerFrame.getActions().getToolBarButton("file", "trash"), this.myPanel.myViewerFrame.getActions().getToolBarButton("file", "park"), false, -1, -1, false, this.myPanel.myViewerFrame.getScroller());
            }
        } else {
            if (this.myFile != null) {
                if ((event.getModifiersEx() & 0x40) != 0) {
                    if (this.myListPicks.isSelectionEmpty()) {
                        this.flipSelection();
                    } else {
                        int max = this.myListPicks.getMaxSelectionIndex();
                        int min = this.myListPicks.getMinSelectionIndex();
                        if (this.myScrollerIndex > max) {
                            this.myListPicks.addSelectionInterval(max, this.myScrollerIndex);
                        } else if (this.myScrollerIndex < min) {
                            this.myListPicks.addSelectionInterval(min, this.myScrollerIndex);
                        } else if (myPriorClickedIndex > -1) {
                            this.myListPicks.addSelectionInterval(myPriorClickedIndex, this.myScrollerIndex);
                        } else {
                            this.flipSelection();
                        }
                    }
                } else {
                    this.flipSelection();
                }
            }
            this.myPanel.myViewerFrame.getScroller().requestFocus();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void evaluateDrag(DropTargetDragEvent event) {
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        if (flavors == TileConstants.CLS_DATA_FLAVORS) {
            event.acceptDrag(2);
        } else {
            event.rejectDrag();
        }
    }

    public void dragEnter(DropTargetDragEvent event) {
        this.evaluateDrag(event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        this.evaluateDrag(event);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent event) {
        if (event.isLocalTransfer()) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            if (flavors == TileConstants.CLS_DATA_FLAVORS) {
                event.dropComplete(true);
            } else {
                event.dropComplete(false);
            }
        }
    }

    class PictureLinklessDragListener
    extends LinklessDragListener {
        PictureLinklessDragListener(DragSourceListener dsl, Transferable t, DragSource ds) {
            super(dsl, t, ds);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if (Picture.this.myFile == null) {
                return;
            }
            Picture.this.myListPicks.addSelectionInterval(Picture.this.myScrollerIndex, Picture.this.myScrollerIndex);
            super.dragGestureRecognized(dge);
        }
    }
}

