/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.thumbs;

import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.SoftReference;
import org.gerhardb.jibs.optimizer.OptimizerPreferences;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.playlist.Scroller;

class ThumbnailCache
implements Runnable {
    boolean iKeepRunning = true;
    int mySetSize = 1;
    SoftImage[] myThumbnails = new SoftImage[0];
    int[] myRotations = new int[0];
    Thread myThread;
    int myStartLoadingCacheAtIndex = 0;
    int mySmallWidth;
    int mySmallHeight;
    int myMaxPreload = 100;
    Scroller myScroller;

    ThumbnailCache(int rows, int cols, Scroller scroller) {
        this.myScroller = scroller;
        this.mySmallWidth = OptimizerPreferences.getFullScreenWidth() / cols;
        this.mySmallHeight = OptimizerPreferences.getFullScreenHeight() / rows;
        this.mySetSize = rows * cols;
        this.reload();
        this.myThread = new Thread(this);
        this.myThread.setPriority(1);
        this.myThread.start();
        this.myScroller = scroller;
    }

    void addRotation(int index, int rotation) {
        this.myRotations[index] = this.myRotations[index] + rotation;
        while (this.myRotations[index] >= 360) {
            this.myRotations[index] = this.myRotations[index] - 360;
        }
        while (this.myRotations[index] < 0) {
            this.myRotations[index] = this.myRotations[index] + 360;
        }
    }

    int getRotation(int index) {
        if (index < 0 || index >= this.myRotations.length) {
            return 0;
        }
        return this.myRotations[index];
    }

    BufferedImage getRotatedImage(int index, BufferedImage image) {
        BufferedImage rtnMe = image;
        if (rtnMe == null) {
            return null;
        }
        int rotation = this.myRotations[index];
        if (rotation == 0) {
            return rtnMe;
        }
        switch (rotation) {
            case -270: 
            case 90: {
                rtnMe = ImageChangeUtil.rotateRight(image);
                break;
            }
            case -90: 
            case 270: {
                rtnMe = ImageChangeUtil.rotateLeft(image);
                break;
            }
            case -180: 
            case 180: {
                rtnMe = ImageChangeUtil.flip(image);
                break;
            }
        }
        return rtnMe;
    }

    BufferedImage getImage(int index) {
        if (index < 0 || index >= this.myThumbnails.length) {
            return null;
        }
        BufferedImage rtnMe = null;
        rtnMe = this.myThumbnails[index] == null ? this.grabImage(index) : this.myThumbnails[index].getImage();
        if (rtnMe == null) {
            rtnMe = this.grabImage(index);
        }
        return rtnMe;
    }

    void stop() {
        this.iKeepRunning = false;
        this.kickThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload() {
        int size = this.myScroller.getSize();
        SoftImage[] softImageArray = this.myThumbnails;
        synchronized (this.myThumbnails) {
            this.myThumbnails = new SoftImage[size];
            this.myRotations = new int[size];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Runtime.getRuntime().gc();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int removeIndex) {
        SoftImage[] softImageArray = this.myThumbnails;
        synchronized (this.myThumbnails) {
            if (removeIndex < 0 || removeIndex >= this.myThumbnails.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.iKeepRunning = false;
            SoftImage[] newImages = new SoftImage[this.myThumbnails.length - 1];
            int[] newRotations = new int[newImages.length];
            int newIndex = 0;
            for (int i = 0; i < this.myThumbnails.length; ++i) {
                if (i == removeIndex) continue;
                newImages[newIndex] = this.myThumbnails[i];
                newRotations[newIndex] = this.myRotations[i];
                ++newIndex;
            }
            this.myThumbnails = newImages;
            this.myRotations = newRotations;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.iKeepRunning = true;
            return;
        }
    }

    void update(int startingIndexToLoad) {
        Runtime.getRuntime().gc();
        this.myStartLoadingCacheAtIndex = startingIndexToLoad;
        this.kickThread();
    }

    private void printStats() {
        int populated = 0;
        for (int i = 0; i < this.myThumbnails.length; ++i) {
            if (this.myThumbnails[i] == null) continue;
            ++populated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickThread() {
        Thread thread = this.myThread;
        synchronized (thread) {
            try {
                this.myThread.notify();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage grabImage(int index) {
        SoftImage[] softImageArray = this.myThumbnails;
        synchronized (this.myThumbnails) {
            BufferedImage smallSize = null;
            this.myThumbnails[index] = null;
            File file = this.myScroller.getFile(index);
            if (file == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            try {
                IOImage io = ImageFactory.getImageFactory().makeImage(file);
                BufferedImage fullSize = io.getImage();
                smallSize = ImageChangeUtil.fitAspectDown(fullSize, this.mySmallWidth, this.mySmallHeight);
                this.myThumbnails[index] = new SoftImage(smallSize);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            return smallSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.iKeepRunning) {
            try {
                Thread thread = this.myThread;
                synchronized (thread) {
                    this.myThread.wait();
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            this.loadAllImages();
        }
    }

    private void loadAllImages() {
        int startAt = this.myStartLoadingCacheAtIndex;
        int firstTwoSets = startAt + this.mySetSize * 2;
        this.loadSet(startAt, firstTwoSets);
        this.loadSet(startAt - this.mySetSize, startAt);
        this.loadSet(startAt + firstTwoSets, startAt + this.myMaxPreload - this.mySetSize * 3);
    }

    private void loadSet(int startAt, int stopAt) {
        if (startAt < 0) {
            startAt = 0;
        }
        if (stopAt > this.myThumbnails.length) {
            stopAt = this.myThumbnails.length;
        }
        while (startAt < stopAt && startAt < this.myThumbnails.length && this.iKeepRunning) {
            if (this.myThumbnails[startAt] == null) {
                this.grabImage(startAt);
                Thread.yield();
            }
            ++startAt;
        }
    }

    private class SoftImage
    extends SoftReference {
        SoftImage(BufferedImage thumbnail) {
            super(thumbnail);
        }

        BufferedImage getImage() {
            return (BufferedImage)super.get();
        }

        protected void finalize() {
            ThumbnailCache.this.printStats();
        }
    }
}

