/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.thumbs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.IShow;
import org.gerhardb.jibs.viewer.shows.thumbs.ThumbnailOptions;
import org.gerhardb.jibs.viewer.shows.thumbs.Thumbnails;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class ThumbnailOptionsDialog
extends JDialog {
    JSlider rowSlider = new JSlider(0, 1, 8, 4);
    JSlider colSlider = new JSlider(0, 1, 6, 3);
    JSlider picSlider = new JSlider(0, 1, 6, 3);
    JLabel myPicsPerPageLabel = new JLabel();
    JLabel mySelectedPicLabel = new JLabel();
    ThumbnailOptions myOptions = new ThumbnailOptions();
    IFrame myFrame;

    public ThumbnailOptionsDialog(IFrame frame) {
        super(frame.getFrame(), Jibs.getString("ThumbnailOptionsDialog.0"), false);
        this.myFrame = frame;
        this.initLayout();
    }

    public static JMenuItem makeThumbnailPreferenceMenu(IFrame frame) {
        class ThumbnailPreferencesAction
        extends AbstractAction {
            private final /* synthetic */ IFrame val$frame;

            ThumbnailPreferencesAction(IFrame iFrame) {
                this.val$frame = iFrame;
                super(Jibs.getString("ThumbnailOptionsDialog.1"));
            }

            public void actionPerformed(ActionEvent event) {
                new ThumbnailOptionsDialog(this.val$frame);
            }
        }
        return new JMenuItem(new ThumbnailPreferencesAction(frame));
    }

    private void initLayout() {
        this.rowSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ThumbnailOptionsDialog.this.update();
            }
        });
        this.colSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ThumbnailOptionsDialog.this.update();
            }
        });
        this.picSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ThumbnailOptionsDialog.this.update();
            }
        });
        JButton saveBtn = new JButton(Jibs.getString("save"));
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ThumbnailOptionsDialog.this.saveOptions();
                ThumbnailOptionsDialog.this.dispose();
            }
        });
        JButton cancelBtn = new JButton(Jibs.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ThumbnailOptionsDialog.this.dispose();
            }
        });
        this.rowSlider.setSnapToTicks(true);
        this.rowSlider.setPaintLabels(true);
        this.rowSlider.setPaintTicks(true);
        this.rowSlider.setMajorTickSpacing(1);
        this.colSlider.setSnapToTicks(true);
        this.colSlider.setPaintLabels(true);
        this.colSlider.setPaintTicks(true);
        this.colSlider.setMajorTickSpacing(1);
        this.picSlider.setSnapToTicks(true);
        this.picSlider.setPaintTicks(true);
        JPanelRows basePanel = new JPanelRows();
        JPanel row = basePanel.topRow();
        row.add(new JLabel(Jibs.getString("ThumbnailOptionsDialog.4")));
        row.add(this.rowSlider);
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("ThumbnailOptionsDialog.5")));
        row.add(this.colSlider);
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("ThumbnailOptionsDialog.6") + Jibs.getString("colon") + " "));
        row.add(this.myPicsPerPageLabel);
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("ThumbnailOptionsDialog.7")));
        row.add(this.picSlider);
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("ThumbnailOptionsDialog.8") + Jibs.getString("colon") + " "));
        row.add(this.mySelectedPicLabel);
        row = basePanel.nextRow(1);
        row.add(saveBtn);
        row.add(cancelBtn);
        this.getOptions();
        this.update();
        super.setContentPane(basePanel);
        super.pack();
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
        saveBtn.requestFocus();
    }

    void update() {
        int total = this.rowSlider.getValue() * this.colSlider.getValue();
        this.myPicsPerPageLabel.setText(Integer.toString(total));
        this.picSlider.setMaximum(total);
        this.mySelectedPicLabel.setText(Integer.toString(this.picSlider.getValue()));
        if (total > 10) {
            this.picSlider.setPaintLabels(false);
            this.picSlider.setMajorTickSpacing(5);
            this.picSlider.setMinorTickSpacing(1);
        } else {
            this.picSlider.setPaintLabels(false);
            this.picSlider.setMajorTickSpacing(1);
            this.picSlider.setMinorTickSpacing(1);
        }
    }

    void getOptions() {
        this.rowSlider.setValue(this.myOptions.getRows());
        this.colSlider.setValue(this.myOptions.getCols());
        this.picSlider.setValue(this.myOptions.getSelectedPicCell());
    }

    void saveOptions() {
        this.myOptions.setRows(this.rowSlider.getValue());
        this.myOptions.setCols(this.colSlider.getValue());
        this.myOptions.setSelectedPicCell(this.picSlider.getValue());
        IShow show = this.myFrame.getShow();
        if (show != null && show instanceof Thumbnails) {
            Thumbnails thumbs = (Thumbnails)show;
            thumbs.setRowCol(this.myOptions.getRows(), this.myOptions.getCols(), this.myOptions.getSelectedPicCell());
            show.showImage();
        }
    }

    public static void main(String[] args) {
        new ThumbnailOptionsDialog(null);
    }
}

