/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.playlist.IScroll;
import org.gerhardb.lib.util.Icons;

public class DirectoryTree
extends JTree
implements Autoscroll {
    public static final Insets myDefaultScrollInsets = new Insets(8, 8, 8, 8);
    protected Insets myScrollInsets = myDefaultScrollInsets;
    protected Window myTopWindow;
    private FileFilter myFileFilter;
    protected RDPmanager myRDPmanager;
    private boolean iCountTargetFiles = true;
    private boolean iCountHiddenDirectories = false;
    IScroll myScroller;
    File[] myExcludedDirectories;

    public DirectoryTree(Window window, FileFilter filter, RDPmanager rdpManager, IScroll scroller, boolean countHiddenDirectories) {
        this.myTopWindow = window;
        this.myFileFilter = filter;
        this.myRDPmanager = rdpManager;
        this.myScroller = scroller;
        this.iCountHiddenDirectories = countHiddenDirectories;
        this.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(Icons.icon(28));
        renderer.setOpenIcon(Icons.icon(27));
        renderer.setClosedIcon(Icons.icon(27));
        renderer.setDisabledIcon(Icons.icon(27));
        renderer.setIcon(Icons.icon(27));
        this.setCellRenderer(renderer);
    }

    public void setExcludedDirectories(File[] exclude) {
        this.myExcludedDirectories = exclude;
    }

    boolean isNotAnExcludedDirectory(File file) {
        if (this.myExcludedDirectories == null || file == null) {
            return true;
        }
        for (int i = 0; i < this.myExcludedDirectories.length; ++i) {
            if (!file.equals(this.myExcludedDirectories[i])) continue;
            return false;
        }
        return true;
    }

    public IScroll getScroller() {
        return this.myScroller;
    }

    public Window getTopWindow() {
        return this.myTopWindow;
    }

    public FileFilter getFileFilter() {
        return this.myFileFilter;
    }

    public boolean countHiddenDirectories() {
        return this.iCountHiddenDirectories;
    }

    public boolean getCountTargetFiles() {
        return this.iCountTargetFiles;
    }

    public void setCountTargetFiles(boolean setting) {
        this.iCountTargetFiles = setting;
    }

    public RDPmanager getPlugins() {
        return this.myRDPmanager;
    }

    public void setScrollInsets(Insets insets) {
        this.myScrollInsets = insets;
    }

    public Insets getScrollInsets() {
        return this.myScrollInsets;
    }

    public Insets getAutoscrollInsets() {
        Rectangle r = this.getVisibleRect();
        Dimension size = this.getSize();
        Insets i = new Insets(r.y + this.myScrollInsets.top, r.x + this.myScrollInsets.left, size.height - r.y - r.height + this.myScrollInsets.bottom, size.width - r.x - r.width + this.myScrollInsets.right);
        return i;
    }

    public void autoscroll(Point location) {
        JScrollPane scroller = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (scroller != null) {
            JScrollBar hBar = scroller.getHorizontalScrollBar();
            JScrollBar vBar = scroller.getVerticalScrollBar();
            Rectangle r = this.getVisibleRect();
            if (location.x <= r.x + this.myScrollInsets.left) {
                hBar.setValue(hBar.getValue() - hBar.getUnitIncrement(-1));
            }
            if (location.y <= r.y + this.myScrollInsets.top) {
                vBar.setValue(vBar.getValue() - vBar.getUnitIncrement(-1));
            }
            if (location.x >= r.x + r.width - this.myScrollInsets.right) {
                hBar.setValue(hBar.getValue() + hBar.getUnitIncrement(1));
            }
            if (location.y >= r.y + r.height - this.myScrollInsets.bottom) {
                vBar.setValue(vBar.getValue() + vBar.getUnitIncrement(1));
            }
        }
    }

    public DirectoryTreeNode getRootNode() {
        return (DirectoryTreeNode)super.getModel().getRoot();
    }

    public void updateTreeLabels() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DirectoryTree.this.treeDidChange();
            }
        });
    }

    public DirectoryTreeNode findANode(File fileOfNode) {
        String absolutePath = fileOfNode.getAbsolutePath();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        TreeNode anItem = null;
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> theEnum = rootNode.breadthFirstEnumeration();
        while (theEnum.hasMoreElements()) {
            DirectoryTreeNode node;
            anItem = theEnum.nextElement();
            if (!(anItem instanceof DirectoryTreeNode) || !(node = (DirectoryTreeNode)anItem).getAbsolutePath().equals(absolutePath)) continue;
            return node;
        }
        return null;
    }

    TreePath[] getExpandedDescendants(TreeNode parent, TreePath butNotMe) {
        int listSize = 33;
        ArrayList<TreePath> expandedList = new ArrayList<TreePath>(listSize);
        Enumeration<TreePath> theEnum = this.getExpandedDescendants(new TreePath(parent));
        if (theEnum != null) {
            while (theEnum.hasMoreElements()) {
                TreePath path = theEnum.nextElement();
                if (path.equals(butNotMe)) continue;
                expandedList.add(path);
            }
        }
        TreePath[] rtnMe = new TreePath[expandedList.size()];
        expandedList.toArray(rtnMe);
        return rtnMe;
    }

    void expandPath(TreePath[] expand) {
        for (int i = 0; i < expand.length; ++i) {
            this.setExpandedState(expand[i], true);
        }
    }
}

