/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gerhardb.lib.dirtree.filelist.popup.FileSeveralNameChangeDialog;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

public class FileNameChangeAddNumberTab
extends JPanel {
    JTextField myTextFld = new JTextField(33);
    JSlider mySlider = null;
    String mySampleText = "sample";
    JLabel mySampleLbl = new JLabel("<html><big>&nbsp;</big></html>");
    JCheckBox myDot = new JCheckBox(AppStarter.getString("FileNameChangeDialog.2"));
    FileSeveralNameChangeDialog myDialog;
    JButton myOkBtn = new JButton(AppStarter.getString("ok"));

    public FileNameChangeAddNumberTab(FileSeveralNameChangeDialog dialog, String sampleText) {
        super(new BorderLayout());
        this.mySampleText = sampleText;
        this.myDialog = dialog;
        this.mySlider = new JSlider(0, 0, this.mySampleText.length(), 1);
        this.mySlider.setSnapToTicks(true);
        this.mySlider.setMajorTickSpacing(5);
        this.mySlider.setMinorTickSpacing(1);
        this.mySlider.setValue(0);
        this.mySlider.setPaintTicks(true);
        this.mySlider.setPaintLabels(true);
        this.myDot.setSelected(true);
        this.setUpScreen();
    }

    public JButton getDefaultButton() {
        return this.myOkBtn;
    }

    void setSampleText(String sampleText) {
        if (sampleText != null) {
            this.mySampleText = sampleText;
        }
        this.mySampleLbl.setText(this.getSampleName(this.mySampleText));
    }

    private boolean isNameChanged() {
        String insert = this.myTextFld.getText();
        return insert != null && insert.length() > 0;
    }

    public String getNewName(String oldName) {
        if (!this.isNameChanged()) {
            return oldName;
        }
        String insert = this.myTextFld.getText();
        int firstDot = oldName.lastIndexOf(".");
        if (this.myDot.isSelected() && firstDot > -1) {
            if (this.mySlider.getValue() < firstDot) {
                return oldName.substring(0, this.mySlider.getValue()) + insert + oldName.substring(this.mySlider.getValue());
            }
            return oldName.substring(0, firstDot) + insert + oldName.substring(firstDot);
        }
        if (this.mySlider.getValue() < oldName.length()) {
            return oldName.substring(0, this.mySlider.getValue()) + insert + oldName.substring(this.mySlider.getValue());
        }
        return oldName + insert;
    }

    private String getSampleName(String oldName) {
        if (!this.isNameChanged()) {
            return oldName;
        }
        String insert = this.myTextFld.getText();
        int firstDot = oldName.lastIndexOf(".");
        if (this.myDot.isSelected() && firstDot > -1) {
            if (this.mySlider.getValue() < firstDot) {
                return "<html>" + oldName.substring(0, this.mySlider.getValue()) + "<big><b color=\"red\">" + insert + "</b></big>" + oldName.substring(this.mySlider.getValue()) + "</html>";
            }
            return "<html>" + oldName.substring(0, firstDot) + "<big><b color=\"red\">" + insert + "</b></big>" + oldName.substring(firstDot) + "</html>";
        }
        if (this.mySlider.getValue() < oldName.length()) {
            return "<html>" + oldName.substring(0, this.mySlider.getValue()) + "<big><b color=\"red\">" + insert + "</b></big>" + oldName.substring(this.mySlider.getValue()) + "</html>";
        }
        return "<html>" + oldName + "<big><b color=\"red\">" + insert + "</b></big>" + "</html>";
    }

    private void setUpScreen() {
        this.myDot.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FileNameChangeAddNumberTab.this.mySampleLbl.setText(FileNameChangeAddNumberTab.this.getSampleName(FileNameChangeAddNumberTab.this.mySampleText));
            }
        });
        this.myTextFld.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FileNameChangeAddNumberTab.this.mySampleLbl.setText(FileNameChangeAddNumberTab.this.getSampleName(FileNameChangeAddNumberTab.this.mySampleText));
            }
        });
        this.mySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!FileNameChangeAddNumberTab.this.mySlider.getValueIsAdjusting()) {
                    FileNameChangeAddNumberTab.this.mySampleLbl.setText(FileNameChangeAddNumberTab.this.getSampleName(FileNameChangeAddNumberTab.this.mySampleText));
                }
            }
        });
        this.myOkBtn = new JButton(AppStarter.getString("ok"));
        this.myOkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileNameChangeAddNumberTab.this.ok();
            }
        });
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileNameChangeAddNumberTab.this.cancel();
            }
        });
        this.myOkBtn.setMnemonic(75);
        JPanelRows mainPanel = new JPanelRows(1);
        JPanel row = mainPanel.topRow();
        row.add(new JLabel(AppStarter.getString("FileNameChangeDialog.24")));
        row = mainPanel.nextRow();
        row.add(new JLabel(AppStarter.getString("FileNameChangeDialog.25") + AppStarter.getString("colon") + " "));
        row.add(this.myTextFld);
        row = mainPanel.nextRow();
        row.add(new JLabel(AppStarter.getString("FileNameChangeDialog.26") + AppStarter.getString("colon") + " "));
        row.add(this.mySlider);
        row = mainPanel.nextRow();
        row.add(this.myDot);
        row = mainPanel.nextRow();
        row.add(new JLabel("<html>&nbsp;</html>"));
        row.add(this.mySampleLbl);
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        btnPanel.add(this.myOkBtn);
        btnPanel.add(cancelBtn);
        super.add((Component)mainPanel, "Center");
        super.add((Component)btnPanel, "South");
    }

    void ok() {
        this.myDialog.doNameChange();
        this.myDialog.done();
    }

    void cancel() {
        this.myTextFld.setText(null);
        this.myDialog.done();
    }
}

