/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.IOImageJava;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IOImageExample {
    public static void main(String[] args) {
        IOImageExample.writeTestNEW();
    }

    static void writeTestNEW() {
        File inFile = new File("D:/testpics/aaaa.jpg");
        File outFile = new File("D:/testpics/bbbb.jpg");
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(inFile);
            ImageReader reader = null;
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            while (readers.hasNext()) {
                reader = readers.next();
                System.out.println("Reader: " + reader.toString());
            }
            if (reader != null) {
                reader.setInput(iis);
                ImageReadParam readParam = null;
                IIOImage image = reader.readAll(0, readParam);
                IOImageExample.showMeta(image.getMetadata());
                ImageWriter writer = null;
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
                while (writers.hasNext()) {
                    writer = writers.next();
                    System.out.println("Writer: " + writer.toString());
                }
                if (writer != null) {
                    ImageOutputStream ios = ImageIO.createImageOutputStream(outFile);
                    writer.setOutput(ios);
                    writer.write(image);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void writeTestOLD() {
        File inFile = new File("D:/testpics/aaaa.jpg");
        File outFile = new File("D:/testpics/bbbb.jpg");
        try {
            IOImageJava inImage = new IOImageJava(inFile);
            IOImageJava outImage = new IOImageJava(outFile);
            BufferedImage image = ((IOImage)inImage).getImage();
            outImage.saveJPEG(image, 1.0f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void readEverythingTest() {
        File file = new File("D:/testpics/aaaa.jpg");
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            while (it.hasNext()) {
                ImageReader reader = it.next();
                System.out.println("############################################");
                System.out.println("READER: " + reader);
                System.out.println("############################################");
                reader.setInput(iis);
                IIOMetadata meta = reader.getImageMetadata(reader.getMinIndex());
                IOImageExample.showMeta(meta);
                reader.dispose();
            }
            try {
                iis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void showMeta(IIOMetadata meta) {
        try {
            if (meta == null) {
                System.out.println("No Meta Data Available");
                return;
            }
            System.out.println("Reading Meta Data!!");
            System.out.println("Native Metadata Format Name: " + meta.getNativeMetadataFormatName());
            if (meta.isStandardMetadataFormatSupported()) {
                System.out.println("Stadard Metadata Format IS Supported");
            } else {
                System.out.println("Stadard Metadata Format is NOT Supported");
            }
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.println("Metadata Format Names: ");
            String[] names = meta.getMetadataFormatNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    System.out.println("~~~~~~~~~~~~~~~~~~~~Printing DOM~~~~~~~~~~~~~~~~~~~~~~~~~~");
                    System.out.println("Format Name: " + names[i]);
                    Node node = meta.getAsTree(names[i]);
                    IOImageExample.displayMetadata(node);
                    System.out.println("----------------------------------------------------------");
                }
            }
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.println("Extra Metadata Format Names: ");
            String[] extra = meta.getExtraMetadataFormatNames();
            if (extra != null) {
                for (int i = 0; i < extra.length; ++i) {
                    System.out.println(extra[i]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void showKids(IIOMetadataFormat format, String nodeName, int level) {
        String[] kids = format.getChildNames(nodeName);
        if (kids == null) {
            IOImageExample.indent(level);
            System.out.println("No Children!");
            return;
        }
        for (int i = 0; i < kids.length; ++i) {
            IOImageExample.indent(level);
            System.out.println("Child Name: " + kids[i] + " -- " + format.getElementDescription(kids[i], Locale.US));
            String[] attributeNames = format.getAttributeNames(kids[i]);
            if (attributeNames != null) {
                for (int j = 0; j < attributeNames.length; ++j) {
                    IOImageExample.indent(level);
                    System.out.println(j + ": " + attributeNames[j]);
                }
            }
            IOImageExample.showKids(format, kids[i], level + 1);
        }
    }

    static void indent(int level) {
        int spaces = level * 2;
        for (int i = 0; i < spaces; ++i) {
            System.out.print("  ");
        }
    }

    public static void displayMetadata(Node root) {
        IOImageExample.displayMetadata(root, 0);
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        IOImageExample.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                IOImageExample.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            IOImageExample.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    static {
        ImageIO.setUseCache(false);
    }
}

