/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageUtil;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.startup.AppStarter;

class IOImageJava
extends IOImage {
    public IOImageJava(File file) throws Exception {
        super(file);
        ImageInputStream iis = ImageIO.createImageInputStream(this.myFile);
        this.myImage = ImageIO.read(iis);
        if (this.myImage != null) {
            try {
                this.myImage.getWidth();
            }
            catch (Exception x) {
                throw new IOException(AppStarter.getString("IOImage.1"));
            }
        }
    }

    public String getImageFactoryName() {
        return "Java-ImageIO";
    }

    public boolean isSaveInNataveFormatPossible() {
        return true;
    }

    public BufferedImage getImage() {
        return this.myImage;
    }

    public void save(BufferedImage inputImage, File saveAsFile) throws IOException {
        String ext = FileUtil.getExtension(saveAsFile.getName()).toLowerCase();
        ImageUtil.save(inputImage, 1.0f, saveAsFile, ext);
    }

    public static void main(String[] args) {
        try {
            IOImageJava image = new IOImageJava(new File("d:/testpics/aaa.jpg"));
            BufferedImage imgBuff = image.getImage();
            image.save(imgBuff);
            System.out.println("Image Saved!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        ImageIO.setUseCache(false);
    }
}

