/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtil.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static void saveJPEG(BufferedImage inputImage, float quality, File saveAsFile) throws IOException {
        ImageUtil.save(inputImage, quality, saveAsFile, "jpeg");
    }

    public static void save(BufferedImage inputImage, float quality, File saveAsFile, String type) throws IOException {
        if (inputImage == null || saveAsFile == null) {
            throw new IllegalArgumentException("Must provide image and file");
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(type);
        if (!iter.hasNext()) {
            iter = ImageIO.getImageWritersByFormatName("jpeg");
        }
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        FileImageOutputStream output = new FileImageOutputStream(saveAsFile);
        writer.setOutput(output);
        IIOImage newImage = new IIOImage(inputImage, null, null);
        writer.write(null, newImage, iwp);
        writer.dispose();
    }
}

