/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.gerhardb.lib.util.startup.AppStarter;

public class ImageUtilDrew {
    public static int TAG_DATETIME = 306;
    public static int TAG_DATETIME_ORIGINAL = 36867;
    public static int TAG_DATETIME_DIGITIZED = 36868;
    public static int TAG_MAKE = 271;
    public static int TAG_MODEL = 272;
    private static final SimpleDateFormat EXIF_DATE_FORMAT = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private File myFile;
    Metadata myMetadata;

    public static ArrayList getExifTags(File file) {
        ImageUtilDrew drew = new ImageUtilDrew(file);
        return drew.getExifTags();
    }

    public ImageUtilDrew(File file) {
        this.myFile = file;
        if (this.myFile == null) {
            throw new IllegalArgumentException("File must not be null");
        }
    }

    public Date getPicDate() {
        if (!this.parsableFileType()) {
            return null;
        }
        try {
            Metadata metadataEZ = JpegMetadataReader.readMetadata(this.myFile);
            Directory directory = metadataEZ.getDirectory(ExifDirectory.class);
            String timestamp = directory.getString(36867);
            if (timestamp == null) {
                System.out.println(AppStarter.getString("WorkerCamera.34") + " " + this.myFile);
                return null;
            }
            Date date = EXIF_DATE_FORMAT.parse(timestamp);
            return date;
        }
        catch (JpegProcessingException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean parsableFileType() {
        String fileName = this.myFile.getName().toLowerCase();
        return fileName.endsWith("jpeg") || fileName.endsWith("jpg");
    }

    private void parse() throws JpegProcessingException {
        if (this.myMetadata == null) {
            JpegSegmentReader segmentReader = new JpegSegmentReader(this.myFile);
            byte[] exifSegment = segmentReader.readSegment((byte)-31);
            byte[] iptcSegment = segmentReader.readSegment((byte)-19);
            this.myMetadata = new Metadata();
            new ExifReader(exifSegment).extract(this.myMetadata);
            new IptcReader(iptcSegment).extract(this.myMetadata);
        }
    }

    public String getExifString(int tag) {
        if (!this.parsableFileType()) {
            return null;
        }
        try {
            this.parse();
            Directory exifDirectory = this.myMetadata.getDirectory(ExifDirectory.class);
            return exifDirectory.getString(tag);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ArrayList getExifTags() {
        ArrayList<String> rtnMe = new ArrayList<String>();
        if (!this.parsableFileType()) {
            rtnMe.add(AppStarter.getString("ImageUtil.3"));
            return rtnMe;
        }
        try {
            this.parse();
            Iterator directories = this.myMetadata.getDirectoryIterator();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                Iterator tags = directory.getTagIterator();
                while (tags.hasNext()) {
                    Tag tag = (Tag)tags.next();
                    rtnMe.add(tag.toString());
                }
            }
        }
        catch (Exception ex) {
            rtnMe.add(AppStarter.getString("ImageUtil.2"));
        }
        return rtnMe;
    }
}

