/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.gerhardb.lib.io.EzLogger;
import org.gerhardb.lib.io.FileUtilDeleteException;
import org.gerhardb.lib.io.TargetFileExistsException;
import org.gerhardb.lib.util.StopCheck;
import org.gerhardb.lib.util.startup.AppStarter;

public class FileUtil {
    public static final String SPACE = " ";
    public static final String NEWLINE = "\n";
    public static final String SYS_NEWLINE = System.getProperty("line.separator");

    private FileUtil() {
    }

    public static String fileNameNoExtension(String oldName) {
        StringTokenizer tokens = new StringTokenizer(oldName, ".");
        StringBuffer baseName = new StringBuffer(50);
        String ending = null;
        baseName.append(tokens.nextToken());
        while (tokens.hasMoreTokens()) {
            if (ending != null) {
                baseName.append(ending + ".");
            }
            ending = tokens.nextToken();
        }
        return baseName.toString();
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(name, ".");
        String ending = null;
        if (tokens.countTokens() == 1) {
            return null;
        }
        while (tokens.hasMoreTokens()) {
            ending = tokens.nextToken();
        }
        return ending;
    }

    public static void copyFile(File toFile, File copyThis) throws TargetFileExistsException, FileNotFoundException, IOException {
        if (copyThis == null || toFile == null) {
            throw new IllegalArgumentException("null arguements are not allowed");
        }
        if (!copyThis.isFile()) {
            throw new IllegalArgumentException(copyThis + " is NOT a File");
        }
        if (toFile.exists()) {
            throw new TargetFileExistsException(toFile.getName(), toFile.getAbsolutePath());
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(copyThis));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));
        try {
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            try {
                in.close();
                out.close();
                toFile.delete();
            }
            catch (Exception doubleEx) {
                doubleEx.printStackTrace();
            }
            throw ex;
        }
        out.close();
        in.close();
    }

    public static void copyFileToDir(File toDir, File copyThis) throws TargetFileExistsException, FileNotFoundException, IOException {
        if (copyThis == null || toDir == null) {
            throw new IllegalArgumentException("null arguements are not allowed");
        }
        if (!copyThis.isFile()) {
            throw new IllegalArgumentException(copyThis + " is NOT a File");
        }
        if (!toDir.isDirectory()) {
            throw new IllegalArgumentException(toDir + " is NOT a Directory");
        }
        File newName = new File(toDir.getAbsolutePath() + File.separator + copyThis.getName());
        FileUtil.copyFile(newName, copyThis);
    }

    public static void moveFile(String toDir, File moveThis) throws Exception {
        File newName = new File(toDir + moveThis.getName());
        if (newName.exists()) {
            throw new TargetFileExistsException(newName.getName(), toDir);
        }
        if (moveThis.renameTo(newName)) {
            return;
        }
        FileUtil.copyFileToDir(new File(toDir), moveThis);
        if (moveThis.delete()) {
            return;
        }
        throw new FileUtilDeleteException(AppStarter.getString("FileUtil.23") + moveThis.getAbsolutePath());
    }

    public static void moveFile(File toDir, File moveThis, StringBuffer report, EzLogger logger, boolean makeNewName) throws Exception {
        if (moveThis == null || toDir == null) {
            throw new IllegalArgumentException("null arguements are not allowed");
        }
        if (!moveThis.isFile()) {
            throw new IllegalArgumentException(moveThis + " is NOT a File");
        }
        if (!toDir.isDirectory()) {
            throw new IllegalArgumentException(toDir + " is NOT a Directory");
        }
        File newName = new File(toDir.getAbsolutePath() + File.separator + moveThis.getName());
        String nameNoPath = newName.getName();
        if (!makeNewName && newName.exists()) {
            throw new TargetFileExistsException(nameNoPath, toDir.getAbsolutePath());
        }
        while (newName.exists()) {
            String rootNameNoExtension = FileUtil.fileNameNoExtension(nameNoPath);
            String ending = "";
            int period = nameNoPath.lastIndexOf(".");
            if (period > -1) {
                ending = nameNoPath.substring(period);
            }
            boolean makeItUp = true;
            int underscore = rootNameNoExtension.lastIndexOf("_");
            if (underscore > -1) {
                String possibleNumber = rootNameNoExtension.substring(underscore + 1);
                try {
                    int number = Integer.parseInt(possibleNumber) + 1;
                    makeItUp = false;
                    String rootBase = rootNameNoExtension.substring(0, underscore);
                    String newRoot = rootBase + "_" + number + ending;
                    newName = new File(toDir.getAbsolutePath() + File.separator + newRoot);
                    nameNoPath = newName.getName();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!makeItUp) continue;
            newName = new File(toDir.getAbsolutePath() + File.separator + rootNameNoExtension + "_1" + ending);
            nameNoPath = newName.getName();
        }
        if (moveThis.renameTo(newName)) {
            if (report != null) {
                report.append("   " + AppStarter.getString("FileUtil.14") + AppStarter.getString("colon") + SPACE + newName + NEWLINE);
            }
            if (logger != null) {
                logger.logLine("   " + AppStarter.getString("FileUtil.17") + AppStarter.getString("colon") + SPACE + newName);
            }
            return;
        }
        FileUtil.copyFileToDir(toDir, moveThis);
        if (report != null) {
            report.append("   " + AppStarter.getString("FileUtil.19") + AppStarter.getString("colon") + SPACE + newName + NEWLINE);
        }
        if (logger != null) {
            logger.logLine("   " + AppStarter.getString("FileUtil.22") + AppStarter.getString("colon") + SPACE + newName);
        }
        if (moveThis.delete()) {
            return;
        }
        throw new FileUtilDeleteException(AppStarter.getString("FileUtil.23") + AppStarter.getString("colon") + SPACE + moveThis.getAbsolutePath());
    }

    public static void concatFiles(File newFile, File[] concat, BoundedRangeModel range, StopCheck check) throws TargetFileExistsException, FileNotFoundException, IOException {
        if (newFile == null || concat == null) {
            throw new IllegalArgumentException("concatFiles does not take non-null arguments");
        }
        if (concat.length == 0) {
            throw new IllegalArgumentException("no files passed in to concatinate");
        }
        if (newFile.isFile()) {
            throw new TargetFileExistsException(newFile.getName(), newFile.getAbsolutePath());
        }
        if (range == null) {
            range = new DefaultBoundedRangeModel();
        }
        range.setRangeProperties(0, 0, 0, concat.length, false);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
        for (int i = 0; !(i >= concat.length || check != null && check.isStopped()); ++i) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(concat[i]));
            int aByte = in.read();
            while (aByte != -1) {
                out.write(aByte);
                aByte = in.read();
            }
            in.close();
            range.setValue(i + 1);
        }
        out.close();
    }

    public static boolean copyFileToDir(File toDir, File copyThis, Component onTopOf) {
        try {
            FileUtil.copyFileToDir(toDir, copyThis);
            return true;
        }
        catch (TargetFileExistsException ex) {
            JOptionPane.showMessageDialog(onTopOf, ex.getMessage() + " - " + AppStarter.getString("FileUtil.27"), AppStarter.getString("FileUtil.28"), 2);
            return false;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(onTopOf, ex.getMessage(), AppStarter.getString("FileUtil.29"), 0);
            return false;
        }
    }

    public static boolean moveFile(File toDir, File moveThis, Component onTopOf) {
        try {
            FileUtil.moveFile(toDir.getAbsolutePath() + File.separator, moveThis);
            return true;
        }
        catch (TargetFileExistsException ex) {
            JOptionPane.showMessageDialog(onTopOf, ex.getMessage() + " - " + AppStarter.getString("FileUtil.31"), AppStarter.getString("FileUtil.32"), 2);
            return false;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(onTopOf, ex.getMessage(), AppStarter.getString("FileUtil.33"), 0);
            return false;
        }
    }

    public static String safeValidateDirectory(String dirName) {
        try {
            return FileUtil.validateDirectory(dirName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String validateDirectory(String dirName) throws FileNotFoundException {
        if (dirName == null || dirName.length() == 0) {
            throw new IllegalArgumentException("directory name required");
        }
        File dir = new File(dirName);
        if (!dir.exists()) {
            throw new FileNotFoundException(dirName + " does not exist. ");
        }
        if (!dir.isDirectory()) {
            if (!(dir = dir.getParentFile()).isDirectory()) {
                throw new FileNotFoundException(dir + SPACE + AppStarter.getString("FileUtil.36"));
            }
            return dir.getAbsolutePath();
        }
        return dirName;
    }

    public static String checkDirectory(String dirName) {
        if (dirName == null) {
            return null;
        }
        if (dirName.length() == 0) {
            return null;
        }
        File dir = new File(dirName);
        if (!dir.exists()) {
            return null;
        }
        if (!dir.isDirectory()) {
            if (!(dir = dir.getParentFile()).isDirectory()) {
                return null;
            }
            return dir.getAbsolutePath();
        }
        return dirName;
    }

    public static String getStringFromFile(File file) throws FileNotFoundException, IOException {
        BufferedReader buffRead = new BufferedReader(new FileReader(file));
        StringBuffer buff = new StringBuffer(5000);
        String appendMe = buffRead.readLine();
        while (appendMe != null) {
            buff.append(appendMe + NEWLINE);
            appendMe = buffRead.readLine();
        }
        buffRead.close();
        String xml = buff.toString();
        return xml;
    }

    public static String lookupDir(String msg, String priorDir, Component comp) {
        if (priorDir == null) {
            priorDir = System.getProperty("user.home");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(msg);
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(priorDir));
        int returnVal = chooser.showOpenDialog(comp);
        if (returnVal == 0) {
            try {
                return chooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static File[] listFilesIncludingSubDirectories(File rootDir) {
        ArrayList fileList = new ArrayList(1000);
        FileUtil.addSubdirectoriesRecursive(rootDir, fileList);
        File[] rtnMe = new File[fileList.size()];
        rtnMe = fileList.toArray(rtnMe);
        return rtnMe;
    }

    private static void addSubdirectoriesRecursive(File root, ArrayList list) {
        File[] files = root.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtil.addSubdirectoriesRecursive(files[i], list);
                continue;
            }
            list.add(files[i]);
        }
    }

    public static void main(String[] args) {
        String fromDir = "e:/testpics/dedupBig/";
        File toDir = new File("e:/testpics/park");
        StringBuffer buff = new StringBuffer();
        try {
            FileUtil.moveFile(toDir, new File("e:/testpics/dedupBig/aaamoveMe.jpg"), buff, null, true);
        }
        catch (Exception ex) {
            System.out.println("Move ERROR: " + ex.getMessage());
        }
    }
}

