/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import java.io.File;

public class IOUtils {
    public static File validDirectory(File dir) {
        return new File(IOUtils.validDirectory(dir.getAbsolutePath()));
    }

    public static String validDirectory(String dir) {
        if (dir == null) {
            return null;
        }
        File testDir = new File(dir);
        if (testDir.exists()) {
            return dir;
        }
        dir = dir.replace('\\', '/');
        String[] pathParts = dir.split("/");
        for (int pathToCheck = pathParts.length - 1; pathToCheck > 1; --pathToCheck) {
            StringBuffer buff = new StringBuffer(100);
            for (int i = 0; i < pathToCheck; ++i) {
                buff.append(pathParts[i]);
                buff.append("/");
            }
            testDir = new File(buff.toString());
            if (!testDir.exists()) continue;
            return testDir.getAbsolutePath();
        }
        return dir;
    }

    public static void main(String[] args) {
        System.out.println(IOUtils.validDirectory("======================================="));
        System.out.println(IOUtils.validDirectory("These return themselves from short circuit"));
        System.out.println(IOUtils.validDirectory("D:/dev/workspaces/JIBS/web"));
        System.out.println(IOUtils.validDirectory("D:"));
        System.out.println(IOUtils.validDirectory("======================================="));
        System.out.println(IOUtils.validDirectory("These return themselves from not returning root exception"));
        System.out.println(IOUtils.validDirectory("D:/xxx"));
        System.out.println(IOUtils.validDirectory("D:/xxx/yyy"));
        System.out.println(IOUtils.validDirectory("D:/xxx/yyy/zzz"));
        System.out.println(IOUtils.validDirectory("======================================="));
        System.out.println(IOUtils.validDirectory("These return highest valid directory"));
        System.out.println(IOUtils.validDirectory("D:/dev/xxx/yyy/zzz"));
        System.out.println(IOUtils.validDirectory("D:/dev/workspaces/xxx/yyy/zzz"));
        System.out.println(IOUtils.validDirectory("D:/dev/workspaces/JIBS/xxx/yyy/zzz"));
        System.out.println(IOUtils.validDirectory("D:/dev/workspaces/JIBS/web/xxx/yyy/zzz"));
    }
}

