/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import com.saic.isd.swing.filechooser.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.gerhardb.lib.dirtree.filelist.popup.FileName;
import org.gerhardb.lib.io.Zip;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.startup.AppStarter;

public class ZipDialog
extends JDialog {
    File[] myFileList;
    FileName myFileName;
    private Scroller myScroller;

    public ZipDialog(JFrame frame, File[] fileList, Scroller scroller) {
        super(frame, AppStarter.getString("ZipDialog.0"), true);
        this.setIconImage(Icons.icon(26).getImage());
        this.myFileList = fileList;
        this.myFileName = new FileName(this.myFileList.length);
        this.myScroller = scroller;
        this.layoutScreen();
    }

    void ok() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.myFileList[0]);
        chooser.setDialogTitle(AppStarter.getString("ZipDialog.1"));
        chooser.setFileSelectionMode(2);
        SimpleFileFilter filter = new SimpleFileFilter("zip", AppStarter.getString("ZipDialog.3"));
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.myScroller.getFocusComponent());
        if (returnVal == 0) {
            int cancel;
            File saveZipFile = chooser.getSelectedFile();
            if (!saveZipFile.getName().toLowerCase().endsWith(".zip")) {
                saveZipFile = new File(saveZipFile.getAbsolutePath() + ".zip");
            }
            if (saveZipFile.exists() && (cancel = JOptionPane.showConfirmDialog(this, AppStarter.getString("ZipDialog.6"), AppStarter.getString("ZipDialog.7"), 0)) == 1) {
                return;
            }
            this.setWaitCursor(true);
            try {
                Zip.makeAZip(this.myFileList, saveZipFile, this.myFileName);
            }
            catch (Exception ex) {
                this.setWaitCursor(false);
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, ex.getMessage(), AppStarter.getString("problem"), 0);
            }
            this.setWaitCursor(false);
            this.setVisible(false);
            this.dispose();
        }
    }

    private void layoutScreen() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ZipDialog.this.cancel();
            }
        });
        JButton okBtn = new JButton(AppStarter.getString("ok"));
        okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ZipDialog.this.ok();
            }
        });
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ZipDialog.this.cancel();
            }
        });
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)this.getNamePanel(), "Center");
        thePanel.add((Component)btnPanel, "South");
        this.addAccelerators(okBtn, thePanel);
        this.getContentPane().add(thePanel);
        this.pack();
        SwingUtils.centerOnScreen(this);
        this.setVisible(true);
    }

    private JPanel getNamePanel() {
        final JTextField textFld = new JTextField(33);
        final JLabel sampleLbl = new JLabel("<html><big>&nbsp;</big></html>");
        textFld.setText("jibs-#");
        this.myFileName.setTemplate(textFld.getText());
        sampleLbl.setText(this.myFileName.getNewNameHTML(1, textFld.getText()));
        JPanelRows rtnMe = new JPanelRows(1);
        textFld.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ZipDialog.this.myFileName.setTemplate(textFld.getText());
                sampleLbl.setText(ZipDialog.this.myFileName.getNewNameHTML(1, textFld.getText()));
            }
        });
        JPanel row = rtnMe.topRow();
        row.add(new JLabel("Change name to" + AppStarter.getString("colon") + " "));
        row.add(textFld);
        row = rtnMe.nextRow();
        row.add(new JLabel("<html>&nbsp;</html>"));
        row.add(sampleLbl);
        row = rtnMe.nextRow();
        row.add(new JLabel(AppStarter.getString("ZipDialog.11")));
        row = rtnMe.nextRow();
        row.add(new JLabel(AppStarter.getString("ZipDialog.12")));
        return rtnMe;
    }

    void addAccelerators(JButton okBtn, JPanel thePanel) {
        InputMap map = null;
        this.getRootPane().setDefaultButton(okBtn);
        okBtn.setMnemonic(75);
        class Dismiss
        extends AbstractAction {
            Dismiss() {
                super("dismiss");
            }

            public void actionPerformed(ActionEvent e) {
                ZipDialog.this.cancel();
            }
        }
        Dismiss dismiss = new Dismiss();
        String cancelID = "dismiss";
        thePanel.getActionMap().put(cancelID, dismiss);
        map = thePanel.getInputMap(1);
        map.put(KeyStroke.getKeyStroke(27, 0), cancelID);
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

