/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.RootPaneContainer;
import org.gerhardb.lib.swing.GlassPane;

public class PrintJobUtils {
    private static PrinterJob clsPrinterJob = PrinterJob.getPrinterJob();

    public static String showPageFormat(PageFormat pf) {
        return (int)pf.getHeight() + ":" + (int)pf.getWidth() + "  " + (int)pf.getImageableHeight() + ":" + (int)pf.getImageableWidth() + "  " + (int)pf.getImageableX() + ":" + (int)pf.getImageableY();
    }

    public static PageFormat pageFormatDialog(PageFormat pf) {
        PageFormat rtnMe = clsPrinterJob.pageDialog(pf);
        return clsPrinterJob.validatePage(rtnMe);
    }

    public static PageFormat orientPageToImage(BufferedImage image) {
        PageFormat rtnMe = PrintJobUtils.maxMargins(clsPrinterJob, 1);
        if (image != null && image.getWidth() > image.getHeight()) {
            rtnMe = PrintJobUtils.maxMargins(clsPrinterJob, 0);
        }
        return clsPrinterJob.validatePage(rtnMe);
    }

    public static PageFormat maxMargins(PrinterJob printJob, int orientation) {
        PageFormat rtnPage = new PageFormat();
        rtnPage.setOrientation(orientation);
        PageFormat defaultPage = printJob.defaultPage(rtnPage);
        Paper rtnPaper = new Paper();
        rtnPaper.setSize(defaultPage.getWidth(), defaultPage.getHeight());
        rtnPaper.setImageableArea(0.0, 0.0, defaultPage.getWidth(), defaultPage.getHeight());
        rtnPage.setPaper(rtnPaper);
        rtnPage = printJob.validatePage(rtnPage);
        if (rtnPage.getWidth() <= rtnPage.getImageableWidth() || rtnPage.getHeight() <= rtnPage.getImageableHeight()) {
            Paper adjusted = new Paper();
            adjusted.setSize(rtnPage.getWidth(), rtnPage.getHeight());
            adjusted.setImageableArea(72.0, 72.0, rtnPage.getWidth() - 144.0, rtnPage.getHeight() - 144.0);
            rtnPage.setPaper(adjusted);
        }
        return rtnPage;
    }

    public static void threadedDefaultPrint(final Pageable pageable, final Component comp) {
        Thread show = new Thread(new Runnable(){

            public void run() {
                clsPrinterJob.setPageable(pageable);
                PrintJobUtils.unthreadedPrint(clsPrinterJob, comp);
            }
        });
        show.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unthreadedPrint(PrinterJob printJob, Component comp) {
        block10: {
            comp.setCursor(Cursor.getPredefinedCursor(3));
            GlassPane eatMe = new GlassPane();
            if (comp instanceof RootPaneContainer) {
                eatMe.setGlassPane((RootPaneContainer)((Object)comp));
            }
            try {
                comp.setCursor(Cursor.getPredefinedCursor(3));
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                        break block10;
                    }
                    catch (PrinterException ex) {
                        System.err.println("PrinterException has occurred:" + ex.getMessage());
                        ex.printStackTrace();
                        break block10;
                    }
                    finally {
                        comp.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                comp.setCursor(Cursor.getPredefinedCursor(0));
            }
            finally {
                comp.setCursor(Cursor.getPredefinedCursor(0));
                eatMe.removeGlassPane();
            }
        }
    }

    public static void main(String[] args) {
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.JPEG;
        PrintService[] theServices = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        System.out.println(defaultService.getName());
        PrintService service = ServiceUI.printDialog(null, 200, 200, theServices, defaultService, flavor, pras);
        if (service != null) {
            System.out.println(service.getName());
        }
    }
}

