/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoAlbumLink;
import fi.iki.jka.JPhotoBrowser;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoExifDialog;
import fi.iki.jka.JPhotoList;
import fi.iki.jka.JPhotoMenu;
import fi.iki.jka.JPhotoPageInfo;
import fi.iki.jka.JPhotoPanel;
import fi.iki.jka.JPhotoShow;
import fi.iki.jka.JPhotoStatus;
import fi.iki.jka.JPhotoTransferHandler;
import fi.iki.jka.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JPhotoFrame
extends JFrame
implements ListSelectionListener,
ActionListener {
    public static String FILE_EXT = ".jph";
    public static String APP_NAME = "JPhotoAlbum";
    public static String FRAME_X = "frame_x";
    public static String FRAME_Y = "frame_y";
    public static String FRAME_W = "frame_w";
    public static String FRAME_H = "frame_h";
    public static String SPLIT = "split";
    public static String EXIF_X = "exif_x";
    public static String EXIF_Y = "exif_y";
    public static String EXIF_W = "exif_w";
    public static String EXIF_H = "exif_h";
    public static String HELP_X = "help_x";
    public static String HELP_Y = "help_y";
    public static String HELP_W = "help_w";
    public static String HELP_H = "help_h";
    public static String PREV_FILE = "prev_file";
    public static String PAGEINFO = "pageinfo";
    public static String PHOTO_DIR = "photo_directory";
    protected Preferences prefs = null;
    protected String albumFileName = null;
    protected JPhotoList list = null;
    protected JPhotoCollection photos = null;
    protected JLabel statusLine = null;
    protected JTextField textInput = null;
    protected JPhoto editingPhoto = null;
    protected JFrame fullView = null;
    protected JPhotoPanel fullViewPanel = null;
    protected JScrollPane scrollPane = null;
    protected JSplitPane splitPane = null;
    protected JMenuBar menuBar = null;
    protected JPhotoTransferHandler transferHandler = null;
    protected JPhotoFrame frame = null;
    protected JPhotoExifDialog exifDialog = null;
    protected JFrame helpFrame = null;
    protected File photoDirectory = null;
    protected static HashMap allFrames = new HashMap();

    protected JPhotoFrame() throws Exception {
    }

    public JPhotoFrame(String frameName, JPhotoCollection photos) throws Exception {
        this.init(frameName, photos);
    }

    public JPhotoFrame(String frameName, String[] files) throws Exception {
        this.init(frameName, new JPhotoCollection(files));
    }

    protected void init(String frameName, JPhotoCollection photos) throws Exception {
        this.prefs = Preferences.userRoot().node("/fi/iki/jka/jphotoframe");
        JPhotoPageInfo.setDefault(this.prefs.get(PAGEINFO, null));
        this.photoDirectory = new File(this.prefs.get(PHOTO_DIR, System.getProperty("user.dir")));
        if (photos == null) {
            photos = new JPhotoCollection();
        }
        this.photos = photos;
        if (frameName != null) {
            this.albumFileName = frameName;
            if (!photos.load(this.albumFileName)) {
                JOptionPane.showMessageDialog(null, "Cannot open " + this.albumFileName, APP_NAME, 0);
            }
        }
        int splitWidth = this.prefs.getInt(SPLIT, 190);
        this.list = new JPhotoList(photos, splitWidth);
        this.transferHandler = new JPhotoTransferHandler(this.list);
        this.list.setTransferHandler(this.transferHandler);
        this.list.setDragEnabled(true);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseListener());
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setFocusable(false);
        this.scrollPane.addComponentListener(new ResizeAdapter());
        this.statusLine = new JLabel();
        this.statusLine.setFocusable(false);
        this.statusLine.setBackground(Color.white);
        this.statusLine.setForeground(Color.black);
        JPhotoStatus.setStatusLineLabel(this, this.statusLine);
        this.textInput = new JTextField();
        this.textInput.addFocusListener(new FocusHandler());
        this.fullViewPanel = new JPhotoPanel();
        this.fullViewPanel.setFullView(true);
        this.fullViewPanel.setTransferHandler(this.transferHandler);
        this.fullViewPanel.setBackground(photos.getBackgroundColor());
        this.splitPane = new JSplitPane(1, this.scrollPane, this.fullViewPanel);
        this.splitPane.setDividerSize(8);
        this.splitPane.setDividerLocation(splitWidth);
        this.splitPane.setOneTouchExpandable(true);
        this.menuBar = new JPhotoMenu(this).getMenuBar();
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.statusLine, "South");
        this.getContentPane().add((Component)this.textInput, "North");
        this.list.requestFocus();
        this.addWindowListener(new closeAdapter());
        this.setDefaultCloseOperation(0);
        JPhoto photo = (JPhoto)photos.getElementAt(0);
        if (photo != null) {
            this.selectPhoto(photo);
        } else {
            this.setTitle();
            this.statusLine.setText("Drag and drop photos to list or use File/Import operations. Original photos are never modified.");
        }
        InputMap im = this.textInput.getInputMap(1);
        ActionMap am = this.textInput.getActionMap();
        im.put(KeyStroke.getKeyStroke(38, 0), "moveSelectionUp");
        am.put("moveSelectionUp", new MoveSelection(-1));
        im.put(KeyStroke.getKeyStroke(40, 0), "moveSelectionDn");
        im.put(KeyStroke.getKeyStroke(10, 0), "moveSelectionDn");
        am.put("moveSelectionDn", new MoveSelection(1));
        this.pack();
        this.setLocation(this.prefs.getInt(FRAME_X, 50) + 20 * allFrames.size(), this.prefs.getInt(FRAME_Y, 20) + 20 * allFrames.size());
        this.setSize(this.prefs.getInt(FRAME_W, 700), this.prefs.getInt(FRAME_H, 550));
        this.frame = this;
        this.setFrameIcon();
        allFrames.put(frameName, this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        this.saveEdit();
        String cmd = event.getActionCommand();
        if (cmd.equals(JPhotoMenu.A_NEW) || cmd.equals(JPhotoMenu.A_OPEN)) {
            if (this.confirmedSave() != 2) {
                String file;
                this.photos = new JPhotoCollection();
                this.list.setPhotoModel(this.photos);
                this.albumFileName = null;
                this.editingPhoto = null;
                if (cmd.equals(JPhotoMenu.A_OPEN) && (file = this.askFileName(FILE_EXT, 0)) != null) {
                    try {
                        if (this.photos.load(file)) {
                            this.albumFileName = file;
                            this.list.setSelectedIndex(0);
                            this.list.recalculateVisibleRows();
                            this.editingPhoto = null;
                            this.setFrameIcon();
                        } else {
                            JOptionPane.showMessageDialog(this, String.valueOf(file) + " is not a valid JPhoto file.");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("load error:" + e);
                        JOptionPane.showMessageDialog(this, "Cannot open " + file, APP_NAME, 0);
                    }
                }
                JPhoto photo = (JPhoto)this.photos.getElementAt(0);
                this.selectPhoto(photo);
            }
        } else if (cmd.equals(JPhotoMenu.A_SAVE)) {
            this.askNameAndSave();
        } else if (cmd.equals(JPhotoMenu.A_SAVEAS)) {
            String file = this.askFileName(FILE_EXT, 1);
            if (file != null) {
                try {
                    if (this.photos.save(file)) {
                        this.albumFileName = file;
                        this.setTitle();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Cannot save as " + file, APP_NAME, 0);
                }
            }
        } else if (cmd.equals(JPhotoMenu.A_IMPORT_DIR) || cmd.equals(JPhotoMenu.A_IMPORT)) {
            String[] files = null;
            if (cmd.equals(JPhotoMenu.A_IMPORT_DIR)) {
                String dir = Utils.getDirectory(this, this.photoDirectory);
                if (dir != null) {
                    String[] input = new String[]{String.valueOf(dir) + File.separator};
                    files = Utils.expandAllDirectories(input);
                    if (files == null || files.length == 0) {
                        JOptionPane.showMessageDialog(this, "No photos in " + dir, APP_NAME, 0);
                    }
                    this.photoDirectory = new File(dir);
                }
            } else {
                files = JPhotoBrowser.getFiles(this, this.photoDirectory);
                if (JPhotoBrowser.getDefaultDirectory() != null) {
                    this.photoDirectory = JPhotoBrowser.getDefaultDirectory();
                }
            }
            if (files != null) {
                int index = this.list.getSelectedIndex();
                index = index < 0 ? 0 : ++index;
                this.list.getPhotoModel().addAll(index, files);
                this.list.setSelectedIndex(index - 1);
                Dimension dim = this.scrollPane.getViewport().getSize();
                this.list.setVisibleBounds(dim);
            }
        } else if (cmd.equals(JPhotoMenu.A_FIND_ORIGINALS)) {
            String[] files = null;
            String dir = Utils.getDirectory(this, this.photoDirectory);
            if (dir != null) {
                String[] input = new String[]{String.valueOf(dir) + File.separator};
                files = Utils.expandAllDirectories(input);
                if (files == null || files.length == 0) {
                    JOptionPane.showMessageDialog(this, "No photos in " + dir, APP_NAME, 0);
                } else {
                    this.photoDirectory = new File(dir);
                }
            }
            if (files != null) {
                this.list.getPhotoModel().findOriginals(files);
            }
        } else if (cmd.startsWith("as ")) {
            if (JPhotoStatus.inProgress()) {
                JOptionPane.showMessageDialog(this, "Already exporting, please wait.", APP_NAME, 0);
            } else {
                boolean status = false;
                if (this.askNameAndSave()) {
                    try {
                        this.setTitle();
                        if (cmd.equals(JPhotoMenu.A_EXPORT_1)) {
                            status = this.photos.exportHtmlJari1(this.albumFileName);
                        } else if (cmd.equals(JPhotoMenu.A_EXPORT_2)) {
                            status = this.photos.exportHtmlJari2(this.albumFileName);
                        }
                        if (!status) {
                            JOptionPane.showMessageDialog(this, "Export of " + this.albumFileName + " failed.", APP_NAME, 0);
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "Cannot save " + this.albumFileName, APP_NAME, 0);
                    }
                }
            }
        } else if (cmd.startsWith("for ")) {
            Object htmlFile = null;
            if (this.askNameAndSave()) {
                File target = new File(this.albumFileName).getAbsoluteFile().getParentFile();
                this.statusLine.setText("Exporting Template to " + target + "...");
                boolean status = false;
                if (cmd.equals(JPhotoMenu.A_EXPORT_TEMPLATE_1)) {
                    status = this.photos.exportTemplateJari1(target);
                } else if (cmd.equals(JPhotoMenu.A_EXPORT_TEMPLATE_2)) {
                    status = this.photos.exportTemplateJari2(target);
                } else if (cmd.equals(JPhotoMenu.A_EXPORT_TEMPLATE_INDEX)) {
                    status = this.photos.exportTemplateJari3(target);
                }
                if (!status) {
                    JOptionPane.showMessageDialog(this, "Export to " + target + " failed.", APP_NAME, 0);
                } else {
                    this.statusLine.setText("Exported template(s) to " + target);
                }
            }
        } else if (cmd.equals(JPhotoMenu.A_EXPORT_SUBTITLED)) {
            boolean status;
            if (this.askNameAndSave() && !(status = this.photos.exportSubtitledPhotos(this.albumFileName))) {
                JOptionPane.showMessageDialog(this, "Export subtitled to " + this.albumFileName + " failed.", APP_NAME, 0);
            }
        } else if (cmd.equals(JPhotoMenu.A_COPY_ORIGINALS)) {
            boolean status;
            if (this.askNameAndSave() && !(status = this.photos.copyOriginals(this.albumFileName, "originals", true))) {
                JOptionPane.showMessageDialog(this, "Copy originals to " + this.albumFileName + " failed.", APP_NAME, 0);
            }
        } else if (cmd.equals(JPhotoMenu.A_EXPORT_INDEX)) {
            if (this.askNameAndSave()) {
                boolean status = this.photos.exportHtmlJari3(this.albumFileName);
                if (!status) {
                    JOptionPane.showMessageDialog(this, "Export index failed.", APP_NAME, 0);
                } else {
                    JOptionPane.showMessageDialog(this, "Exported index of all linked albums.", APP_NAME, 1);
                }
            }
        } else if (cmd.equals(JPhotoMenu.A_EXIT)) {
            this.exitConfirmedSave();
        } else if (cmd.equals(JPhotoMenu.A_CUT)) {
            int index = this.list.getSelectedIndex();
            this.transferHandler.exportToClipboard(this.list, this.getToolkit().getSystemClipboard(), 2);
            this.list.setSelectedIndex(index);
        } else if (cmd.equals(JPhotoMenu.A_COPY)) {
            this.transferHandler.exportToClipboard(this.list, this.getToolkit().getSystemClipboard(), 1);
        } else if (cmd.equals(JPhotoMenu.A_PASTE)) {
            this.transferHandler.importData(this.list, this.getToolkit().getSystemClipboard().getContents(this.list));
        } else if (cmd.equals(JPhotoMenu.A_DELETE)) {
            int index = this.list.getSelectedIndex();
            Object[] selected = this.list.getSelectedValues();
            if (this.list != null) {
                int i = 0;
                while (i < selected.length) {
                    JPhoto photo = (JPhoto)selected[i];
                    this.photos.remove(photo);
                    ++i;
                }
            }
            this.list.setSelectedIndex(index);
        } else if (cmd.equals(JPhotoMenu.A_INSERT)) {
            int index = this.list.getSelectedIndex();
            this.photos.add(index, new JPhoto(this.photos));
            Dimension dim = this.scrollPane.getViewport().getSize();
            this.list.setVisibleBounds(dim);
            this.list.setSelectedIndex(index);
        } else if (cmd.equals(JPhotoMenu.A_INSERT_ALBUM)) {
            String file = this.askFileName(FILE_EXT, 0);
            if (file != null) {
                int index = this.list.getSelectedIndex();
                if (index < 0) {
                    index = this.photos.size();
                }
                JPhotoAlbumLink item = new JPhotoAlbumLink(this.photos, file);
                this.photos.add(index, item);
                Dimension dim = this.scrollPane.getViewport().getSize();
                this.list.setVisibleBounds(dim);
                this.list.setSelectedIndex(index);
            }
        } else if (cmd.equals(JPhotoMenu.A_TITLE)) {
            String res = JOptionPane.showInputDialog(this, "Page title", this.photos.getTitle());
            if (res != null) {
                this.photos.setTitle(res);
            }
            this.setTitle();
        } else if (cmd.equals(JPhotoMenu.A_DESCRIPTION)) {
            String res = JOptionPane.showInputDialog(this, "Page description", this.photos.getDescription());
            if (res != null) {
                this.photos.setDescription(res);
            }
            this.setTitle();
        } else if (cmd.equals(JPhotoMenu.A_KEYWORDS)) {
            String res;
            String def = this.photos.getKeywords();
            if (def.equals("")) {
                def = "digital photos ";
            }
            if ((res = JOptionPane.showInputDialog(this, "Keywords", def)) != null) {
                this.photos.setKeywords(res);
            }
            this.setTitle();
        } else if (cmd.equals(JPhotoMenu.A_WATERMARK)) {
            String res;
            String def = this.photos.getWatermark();
            if (def.equals("")) {
                def = "\u00a9 " + Calendar.getInstance().get(1) + " ";
            }
            if ((res = JOptionPane.showInputDialog(this, "Watermark", def)) != null) {
                this.photos.setWatermark(res);
            }
            this.setTitle();
        } else if (cmd.equals(JPhotoMenu.A_COVERPHOTO)) {
            JPhoto photo;
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                index = 0;
            }
            if ((photo = this.photos.get(index)).getImageName() != null) {
                this.photos.setCoverPhoto(this.photos.get(index));
                this.setFrameIcon();
            } else {
                JOptionPane.showMessageDialog(this, "Cover photo must be a real image.", APP_NAME, 0);
            }
        } else if (cmd.equals(JPhotoMenu.A_SAVE_DEFAULTS)) {
            this.prefs.put(PAGEINFO, this.photos.getPageInfo().marshal());
            JOptionPane.showMessageDialog(this, "Saved current page attributes as defaults.", APP_NAME, 1);
        } else if (cmd.equals(JPhotoMenu.A_FULLVIEW)) {
            this.startFullView();
        } else if (cmd.equals(JPhotoMenu.A_SHOWEXIF)) {
            this.showExif();
        } else if (cmd.equals(JPhotoMenu.A_SLIDESHOW)) {
            if (this.photos.getSize() > 0) {
                JPhotoShow show = new JPhotoShow(this.photos, 5000, this.list);
                show.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "No photos to show!", APP_NAME, 0);
            }
        } else if (cmd.equals(JPhotoMenu.A_HELP)) {
            this.displayHelp();
        } else if (cmd.equals(JPhotoMenu.A_ABOUT)) {
            JOptionPane.showMessageDialog(this, String.valueOf(APP_NAME) + " v1.3.0 - Organize and Publish Your Digital Photos.\n" + "Copyright 2004 Jari Karjala [www.jpkware.com] " + "and Tarja Hakala [www.hakalat.net]\n" + "This is free software, licenced under the GNU General Public License.", JPhotoMenu.A_ABOUT, 1);
        } else if (cmd.equals(JPhotoMenu.A_BACKGROUND)) {
            Color color = Utils.showColorDialog(this, "Choose Background Color", this.list.getBackground());
            if (color != null) {
                this.list.setBackground(color);
                this.fullViewPanel.setBackground(color);
                this.photos.setBackgroundColor(color);
            }
        } else if (cmd.equals(JPhotoMenu.A_FOREGROUND)) {
            Color color = Utils.showColorDialog(this, "Choose Foreground Color", this.list.getForeground());
            if (color != null) {
                this.list.setForeground(color);
                this.fullViewPanel.setForeground(color);
                this.photos.setForegroundColor(color);
            }
        } else {
            System.out.println("Not implemented: " + cmd);
        }
        this.setTitle();
    }

    public void insertPhotos(String[] files) {
        if (files != null) {
            int index = this.list.getSelectedIndex();
            index = index < 0 ? 0 : ++index;
            this.list.getPhotoModel().addAll(index, files);
            this.list.setSelectedIndex(index - 1);
            Dimension dim = this.scrollPane.getViewport().getSize();
            this.list.setVisibleBounds(dim);
        }
    }

    public void setFrameIcon() {
        BufferedImage icon = this.photos.getCoverIcon();
        if (icon == null) {
            URL res = this.getClass().getClassLoader().getResource("pics/JPhotoAlbum64.png");
            Image bi = new ImageIcon(res).getImage();
            this.setIconImage(bi);
        } else {
            Dimension limits = new Dimension(64, 64);
            limits = Utils.getScaledSize(limits, icon.getWidth(), icon.getHeight());
            BufferedImage bi = new BufferedImage(64, 64, 1);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(icon, (64 - limits.width) / 2, (64 - limits.height) / 2, limits.width, limits.height, null, null);
            g2.dispose();
            this.setIconImage(bi);
        }
    }

    public void showExif() {
        JPhoto photo = (JPhoto)this.list.getSelectedValue();
        if (photo == null) {
            System.out.println("No picture selected");
            return;
        }
        ArrayList<Tag> tagValues = new ArrayList<Tag>();
        ExifDirectory directory = photo.getExifDirectory();
        Iterator tags = directory.getTagIterator();
        while (tags.hasNext()) {
            Tag tag = (Tag)tags.next();
            tagValues.add(tag);
        }
        if (directory.hasErrors()) {
            Iterator errors = directory.getErrors();
            while (errors.hasNext()) {
                System.out.println("ERROR: " + errors.next());
            }
        }
        JDialog dialog = this.getExifDialog(tagValues);
        this.exifDialog.setTitle(photo.getImageName());
        this.exifDialog.setVisible(true);
    }

    public JDialog getExifDialog(List tagValues) {
        if (this.exifDialog == null) {
            this.exifDialog = new JPhotoExifDialog((Frame)this, tagValues, this.prefs);
        } else {
            this.exifDialog.changeTagValues(tagValues);
        }
        return this.exifDialog;
    }

    public String askFileName(String extension, int mode) {
        String file = null;
        FileDialog dialog = new FileDialog((Frame)this, "Select Album filename", mode);
        dialog.setFile("*" + extension);
        dialog.show();
        if (dialog.getFile() != null) {
            file = String.valueOf(dialog.getDirectory()) + dialog.getFile();
            System.out.println("askFileName: " + file);
            if (!file.toLowerCase().endsWith(extension)) {
                file = String.valueOf(file) + extension;
            }
        }
        dialog.dispose();
        return file;
    }

    public void exitConfirmedSave() {
        this.savePrefs();
        if (this.confirmedSave() != 2) {
            if (allFrames.size() > 1) {
                this.setVisible(false);
                allFrames.remove(this.getFrameName());
                System.out.println("removed " + this.getFrameName() + ", no exit yet");
            } else {
                System.out.println("Last window closed, exit");
                System.exit(0);
            }
        }
    }

    public void savePrefs() {
        try {
            Rectangle b = this.getBounds();
            this.prefs.putInt(FRAME_X, b.x);
            this.prefs.putInt(FRAME_Y, b.y);
            this.prefs.putInt(FRAME_W, b.width);
            this.prefs.putInt(FRAME_H, b.height);
            this.prefs.putInt(SPLIT, this.splitPane.getDividerLocation());
            if (this.exifDialog != null) {
                b = this.exifDialog.getBounds();
                this.prefs.putInt(EXIF_X, b.x);
                this.prefs.putInt(EXIF_Y, b.y);
                this.prefs.putInt(EXIF_W, b.width);
                this.prefs.putInt(EXIF_H, b.height);
            }
            if (this.helpFrame != null) {
                b = this.helpFrame.getBounds();
                this.prefs.putInt(HELP_X, b.x);
                this.prefs.putInt(HELP_Y, b.y);
                this.prefs.putInt(HELP_W, b.width);
                this.prefs.putInt(HELP_H, b.height);
            }
            this.prefs.put(PHOTO_DIR, this.photoDirectory.toString());
        }
        catch (Exception e) {
            System.out.println("savePrefs:" + e);
        }
    }

    public boolean askNameAndSave() {
        if (this.albumFileName == null) {
            this.albumFileName = this.askFileName(FILE_EXT, 1);
        } else if (!this.photos.isDirty()) {
            return true;
        }
        if (this.albumFileName != null) {
            try {
                if (this.photos.save(this.albumFileName)) {
                    this.setTitle();
                    return true;
                }
                JOptionPane.showMessageDialog(this, "Saving " + this.albumFileName + " failed", APP_NAME, 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Save exception " + this.albumFileName + ":" + e.getMessage(), APP_NAME, 0);
            }
        }
        return false;
    }

    public int confirmedSave() {
        if (!this.photos.isDirty()) {
            return 1;
        }
        String prompt = "Save " + (this.albumFileName == null ? "" : this.albumFileName) + "?";
        int res = JOptionPane.showConfirmDialog(this.frame, prompt, APP_NAME, 1);
        if (res == 0) {
            if (this.albumFileName == null) {
                this.albumFileName = this.askFileName(FILE_EXT, 1);
            }
            if (this.albumFileName != null) {
                this.frame.photos.save(this.albumFileName);
            } else {
                res = 2;
            }
        }
        this.setTitle();
        return res;
    }

    public void saveEdit() {
        if (this.editingPhoto != null && !this.textInput.getText().equals(this.editingPhoto.getText())) {
            this.editingPhoto.setText(this.textInput.getText());
            this.photos.setDirty(true);
        }
    }

    public void selectPhoto(JPhoto photo) {
        this.setTitle();
        this.saveEdit();
        this.editingPhoto = photo;
        if (photo == null) {
            this.statusLine.setText("Nothing selected");
            this.textInput.setText("");
            this.setFullViewPhoto(null);
            return;
        }
        if (photo.getAlbumLink() != null) {
            this.statusLine.setText("Link to " + photo.getFullAlbumLink());
        } else if (photo.getOriginalName() != null) {
            this.statusLine.setText(String.valueOf(photo.getOriginalName()) + ": " + photo.getExif().toString());
        } else {
            this.statusLine.setText("");
        }
        this.textInput.setText(photo.getText());
        if (this.exifDialog != null && this.exifDialog.isVisible()) {
            this.showExif();
        }
        this.setFullViewPhoto(photo);
    }

    public void setTitle() {
        int sel = this.list.getSelectedIndex();
        this.setTitle(String.valueOf(this.photos.getTitle().equals("") ? this.getFrameName() : this.photos.getTitle()) + " - " + (this.editingPhoto != null ? String.valueOf(sel + 1) + "/" : "") + this.photos.getSize() + " Photos " + (this.photos.isDirty() ? " [modified]" : "") + " - " + APP_NAME);
        this.list.setForeground(this.photos.getForegroundColor());
        this.list.setBackground(this.photos.getBackgroundColor());
    }

    public void setFullViewPhoto(JPhoto photo) {
        this.fullViewPanel.setForeground(this.photos.getForegroundColor());
        this.fullViewPanel.setBackground(this.photos.getBackgroundColor());
        this.fullViewPanel.setWatermark(this.photos.getWatermark());
        this.fullViewPanel.setPhoto(photo);
    }

    public void valueChanged(ListSelectionEvent e) {
        JPhoto photo = (JPhoto)this.list.getSelectedValue();
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.selectPhoto(photo);
    }

    public void startFullView() {
        if (this.list.getSelectedIndex() >= 0) {
            JPhoto photo = (JPhoto)this.photos.getElementAt(this.list.getSelectedIndex());
            if (photo.getAlbumLink() != null) {
                String newFile = photo.getFullAlbumLink();
                if (!this.showExistingFrame(newFile)) {
                    JPhotoFrame newFrame = null;
                    try {
                        newFrame = new JPhotoFrame(newFile, new JPhotoCollection(newFile));
                        newFrame.setVisible(true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Cannot open " + newFile, APP_NAME, 0);
                    }
                }
            } else {
                JPhotoShow show = new JPhotoShow(this.photos, 0, this.list);
                show.setVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Select a photo to view!", APP_NAME, 0);
        }
    }

    public String getFrameName() {
        if (this.albumFileName == null) {
            return "[Unsaved]";
        }
        return this.albumFileName;
    }

    public boolean showExistingFrame(String frameName) {
        JPhotoFrame oldOne = (JPhotoFrame)allFrames.get(frameName);
        if (oldOne != null) {
            oldOne.setVisible(true);
            return true;
        }
        return false;
    }

    public void toggleView() {
        int max = this.splitPane.getWidth() - this.splitPane.getDividerSize();
        if (this.splitPane.getDividerLocation() < max) {
            this.splitPane.setDividerLocation(max);
        } else {
            this.splitPane.setDividerLocation(this.splitPane.getLastDividerLocation());
        }
    }

    public void displayHelp() {
        if (this.helpFrame == null) {
            JTextPane tp = new JTextPane();
            tp.setEditable(false);
            JScrollPane js = new JScrollPane();
            js.getViewport().add(tp);
            this.helpFrame = new JFrame();
            this.helpFrame.setTitle(String.valueOf(APP_NAME) + " Help");
            this.helpFrame.getContentPane().add(js);
            this.helpFrame.pack();
            this.helpFrame.setSize(this.prefs.getInt(HELP_W, 400), this.prefs.getInt(HELP_H, 400));
            this.helpFrame.setLocation(this.prefs.getInt(HELP_X, 500), this.prefs.getInt(HELP_Y, 50));
            try {
                URL help = this.getClass().getClassLoader().getResource("jphotohelp.html");
                tp.setPage(help);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.helpFrame.setVisible(true);
    }

    public static boolean exportAll(String jphFile, String flags) {
        boolean ok = false;
        try {
            jphFile = new File(jphFile).getAbsolutePath();
            JPhotoCollection photos = new JPhotoCollection(jphFile);
            photos.disableGui();
            if (flags.indexOf(48) >= 0) {
                ok |= photos.exportSubtitledPhotos(jphFile);
            }
            if (flags.indexOf(49) >= 0) {
                ok |= photos.exportHtmlJari1(jphFile);
            }
            if (flags.indexOf(50) >= 0) {
                ok |= photos.exportHtmlJari2(jphFile);
            }
            if (flags.indexOf(51) >= 0) {
                ok |= photos.exportHtmlTarja2(jphFile);
            }
        }
        catch (Exception e) {
            System.out.println("exportAll:");
            e.printStackTrace(System.out);
        }
        return ok;
    }

    public static void main(String[] args) throws Exception {
        JPhotoFrame frame = null;
        if (args.length == 0) {
            frame = new JPhotoFrame(null, null);
        } else if (args[0].equals("show") && args.length > 1) {
            String[] newArgs = new String[]{args[1]};
            JPhotoShow.main(newArgs);
        } else if (args[0].startsWith("export")) {
            String flags = "0123";
            if (args[0].length() > 5) {
                flags = args[0].substring(6);
            }
            int i = 1;
            while (i < args.length) {
                JPhotoFrame.exportAll(args[i], flags);
                ++i;
            }
        } else if (args[0].indexOf(FILE_EXT) < 0) {
            frame = new JPhotoFrame(null, Utils.expandAllDirectories(args));
        } else {
            try {
                String fileName = new File(args[0]).getAbsolutePath();
                frame = new JPhotoFrame(fileName, null);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot open " + args[0] + ":" + e, APP_NAME, 0);
                System.exit(1);
            }
        }
    }

    class ResizeAdapter
    extends ComponentAdapter {
        ResizeAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            Dimension dim = JPhotoFrame.this.scrollPane.getViewport().getSize();
            JPhotoFrame.this.list.setVisibleBounds(dim);
        }
    }

    class closeAdapter
    extends WindowAdapter {
        closeAdapter() {
        }

        public void windowClosing(WindowEvent evt) {
            JPhotoFrame.this.exitConfirmedSave();
            System.out.println("Exit cancelled.");
        }
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() == 1) {
                JPhoto photo = (JPhoto)JPhotoFrame.this.list.getSelectedValue();
                JPhotoFrame.this.selectPhoto(photo);
            }
            if (e.getClickCount() == 2) {
                JPhotoFrame.this.startFullView();
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusLost(FocusEvent e) {
            JPhotoFrame.this.saveEdit();
        }
    }

    class MoveSelection
    extends AbstractAction {
        int direction;

        public MoveSelection(int dir) {
            this.direction = dir;
        }

        public void actionPerformed(ActionEvent ae) {
            JPhotoFrame.this.list.moveSelection(this.direction);
        }
    }
}

