/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class JPhotoShow
extends JFrame {
    JPhotoCollection photos = null;
    JPhotoPanel panel = null;
    JList parentList = null;
    int selected = 0;
    Timer timer = null;
    static boolean isStandalone = false;
    public static final String A_CLOSE = "close";
    public static final String A_NEXT = "next";
    public static final String A_PREV = "prev";
    public static final String A_EXIT = "exit";

    public JPhotoShow(JPhotoCollection photos) {
        this(photos, 5000, null);
    }

    public JPhotoShow(JPhotoCollection photos, int interval, JList list) {
        this.photos = photos;
        this.panel = new JPhotoPanel();
        this.panel.setFullView(true);
        Container picPane = this.getContentPane();
        picPane.add(this.panel);
        if (list != null) {
            this.selected = list.getSelectedIndex();
            this.parentList = list;
        }
        this.panel.setPhoto((JPhoto)photos.getElementAt(this.selected));
        this.panel.setForeground(Color.green);
        this.panel.setBackground(Color.black);
        this.panel.setShowtext(true);
        this.panel.setFont(new Font("SansSerif", 1, 16));
        this.setUndecorated(true);
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        if (isStandalone) {
            this.addAction(A_EXIT, KeyStroke.getKeyStroke(27, 0));
        } else {
            this.addAction(A_CLOSE, KeyStroke.getKeyStroke(27, 0));
        }
        this.addAction(A_CLOSE, KeyStroke.getKeyStroke(88, 0));
        this.addAction(A_NEXT, KeyStroke.getKeyStroke(40, 0));
        this.addAction(A_NEXT, KeyStroke.getKeyStroke(32, 0));
        this.addAction(A_PREV, KeyStroke.getKeyStroke(38, 0));
        this.addAction(A_PREV, KeyStroke.getKeyStroke(8, 0));
        if (interval == 0) {
            this.addAction(A_CLOSE, KeyStroke.getKeyStroke(10, 0));
        }
        if (interval > 0) {
            this.timer = new Timer(interval, new ShowAction(A_NEXT));
            this.timer.start();
        }
    }

    void addAction(String code, KeyStroke key) {
        InputMap im = this.panel.getInputMap(2);
        ActionMap am = this.panel.getActionMap();
        im.put(key, code);
        am.put(code, new ShowAction(code));
    }

    void moveSelection(int delta) {
        int max = this.photos.getSize() - 1;
        this.selected += delta;
        if (this.selected < 0) {
            this.selected = max;
        }
        if (this.selected > max) {
            this.selected = 0;
        }
        this.panel.setPhoto((JPhoto)this.photos.getElementAt(this.selected));
    }

    public static void main(String[] args) {
        isStandalone = true;
        System.out.println("This is a standalone JShow");
        JPhotoShow show = new JPhotoShow(new JPhotoCollection(args[0]), 5000, null);
        show.setVisible(true);
    }

    class ShowAction
    extends AbstractAction {
        String cmd = null;

        public ShowAction(String code) {
            super(code);
            this.cmd = code;
        }

        public void actionPerformed(ActionEvent ae) {
            System.out.println("ShowAction: cmd=" + this.cmd);
            if (this.cmd.equals(JPhotoShow.A_CLOSE)) {
                JPhotoShow.this.setVisible(false);
                if (JPhotoShow.this.timer != null) {
                    JPhotoShow.this.timer.stop();
                }
                if (JPhotoShow.this.parentList != null) {
                    JPhotoShow.this.parentList.setSelectedValue(JPhotoShow.this.photos.getElementAt(JPhotoShow.this.selected), true);
                }
                JPhotoShow.this.dispose();
            } else if (this.cmd.equals(JPhotoShow.A_NEXT)) {
                JPhotoShow.this.moveSelection(1);
                if (JPhotoShow.this.timer != null) {
                    JPhotoShow.this.timer.restart();
                }
            } else if (this.cmd.equals(JPhotoShow.A_PREV)) {
                JPhotoShow.this.moveSelection(-1);
                if (JPhotoShow.this.timer != null) {
                    JPhotoShow.this.timer.restart();
                }
            } else if (this.cmd.equals(JPhotoShow.A_EXIT)) {
                System.exit(0);
            }
        }
    }
}

