/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class Utils {
    static File currentFileDir = null;

    public static String convertColorToValue(Color color) {
        return "#" + (color.getRed() < 16 ? "0" : "") + Integer.toHexString(color.getRed()).toUpperCase() + (color.getGreen() < 16 ? "0" : "") + Integer.toHexString(color.getGreen()).toUpperCase() + (color.getBlue() < 16 ? "0" : "") + Integer.toHexString(color.getBlue()).toUpperCase();
    }

    public static Color convertValueToColor(String value) {
        return Color.decode(value);
    }

    public static String[] expandAllDirectories(String[] files) {
        ArrayList<String> list = new ArrayList<String>(files.length);
        int i = 0;
        while (i < files.length) {
            String[] subFiles = Utils.expandDirectory(files[i]);
            if (subFiles != null) {
                list.addAll(Arrays.asList(subFiles));
            }
            ++i;
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public static String[] expandDirectory(String dir) {
        return Utils.expandDirectory(dir, false);
    }

    public static String[] expandDirectory(String dir, boolean includeDirs) {
        File info = new File(dir);
        if (info.isDirectory()) {
            final boolean dirsToo = includeDirs;
            String[] subFiles = info.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return Utils.isImageName(name) || dirsToo && new File(dir, name).isDirectory();
                }
            });
            int i = 0;
            while (i < subFiles.length) {
                subFiles[i] = String.valueOf(dir) + File.separator + subFiles[i];
                ++i;
            }
            return subFiles;
        }
        if (Utils.isImageName(dir)) {
            String[] res = new String[]{dir};
            return res;
        }
        return null;
    }

    public static boolean isImageName(String name) {
        return (name = name.toLowerCase()).endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".png");
    }

    public static boolean isVideoName(String name) {
        name = name.toLowerCase();
        return name.endsWith(".avi");
    }

    public static String getFileName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return name;
        }
        int index = name.lastIndexOf(".");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String getFileBase(String name, String ext) {
        int index = name.toLowerCase().lastIndexOf(ext.toLowerCase());
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String getFileExt(String name, String def) {
        int index = name.lastIndexOf(".");
        if (index > 0) {
            return name.substring(index + 1);
        }
        return def;
    }

    public static Dimension getScaledSize(Dimension limits, int w, int h) {
        double wr = (double)w / (double)limits.width;
        double hr = (double)h / (double)limits.height;
        double scale = Math.max(wr, hr);
        scale = Math.max(scale, 1.0);
        return new Dimension((int)((double)w / scale), (int)((double)h / scale));
    }

    public static Dimension getAnyScaledSize(Dimension limits, int w, int h) {
        double wr = (double)w / (double)limits.width;
        double hr = (double)h / (double)limits.height;
        double scale = Math.max(wr, hr);
        return new Dimension((int)((double)w / scale), (int)((double)h / scale));
    }

    public static String getXmlFile(Frame parent) {
        FileDialog dialog = new FileDialog(parent, "Select PhotoAlbum file ...", 0);
        dialog.setFile("*.xml");
        dialog.show();
        if (dialog.getFile() != null) {
            System.out.println("Selected file: " + dialog.getDirectory() + dialog.getFile());
        }
        String result = null;
        if (dialog.getFile() != null && dialog.getFile().endsWith(".xml")) {
            result = String.valueOf(dialog.getDirectory()) + dialog.getFile();
        } else if (dialog.getFile() != null) {
            JOptionPane.showMessageDialog(parent, "This is not a PhotoAlbum file.\n PhotoAlbum files end with .xml", "Wrong file type", 0);
        }
        dialog.dispose();
        return result;
    }

    public static String getPictureDirectory(Frame parent) {
        FileDialog dialog = new FileDialog(parent, "Select picture dicretory ...", 0);
        dialog.show();
        if (dialog.getFile() != null) {
            System.out.println("Selected file: " + dialog.getDirectory() + dialog.getFile());
        }
        dialog.dispose();
        if (dialog.getDirectory() == null) {
            return null;
        }
        if (dialog.getFile() == null) {
            return null;
        }
        return String.valueOf(dialog.getDirectory()) + dialog.getFile();
    }

    public static String getDirectory(Component parent) {
        return Utils.getDirectory(parent, currentFileDir);
    }

    public static String getDirectory(Component parent, File dir) {
        JFileChooser chooser = null;
        chooser = dir == null ? new JFileChooser() : new JFileChooser(dir);
        chooser.setFileSelectionMode(1);
        DirFilter filter = new DirFilter();
        chooser.addChoosableFileFilter(filter);
        if (chooser.showDialog(parent, "Select a directory") != 0) {
            return null;
        }
        currentFileDir = chooser.getCurrentDirectory();
        return chooser.getSelectedFile().getAbsolutePath();
    }

    public static String[] getFiles(Component parent) {
        JFileChooser chooser = null;
        chooser = currentFileDir == null ? new JFileChooser() : new JFileChooser(currentFileDir);
        chooser.setFileSelectionMode(0);
        PicFilter filter = new PicFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showDialog(parent, "Select files") != 0) {
            return null;
        }
        String[] strings = null;
        File[] files = chooser.getSelectedFiles();
        if (files != null && files.length > 0) {
            strings = new String[files.length];
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                strings[i] = file.getAbsolutePath();
                ++i;
            }
        }
        chooser.setVisible(false);
        currentFileDir = chooser.getCurrentDirectory();
        return strings;
    }

    public static boolean generateDirectory(Component parent, String path) {
        int n;
        File file = new File(path);
        if (!file.exists() && (n = JOptionPane.showConfirmDialog(parent, "Directory " + path + "  does not exists.\nWould you like to create it ?", "Directory does not exists", 0)) == 0) {
            return file.mkdir();
        }
        return false;
    }

    public static String getImageName(String path) {
        if (path == null) {
            return "";
        }
        File file = new File(path);
        return file.getName();
    }

    public static void showErrorDialog(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error", 0);
    }

    public static String generateOriginalLink(String originalFile, String path) {
        int index;
        if (path == null || originalFile == null) {
            return null;
        }
        originalFile = originalFile.toLowerCase();
        path = path.toLowerCase();
        StringBuffer link = new StringBuffer();
        int lastIndex = 0;
        while ((index = path.lastIndexOf(File.separator)) > 0) {
            lastIndex = index;
            if (originalFile.startsWith(path.substring(0, index))) break;
            link.append("../");
            path = path.substring(0, index - 1);
        }
        link.append(originalFile.substring(lastIndex + 1));
        if (link.indexOf(":") >= 0) {
            return null;
        }
        return link.toString();
    }

    public static String getRelativePath(File original, File directory) {
        String result = null;
        try {
            String o = original.getCanonicalPath();
            String dir = String.valueOf(directory.getCanonicalPath()) + File.separator;
            int lastCommon = 0;
            int index = dir.indexOf(File.separator);
            while (index >= 0) {
                if (!dir.regionMatches(true, lastCommon, o, lastCommon, index - lastCommon)) break;
                lastCommon = index;
                index = dir.indexOf(File.separator, index + 1);
            }
            if (lastCommon == 0) {
                return o;
            }
            StringBuffer resultbuf = new StringBuffer(o.length());
            if (index > 0) {
                while (index >= 0) {
                    resultbuf.append("../");
                    index = dir.indexOf(File.separator, index + 1);
                }
            }
            resultbuf.append(o.substring(lastCommon + 1));
            result = resultbuf.toString();
        }
        catch (Exception e) {
            System.out.println("getRelativePath:" + e);
            result = original.getAbsolutePath();
        }
        return result.replace('\\', '/');
    }

    public static Color showColorDialog(Component comp, String title, Color defaultColor) {
        Color newColor = JColorChooser.showDialog(comp, title, defaultColor);
        return newColor;
    }

    public static boolean copyStreamToFile(InputStream in, File target) {
        try {
            int c;
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[16384];
            while ((c = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, c);
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("copyStreamToFile:" + e);
            return false;
        }
    }

    public static String getCallingMethod() {
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        if (elements.length < 3) {
            return "<outside JVM>";
        }
        return String.valueOf(elements[2].getClassName()) + "." + elements[2].getMethodName() + ":" + elements[2].getLineNumber();
    }

    public static float drawWrappedText(Graphics2D g2, float x, float y, float width, String text) {
        float sh;
        float sw;
        float dx;
        TextLayout layout;
        LineBreakMeasurer measurer;
        AttributedCharacterIterator chars;
        if (text == null || text.length() == 0) {
            return y;
        }
        FontRenderContext frc = g2.getFontRenderContext();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.0f));
        AttributedString astr = new AttributedString(text);
        astr.addAttribute(TextAttribute.FONT, g2.getFont(), 0, text.length());
        if (y < 0.0f) {
            y = -y;
            chars = astr.getIterator();
            measurer = new LineBreakMeasurer(chars, frc);
            while (measurer.getPosition() < chars.getEndIndex()) {
                layout = measurer.nextLayout(width);
                y -= layout.getAscent();
                dx = layout.isLeftToRight() ? 0.0f : width - layout.getAdvance();
                sw = (float)layout.getBounds().getWidth();
                sh = (float)layout.getBounds().getHeight();
                y -= layout.getDescent() + layout.getLeading();
            }
        }
        chars = astr.getIterator();
        measurer = new LineBreakMeasurer(chars, frc);
        while (measurer.getPosition() < chars.getEndIndex()) {
            layout = measurer.nextLayout(width);
            dx = layout.isLeftToRight() ? 0.0f : width - layout.getAdvance();
            sw = (float)layout.getBounds().getWidth();
            sh = (float)layout.getBounds().getHeight();
            Shape sha = layout.getOutline(AffineTransform.getTranslateInstance(x, y += layout.getAscent()));
            Color oldColor = g2.getColor();
            g2.setColor(g2.getBackground());
            g2.draw(sha);
            g2.setColor(oldColor);
            g2.fill(sha);
            y += layout.getDescent() + layout.getLeading();
        }
        return y;
    }

    public static void main(String[] args) {
        System.out.println(Utils.getRelativePath(new File(args[0]), new File(args[1])));
    }

    static class DirFilter
    extends FileFilter {
        DirFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname == null) {
                return false;
            }
            return pathname.isDirectory();
        }

        public String getDescription() {
            return "Directory";
        }
    }

    static class PicFilter
    extends FileFilter {
        PicFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname == null) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            return Utils.isImageName(pathname.getAbsolutePath());
        }

        public String getDescription() {
            return ".jpg, .gif, .png";
        }
    }
}

