/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.DescriptorSourceFactory;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SourceFactory;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.BindingLoader;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.PackageType;
import org.exolab.castor.builder.binding.PackageTypeChoice;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.types.BindingType;
import org.exolab.castor.builder.util.ConsoleDialog;
import org.exolab.castor.util.CommandLineOptions;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JStructure;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SourceGenerator {
    static final String APP_NAME = "Castor";
    static final String APP_DESC = "XML data binder for Java";
    static final String VERSION = "0.9.4.2";
    static final String APP_URI = "http://www.castor.org";
    private static final String DEFAULT_HEADER = "This class was automatically generated with \n<a href=\"http://www.castor.org\">Castor 0.9.4.2</a>, using an XML Schema.\n$Id$";
    private static final String ELEMENT_VALUE = "element";
    private static final String TYPE_VALUE = "type";
    private static final int ELEMENT_BINDING = 0;
    private static final int TYPE_BINDING = 1;
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshalling framework methods (marshall, unmarshall, validate).";
    private static final String CASTOR_TESTABLE_MSG = "The generated classes will implement org.exolab.castor.tests.CastorTestable";
    private static final String SAX1_MSG = "The generated classes will use SAX 1";
    private static final String IMPORT_WARNING = "Warning: Do not forget to generate source code for the following imported schema: ";
    private static int _bindingType = 0;
    private static boolean _boundProperties = false;
    private Configuration _config = null;
    private static boolean _equalsMethod = false;
    private static boolean _hasLocalEquals = false;
    private static boolean _generateExtraCollectionMethods = false;
    private static boolean _classDescFieldNames = false;
    private static boolean _hasLocalClassField = false;
    private static boolean _wrapper = false;
    private static boolean _hasLocalWrapper = false;
    private static Properties _default;
    private static boolean _loaded;
    private XMLBindingComponent _bindingComponent = new XMLBindingComponent();
    private static Hashtable _nspackages;
    private static Hashtable _locpackages;
    private String _lineSeparator = null;
    private JComment _header = null;
    private boolean _warnOnOverwrite = true;
    private boolean _suppressNonFatalWarnings = false;
    private boolean _verbose = false;
    private String _destDir = null;
    private boolean _createDescriptors = true;
    private boolean _createMarshall = true;
    private boolean _testable = false;
    private FieldInfoFactory _infoFactory = null;
    private SourceFactory _sourceFactory = null;
    private ConsoleDialog _dialog = null;
    static /* synthetic */ Class class$org$exolab$castor$builder$SourceGenerator;

    public SourceGenerator() {
        this(null);
    }

    public SourceGenerator(FieldInfoFactory fieldInfoFactory) {
        this(fieldInfoFactory, null);
    }

    public SourceGenerator(FieldInfoFactory fieldInfoFactory, ExtendedBinding extendedBinding) {
        this._config = LocalConfiguration.getInstance();
        this._dialog = new ConsoleDialog();
        this._infoFactory = fieldInfoFactory == null ? new FieldInfoFactory() : fieldInfoFactory;
        _hasLocalClassField = false;
        _hasLocalEquals = false;
        _hasLocalWrapper = false;
        this._sourceFactory = new SourceFactory(fieldInfoFactory);
        this._header = new JComment(3);
        this._header.appendComment(DEFAULT_HEADER);
        this.setBinding(extendedBinding);
    }

    public void generateSource(Schema schema, String string) {
        String string2;
        if (schema == null) {
            String string3 = "The argument 'schema' must not be null.";
            throw new IllegalArgumentException(string3);
        }
        SGStateInfo sGStateInfo = new SGStateInfo(schema);
        try {
            schema.validate();
        }
        catch (ValidationException validationException) {
            String string4 = "The schema:" + schema.getSchemaLocation() + " is not valid.\n";
            string4 = string4 + validationException.getMessage();
            throw new IllegalArgumentException(string4);
        }
        if (string == null && (string = SourceGenerator.lookupPackageLocation(string2 = schema.getSchemaLocation())) == null) {
            String string5 = schema.getTargetNamespace();
            string = SourceGenerator.lookupPackageNamespace(string5);
        }
        sGStateInfo.packageName = string;
        sGStateInfo.setDialog(this._dialog);
        sGStateInfo.setPromptForOverwrite(this._warnOnOverwrite);
        sGStateInfo.setVerbose(this._verbose);
        sGStateInfo.setSuppressNonFatalWarnings(this._suppressNonFatalWarnings);
        this.createClasses(schema, sGStateInfo);
    }

    public void generateSource(InputSource inputSource, String string) {
        Parser parser = null;
        try {
            parser = this._config.getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            this._dialog.notify("fatal error: unable to create SAX parser.");
            return;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller();
        }
        catch (XMLException xMLException) {
            xMLException.printStackTrace();
            System.exit(1);
        }
        Sax2ComponentReader sax2ComponentReader = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(sax2ComponentReader);
        parser.setErrorHandler(sax2ComponentReader);
        try {
            parser.parse(inputSource);
        }
        catch (IOException iOException) {
            this._dialog.notify("error reading XML Schema file");
            return;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                this._dialog.notify("SAXParseException: " + sAXParseException);
                this._dialog.notify(" - occured at line ");
                this._dialog.notify(new Integer(sAXParseException.getLineNumber()).toString());
                this._dialog.notify(", column ");
                this._dialog.notify(new Integer(sAXParseException.getColumnNumber()).toString());
            } else {
                exception.printStackTrace();
            }
            return;
        }
        Schema schema = schemaUnmarshaller.getSchema();
        this.generateSource(schema, string);
    }

    public void generateSource(Reader reader, String string) {
        InputSource inputSource = new InputSource(reader);
        this.generateSource(inputSource, string);
    }

    public void generateSource(String string, String string2) throws FileNotFoundException {
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        FileReader fileReader = new FileReader(string);
        InputSource inputSource = new InputSource(fileReader);
        inputSource.setSystemId(SourceGenerator.toURIRepresentation(new File(string).getAbsolutePath()));
        this.generateSource(inputSource, string2);
        try {
            fileReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized Properties getDefault() {
        if (_default == null) {
            SourceGenerator.load();
        }
        return _default;
    }

    public static String getProperty(String string, String string2) {
        return SourceGenerator.getDefault().getProperty(string, string2);
    }

    public static boolean boundPropertiesEnabled() {
        boolean bl = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.boundproperties", "").equalsIgnoreCase("true");
        return _boundProperties || bl;
    }

    public static boolean equalsMethod() {
        boolean bl = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.equalsmethod", "").equalsIgnoreCase("true");
        if (_hasLocalEquals) {
            return _equalsMethod;
        }
        return bl;
    }

    public static void setEqualsMethod(boolean bl) {
        _equalsMethod = bl;
        _hasLocalEquals = true;
    }

    public static boolean classDescFieldNames() {
        boolean bl = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.classdescfieldnames", "").equalsIgnoreCase("true");
        if (_hasLocalClassField) {
            return _classDescFieldNames;
        }
        return bl;
    }

    public static void setClassDescFieldNames(boolean bl) {
        SourceGenerator.getDefault();
        _classDescFieldNames = bl;
        _hasLocalClassField = true;
    }

    public static boolean usePrimitiveWrapper() {
        boolean bl = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.primitivetowrapper", "").equalsIgnoreCase("true");
        if (_hasLocalWrapper) {
            return _wrapper;
        }
        return bl;
    }

    public static void setPrimitiveWrapper(boolean bl) {
        _wrapper = bl;
        _hasLocalWrapper = true;
    }

    public static boolean mappingSchemaElement2Java() {
        SourceGenerator.getDefault();
        return _bindingType == 0;
    }

    public static boolean mappingSchemaType2Java() {
        SourceGenerator.getDefault();
        return _bindingType == 1;
    }

    public static String lookupPackageNamespace(String string) {
        if (string == null) {
            return "";
        }
        SourceGenerator.getDefault();
        String string2 = (String)_nspackages.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static String lookupPackageLocation(String string) {
        if (string == null) {
            return "";
        }
        String string2 = (String)_locpackages.get(string);
        if (string2 == null) {
            while (string.startsWith(".")) {
                if (string.startsWith("./")) {
                    string = string.substring(2);
                    continue;
                }
                if (!string.startsWith("../")) continue;
                string = string.substring(3);
            }
            Enumeration enumeration = _locpackages.keys();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.endsWith(string)) continue;
                string2 = (String)_locpackages.get(string3);
                bl = true;
            }
            if (string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    public static String getVersion() {
        return VERSION;
    }

    public void setSAX1(boolean bl) {
        if (this._sourceFactory != null) {
            this._sourceFactory.setSAX1(bl);
        }
    }

    public void setSuppressNonFatalWarnings(boolean bl) {
        this._warnOnOverwrite = !bl;
        this._suppressNonFatalWarnings = bl;
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    public void setDescriptorCreation(boolean bl) {
        this._createDescriptors = bl;
    }

    public void setDestDir(String string) {
        this._destDir = string;
    }

    public void setCreateMarshalMethods(boolean bl) {
        if (this._sourceFactory != null) {
            this._sourceFactory.setCreateMarshalMethods(bl);
        }
    }

    public void setTestable(boolean bl) {
        if (this._sourceFactory != null) {
            this._sourceFactory.setTestable(bl);
        }
    }

    public static void setDefaultProperties(Properties properties) {
        _loaded = false;
        _default = properties;
        SourceGenerator.load();
    }

    public void setBinding(ExtendedBinding extendedBinding) {
        if (extendedBinding != null) {
            this.processNamespaces(extendedBinding.getPackage());
            BindingType bindingType = extendedBinding.getDefaultBindingType();
            if (bindingType != null) {
                if (bindingType.getType() == 0) {
                    _bindingType = 0;
                } else if (bindingType.getType() == 1) {
                    _bindingType = 1;
                }
            }
        }
        this._bindingComponent.setBinding(extendedBinding);
    }

    public void setBinding(String string) {
        try {
            ExtendedBinding extendedBinding = BindingLoader.createBinding(string);
            this.setBinding(extendedBinding);
        }
        catch (BindingException bindingException) {
            String string2 = "unable to load a binding file due to the following:\n";
            string2 = string2 + bindingException.getMessage();
            string2 = string2 + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(string2);
        }
    }

    public void setBinding(InputSource inputSource) {
        try {
            ExtendedBinding extendedBinding = BindingLoader.createBinding(inputSource);
            this.setBinding(extendedBinding);
        }
        catch (BindingException bindingException) {
            String string = "unable to load a binding file due to the following:\n";
            string = string + bindingException.getMessage();
            string = string + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(string);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl;
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        commandLineOptions.addFlag("i", "filename", "Sets the input filename");
        commandLineOptions.addFlag("package", "package-name", "Sets the package name", true);
        String string = "Sets the destination output directory";
        commandLineOptions.addFlag("dest", "dest-dir", string, true);
        string = "Sets the line separator style for the desired platform";
        commandLineOptions.addFlag("line-separator", "( unix | mac | win)", string, true);
        string = "Suppresses non fatal warnings, such as overwriting files.";
        commandLineOptions.addFlag("f", "", string, true);
        string = "Displays this help screen.";
        commandLineOptions.addFlag("h", "", string, true);
        string = "Prints out additional messages when creaing source";
        commandLineOptions.addFlag("verbose", "", string, true);
        string = "Disables the generation of the Class descriptors";
        commandLineOptions.addFlag("nodesc", "", string, true);
        string = "Sets the source generator types name (SGTypeFactory)";
        commandLineOptions.addFlag("types", "types", string, true);
        commandLineOptions.addFlag("type-factory", "classname", "", true);
        string = "Disables the generation of the methods specific to the XML marshalling framework";
        commandLineOptions.addFlag("nomarshall", "", string, true);
        string = "Implements some specific methods to allow the generated classes to be used with Castor Testing Framework";
        commandLineOptions.addFlag("testable", "", string, true);
        string = "Uses SAX 1 in the generated code.";
        commandLineOptions.addFlag("sax1", "", string, true);
        string = "Sets the Source Generator Binding File name";
        commandLineOptions.addFlag("binding-file", "filename", string, true);
        Properties properties = commandLineOptions.getOptions(stringArray);
        if (properties.getProperty("h") != null) {
            PrintWriter printWriter = new PrintWriter(System.out, true);
            commandLineOptions.printHelp(printWriter);
            printWriter.flush();
            return;
        }
        String string2 = properties.getProperty("i");
        String string3 = properties.getProperty("package");
        String string4 = properties.getProperty("line-separator");
        boolean bl2 = properties.getProperty("f") != null;
        String string5 = properties.getProperty("types");
        boolean bl3 = bl = properties.getProperty("verbose") != null;
        if (string2 == null) {
            System.out.println(APP_NAME);
            commandLineOptions.printUsage(new PrintWriter(System.out));
            return;
        }
        if (string5 == null) {
            string5 = properties.getProperty("type-factory");
        }
        String string6 = System.getProperty("line.separator");
        if (string4 != null) {
            if ("win".equals(string4)) {
                System.out.println(" - using Windows style line separation.");
                string6 = "\r\n";
            } else if ("unix".equals(string4)) {
                System.out.println(" - using UNIX style line separation.");
                string6 = "\n";
            } else if ("mac".equals(string4)) {
                System.out.println(" - using Macintosh style line separation.");
                string6 = "\r";
            } else {
                System.out.print("- invalid option for line-separator: ");
                System.out.println(string4);
                System.out.println("-- using default line separator for this platform");
            }
        }
        SourceGenerator sourceGenerator = null;
        if (string5 != null) {
            if (string5.equals("j2")) {
                string5 = "arraylist";
            }
            try {
                object = new FieldInfoFactory(string5);
                sourceGenerator = new SourceGenerator((FieldInfoFactory)object);
            }
            catch (Exception exception) {
                System.out.print("- invalid option for types: ");
                System.out.println(string5);
                System.out.println(exception);
                System.out.println("-- using default source generator types");
                sourceGenerator = new SourceGenerator();
            }
        } else {
            sourceGenerator = new SourceGenerator();
        }
        sourceGenerator.setDestDir(properties.getProperty("dest"));
        sourceGenerator.setLineSeparator(string6);
        sourceGenerator.setSuppressNonFatalWarnings(bl2);
        sourceGenerator.setVerbose(bl);
        if (bl2) {
            System.out.println("-- Suppressing non fatal warnings.");
        }
        if (properties.getProperty("nodesc") != null) {
            sourceGenerator.setDescriptorCreation(false);
            System.out.print("-- ");
            System.out.println(DISABLE_DESCRIPTORS_MSG);
        }
        if (properties.getProperty("nomarshall") != null) {
            sourceGenerator.setCreateMarshalMethods(false);
            System.out.print("-- ");
            System.out.println(DISABLE_MARSHALL_MSG);
        }
        if (properties.getProperty("testable") != null) {
            sourceGenerator.setTestable(true);
            System.out.print("-- ");
            System.out.println(CASTOR_TESTABLE_MSG);
        }
        if (properties.getProperty("sax1") != null) {
            sourceGenerator.setSAX1(true);
            System.out.print("-- ");
            System.out.println(SAX1_MSG);
        }
        if (properties.getProperty("binding-file") != null) {
            object = null;
            try {
                object = BindingLoader.createBinding(properties.getProperty("binding-file"));
            }
            catch (BindingException bindingException) {
                System.out.print("--");
                System.out.println("Unable to load a binding file due to the following Exception:");
                bindingException.printStackTrace();
                System.out.println("-- No binding file will be used");
            }
            sourceGenerator.setBinding((ExtendedBinding)object);
        }
        try {
            sourceGenerator.generateSource(string2, string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("unable to open XML schema file");
            return;
        }
    }

    public void setLineSeparator(String string) {
        this._lineSeparator = string;
    }

    private void createClasses(Schema schema, SGStateInfo sGStateInfo) {
        Object object;
        Enumeration enumeration;
        if (!this._suppressNonFatalWarnings) {
            enumeration = schema.getImportedSchema();
            while (enumeration.hasMoreElements()) {
                object = (Schema)enumeration.nextElement();
                System.out.println();
                System.out.println(IMPORT_WARNING + ((Schema)object).getSchemaLocation());
            }
        }
        enumeration = schema.getElementDecls();
        while (enumeration.hasMoreElements()) {
            this.createClasses((ElementDecl)enumeration.nextElement(), sGStateInfo);
        }
        enumeration = schema.getComplexTypes();
        while (enumeration.hasMoreElements()) {
            this.processComplexType((ComplexType)enumeration.nextElement(), sGStateInfo);
        }
        enumeration = schema.getSimpleTypes();
        while (enumeration.hasMoreElements()) {
            this.processSimpleType((SimpleType)enumeration.nextElement(), sGStateInfo);
        }
        enumeration = schema.getModelGroups();
        while (enumeration.hasMoreElements()) {
            this.createClasses((ModelGroup)enumeration.nextElement(), sGStateInfo);
        }
        object = sGStateInfo.keys();
        while (object.hasMoreElements()) {
            ClassInfo classInfo = sGStateInfo.resolve(object.nextElement());
            JClass jClass = classInfo.getJClass();
            if (sGStateInfo.processed(jClass)) continue;
            this.processJClass(jClass, sGStateInfo);
        }
    }

    private void createClasses(ElementDecl elementDecl, SGStateInfo sGStateInfo) {
        Object object;
        if (elementDecl == null) {
            return;
        }
        XMLType xMLType = elementDecl.getType();
        if (SourceGenerator.mappingSchemaType2Java() && (elementDecl.isReference() || xMLType != null && xMLType.getName() != null)) {
            return;
        }
        this._bindingComponent.setView(elementDecl);
        ClassInfo classInfo = sGStateInfo.resolve(elementDecl);
        if (classInfo != null && classInfo.getJClass() != null) {
            object = classInfo.getJClass();
            if (sGStateInfo.processed((JClass)object)) {
                return;
            }
            object = null;
        }
        if (xMLType == null) {
            if (sGStateInfo.verbose()) {
                object = "No type found for element: ";
                sGStateInfo.getDialog().notify((String)object + elementDecl.getName());
            }
            return;
        }
        if (xMLType.isComplexType()) {
            object = this._sourceFactory.createSourceCode(this._bindingComponent, sGStateInfo);
            int n = 0;
            while (n < ((JClass[])object).length) {
                this.processJClass(object[n], sGStateInfo);
                ++n;
            }
            if (xMLType.getSchema() == this._bindingComponent.getSchema()) {
                this.processComplexType((ComplexType)xMLType, sGStateInfo);
            }
        } else if (xMLType.isSimpleType()) {
            this.processSimpleType((SimpleType)xMLType, sGStateInfo);
        }
    }

    private void createClasses(Group group, SGStateInfo sGStateInfo) {
        if (group == null) {
            return;
        }
        this._bindingComponent.setView(group);
        JClass[] jClassArray = this._sourceFactory.createSourceCode(this._bindingComponent, sGStateInfo);
        this.processContentModel(group, sGStateInfo);
        int n = 0;
        while (n < jClassArray.length) {
            this.processJClass(jClassArray[n], sGStateInfo);
            ++n;
        }
    }

    private void processComplexType(ComplexType complexType, SGStateInfo sGStateInfo) {
        if (complexType == null) {
            return;
        }
        this._bindingComponent.setView(complexType);
        ClassInfo classInfo = sGStateInfo.resolve(complexType);
        if (classInfo == null) {
            Object object;
            if (complexType.isTopLevel()) {
                object = this._sourceFactory.createSourceCode(this._bindingComponent, sGStateInfo);
                int n = 0;
                while (n < ((Object)object).length) {
                    this.processJClass((JClass)object[n], sGStateInfo);
                    ++n;
                }
            }
            this.processAttributes(complexType, sGStateInfo);
            object = complexType.getContentType();
            if (((ContentType)object).getType() == 4) {
                this.processSimpleType(((ContentType)object).getSimpleType(), sGStateInfo);
            }
            this.processContentModel(complexType, sGStateInfo);
        } else {
            JClass jClass = classInfo.getJClass();
            if (!sGStateInfo.processed(jClass)) {
                this.processAttributes(complexType, sGStateInfo);
                this.processContentModel(complexType, sGStateInfo);
                this.processJClass(jClass, sGStateInfo);
            }
        }
    }

    private void processAttributes(ComplexType complexType, SGStateInfo sGStateInfo) {
        if (complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            AttributeDecl attributeDecl = (AttributeDecl)enumeration.nextElement();
            this.processSimpleType(attributeDecl.getSimpleType(), sGStateInfo);
        }
    }

    private void processContentModel(ContentModelGroup contentModelGroup, SGStateInfo sGStateInfo) {
        if (contentModelGroup == null) {
            return;
        }
        Enumeration enumeration = contentModelGroup.enumerate();
        block4: while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 8: {
                    ElementDecl elementDecl = (ElementDecl)structure;
                    if (elementDecl.isReference()) continue block4;
                    this.createClasses(elementDecl, sGStateInfo);
                    break;
                }
                case 10: {
                    this.processContentModel((Group)structure, sGStateInfo);
                    if (contentModelGroup instanceof ComplexType || contentModelGroup instanceof ModelGroup) continue block4;
                    this.createClasses((Group)structure, sGStateInfo);
                    break;
                }
            }
        }
    }

    private void processSimpleType(SimpleType simpleType, SGStateInfo sGStateInfo) {
        if (simpleType == null) {
            return;
        }
        if (simpleType.getSchema() != sGStateInfo.getSchema()) {
            return;
        }
        String string = sGStateInfo.packageName;
        if (simpleType.hasFacet("enumeration")) {
            ClassInfo classInfo = sGStateInfo.resolve(simpleType);
            if (classInfo == null) {
                JClass jClass = this._sourceFactory.createSourceCode(simpleType, sGStateInfo);
                this.processJClass(jClass, sGStateInfo);
            } else {
                JClass jClass = classInfo.getJClass();
                this.processJClass(jClass, sGStateInfo);
            }
        }
    }

    private void processNamespaces(PackageType[] packageTypeArray) {
        if (packageTypeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < packageTypeArray.length) {
            PackageType packageType = packageTypeArray[n];
            PackageTypeChoice packageTypeChoice = packageType.getPackageTypeChoice();
            if (packageTypeChoice.getNamespace() != null) {
                _nspackages.put(packageTypeChoice.getNamespace(), packageType.getName());
            } else if (packageTypeChoice.getSchemaLocation() != null) {
                _locpackages.put(packageTypeChoice.getSchemaLocation(), packageType.getName());
            }
            ++n;
        }
    }

    private void processJClass(JClass jClass, SGStateInfo sGStateInfo) {
        String string;
        Object object;
        Object object2;
        if (sGStateInfo.processed(jClass)) {
            return;
        }
        boolean bl = true;
        if (sGStateInfo.promptForOverwrite() && ((File)(object2 = new File((String)(object = jClass.getFilename(this._destDir))))).exists()) {
            string = (String)object + " already exists. overwrite";
            char c = this._dialog.confirm(string, "yna", "y = yes, n = no, a = all");
            if (c == 'a') {
                sGStateInfo.setPromptForOverwrite(false);
                bl = true;
            } else {
                bl = c == 'y';
            }
        }
        if (bl) {
            jClass.removeImport("org.exolab.castor.types.Date");
            jClass.setHeader(this._header);
            jClass.print(this._destDir, this._lineSeparator);
        }
        object = sGStateInfo.resolve(jClass);
        if (this._createDescriptors && object != null) {
            File file;
            object2 = DescriptorSourceFactory.createSource((ClassInfo)object);
            bl = true;
            if (sGStateInfo.promptForOverwrite() && (file = new File(string = ((JStructure)object2).getFilename(this._destDir))).exists()) {
                String string2 = string + " already exists. overwrite";
                char c = this._dialog.confirm(string2, "yna", "y = yes, n = no, a = all");
                if (c == 'a') {
                    sGStateInfo.setPromptForOverwrite(false);
                    bl = true;
                } else {
                    bl = c == 'y';
                }
            }
            if (bl) {
                ((JStructure)object2).setHeader(this._header);
                ((JStructure)object2).print(this._destDir, this._lineSeparator);
            }
        }
        sGStateInfo.markAsProcessed(jClass);
    }

    public static boolean generateExtraCollectionMethods() {
        if (_default != null) {
            boolean bl;
            _generateExtraCollectionMethods = bl = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.extraCollectionMethods", "").equalsIgnoreCase("true");
        }
        return _generateExtraCollectionMethods;
    }

    protected static synchronized void load() {
        Object object;
        if (_default == null) {
            _default = Configuration.loadProperties("/org/exolab/castor/builder/castorbuilder.properties", "castorbuilder.properties");
            try {
                object = (class$org$exolab$castor$builder$SourceGenerator == null ? (class$org$exolab$castor$builder$SourceGenerator = SourceGenerator.class$("org.exolab.castor.builder.SourceGenerator")) : class$org$exolab$castor$builder$SourceGenerator).getResourceAsStream("/castorbuilder.properties");
                if (object != null) {
                    _default.load((InputStream)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = LocalConfiguration.getInstance();
        SourceGenerator.processNamespacePackageMappings(((Configuration)object).getProperty("org.exolab.castor.builder.nspackages", ""));
        SourceGenerator.processNamespacePackageMappings(((Configuration)object).getProperty("org.exolab.castor.xml.nspackages", ""));
        SourceGenerator.processNamespacePackageMappings(_default.getProperty("org.exolab.castor.builder.nspackages", ""));
        SourceGenerator.processNamespacePackageMappings(_default.getProperty("org.exolab.castor.xml.nspackages", ""));
        String string = _default.getProperty("org.exolab.castor.builder.boundproperties", "");
        _boundProperties = string.equalsIgnoreCase("true");
        string = _default.getProperty("org.exolab.castor.builder.equalsmethod", "");
        if (!_hasLocalEquals) {
            _equalsMethod = string.equalsIgnoreCase("true");
        }
        string = _default.getProperty("org.exolab.castor.builder.extraCollectionMethods", "");
        _generateExtraCollectionMethods = string.equalsIgnoreCase("true");
        string = _default.getProperty("org.exolab.castor.builder.primitivetowrapper", "");
        if (!_hasLocalWrapper) {
            // empty if block
        }
        string = _default.getProperty("org.exolab.castor.builder.classdescfieldnames", "");
        if (!_hasLocalClassField) {
            // empty if block
        }
        if ((string = _default.getProperty("org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore", null)) != null) {
            JavaNaming.upperCaseAfterUnderscore = Boolean.valueOf(string);
        }
        SourceGenerator.initBindingType();
        _loaded = true;
    }

    protected static void processNamespacePackageMappings(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            _nspackages.put(string3, string4);
        }
    }

    protected static void initBindingType() {
        String string = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.javaclassmapping", ELEMENT_VALUE);
        if (string.toLowerCase().equals(TYPE_VALUE)) {
            _bindingType = 1;
        }
    }

    public static String toURIRepresentation(String string) {
        String string2 = string;
        if (!new File(string2).isAbsolute()) {
            throw new IllegalArgumentException("The parameter must represent an absolute path.");
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        string2 = string2.startsWith("/") ? "file://" + string2 : "file:///" + string2;
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _loaded = false;
        _nspackages = null;
        _nspackages = new Hashtable();
        _locpackages = null;
        _locpackages = new Hashtable();
    }

    public static class Property {
        public static final String BOUND_PROPERTIES = "org.exolab.castor.builder.boundproperties";
        public static final String EXTRA_COLLECTION_METHODS = "org.exolab.castor.builder.extraCollectionMethods";
        public static final String SUPER_CLASS = "org.exolab.castor.builder.superclass";
        public static final String JavaClassMapping = "org.exolab.castor.builder.javaclassmapping";
        public static final String NamespacePackagesOld = "org.exolab.castor.builder.nspackages";
        public static final String NamespacePackages = "org.exolab.castor.xml.nspackages";
        public static final String EqualsMethod = "org.exolab.castor.builder.equalsmethod";
        public static final String Wrapper = "org.exolab.castor.builder.primitivetowrapper";
        public static final String ClassDescFieldNames = "org.exolab.castor.builder.classdescfieldnames";
        public static final String FileName = "castorbuilder.properties";
        static final String ResourceName = "/org/exolab/castor/builder/castorbuilder.properties";
    }
}

