/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSAnyURI;
import org.exolab.castor.builder.types.XSBinary;
import org.exolab.castor.builder.types.XSBoolean;
import org.exolab.castor.builder.types.XSByte;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSDate;
import org.exolab.castor.builder.types.XSDateTime;
import org.exolab.castor.builder.types.XSDecimal;
import org.exolab.castor.builder.types.XSDouble;
import org.exolab.castor.builder.types.XSDuration;
import org.exolab.castor.builder.types.XSFloat;
import org.exolab.castor.builder.types.XSGDay;
import org.exolab.castor.builder.types.XSGMonth;
import org.exolab.castor.builder.types.XSGMonthDay;
import org.exolab.castor.builder.types.XSGYear;
import org.exolab.castor.builder.types.XSGYearMonth;
import org.exolab.castor.builder.types.XSId;
import org.exolab.castor.builder.types.XSIdRef;
import org.exolab.castor.builder.types.XSInt;
import org.exolab.castor.builder.types.XSInteger;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSLong;
import org.exolab.castor.builder.types.XSNCName;
import org.exolab.castor.builder.types.XSNMToken;
import org.exolab.castor.builder.types.XSNegativeInteger;
import org.exolab.castor.builder.types.XSNonNegativeInteger;
import org.exolab.castor.builder.types.XSNonPositiveInteger;
import org.exolab.castor.builder.types.XSNormalizedString;
import org.exolab.castor.builder.types.XSPositiveInteger;
import org.exolab.castor.builder.types.XSQName;
import org.exolab.castor.builder.types.XSShort;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSTime;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Union;
import org.exolab.javasource.JClass;

public class TypeConversion {
    private static final String TYPES_PACKAGE = "types";

    public static XSType convertType(SimpleType simpleType) {
        return TypeConversion.convertType(simpleType, SourceGenerator.usePrimitiveWrapper(), null);
    }

    public static XSType convertType(SimpleType simpleType, String string) {
        return TypeConversion.convertType(simpleType, SourceGenerator.usePrimitiveWrapper(), string);
    }

    public static XSType convertType(SimpleType simpleType, boolean bl, String string) {
        if (simpleType == null) {
            return null;
        }
        XSType xSType = null;
        SimpleType simpleType2 = simpleType;
        while (simpleType2 != null && !simpleType2.isBuiltInType()) {
            simpleType2 = (SimpleType)simpleType2.getBaseType();
        }
        if (simpleType.getStructureType() == 22) {
            SimpleType simpleType3 = TypeConversion.findCommonType((Union)simpleType);
            if (simpleType3 == null) {
                return new XSClass(SGTypes.Object);
            }
            return TypeConversion.convertType(simpleType3, bl, string);
        }
        if (simpleType2 == null) {
            String string2 = JavaNaming.toJavaClassName(simpleType.getName());
            xSType = new XSClass(new JClass(string2));
        } else {
            switch (simpleType2.getTypeCode()) {
                case 25: {
                    return new XSId();
                }
                case 26: {
                    return new XSIdRef();
                }
                case 27: {
                    return new XSList(new XSIdRef());
                }
                case 30: {
                    return new XSNMToken();
                }
                case 31: {
                    return new XSList(new XSNMToken());
                }
                case 17: {
                    return new XSAnyURI();
                }
                case 12: {
                    return new XSBinary(12);
                }
                case 13: {
                    return new XSBinary(13);
                }
                case 11: {
                    return new XSBoolean(bl);
                }
                case 38: {
                    XSByte xSByte = new XSByte();
                    if (!simpleType.isBuiltInType()) {
                        xSByte.setFacets(simpleType);
                    }
                    return xSByte;
                }
                case 5: {
                    XSDate xSDate = new XSDate();
                    if (!simpleType.isBuiltInType()) {
                        xSDate.setFacets(simpleType);
                    }
                    return xSDate;
                }
                case 3: {
                    return new XSDateTime();
                }
                case 15: {
                    XSDouble xSDouble = new XSDouble(bl);
                    if (!simpleType.isBuiltInType()) {
                        xSDouble.setFacets(simpleType);
                    }
                    return xSDouble;
                }
                case 2: {
                    XSDuration xSDuration = new XSDuration();
                    if (!simpleType.isBuiltInType()) {
                        xSDuration.setFacets(simpleType);
                    }
                    return xSDuration;
                }
                case 16: {
                    XSDecimal xSDecimal = new XSDecimal();
                    if (!simpleType.isBuiltInType()) {
                        xSDecimal.setFacets(simpleType);
                    }
                    return xSDecimal;
                }
                case 14: {
                    XSFloat xSFloat = new XSFloat(bl);
                    if (!simpleType.isBuiltInType()) {
                        xSFloat.setFacets(simpleType);
                    }
                    return xSFloat;
                }
                case 9: {
                    XSGDay xSGDay = new XSGDay();
                    if (!simpleType.isBuiltInType()) {
                        xSGDay.setFacets(simpleType);
                    }
                    return xSGDay;
                }
                case 8: {
                    XSGMonthDay xSGMonthDay = new XSGMonthDay();
                    if (!simpleType.isBuiltInType()) {
                        xSGMonthDay.setFacets(simpleType);
                    }
                    return xSGMonthDay;
                }
                case 10: {
                    XSGMonth xSGMonth = new XSGMonth();
                    if (!simpleType.isBuiltInType()) {
                        xSGMonth.setFacets(simpleType);
                    }
                    return xSGMonth;
                }
                case 6: {
                    XSGYearMonth xSGYearMonth = new XSGYearMonth();
                    if (!simpleType.isBuiltInType()) {
                        xSGYearMonth.setFacets(simpleType);
                    }
                    return xSGYearMonth;
                }
                case 7: {
                    XSGYear xSGYear = new XSGYear();
                    if (!simpleType.isBuiltInType()) {
                        xSGYear.setFacets(simpleType);
                    }
                    return xSGYear;
                }
                case 32: {
                    XSInteger xSInteger = new XSInteger(bl);
                    if (!simpleType.isBuiltInType()) {
                        xSInteger.setFacets(simpleType);
                    }
                    return xSInteger;
                }
                case 36: {
                    XSInt xSInt = new XSInt(bl);
                    if (!simpleType.isBuiltInType()) {
                        xSInt.setFacets(simpleType);
                    }
                    return xSInt;
                }
                case 22: {
                    String string3 = "Warning: The W3C datatype '" + simpleType.getName();
                    string3 = string3 + "' is not currently supported by Castor Source Generator.";
                    string3 = string3 + " It will be treated as a java.lang.String.";
                    System.out.println(string3);
                    return new XSString();
                }
                case 35: {
                    XSLong xSLong = new XSLong(bl);
                    if (!simpleType.isBuiltInType()) {
                        xSLong.setFacets(simpleType);
                    }
                    return xSLong;
                }
                case 24: {
                    return new XSNCName();
                }
                case 33: {
                    XSNonPositiveInteger xSNonPositiveInteger = new XSNonPositiveInteger();
                    xSNonPositiveInteger.setFacets(simpleType);
                    return xSNonPositiveInteger;
                }
                case 39: {
                    XSNonNegativeInteger xSNonNegativeInteger = new XSNonNegativeInteger();
                    xSNonNegativeInteger.setFacets(simpleType);
                    return xSNonNegativeInteger;
                }
                case 34: {
                    XSNegativeInteger xSNegativeInteger = new XSNegativeInteger();
                    xSNegativeInteger.setFacets(simpleType);
                    return xSNegativeInteger;
                }
                case 20: {
                    XSNormalizedString xSNormalizedString = new XSNormalizedString();
                    if (!simpleType.isBuiltInType()) {
                        xSNormalizedString.setFacets(simpleType);
                    }
                    return xSNormalizedString;
                }
                case 44: {
                    XSPositiveInteger xSPositiveInteger = new XSPositiveInteger();
                    xSPositiveInteger.setFacets(simpleType);
                    return xSPositiveInteger;
                }
                case 18: {
                    XSQName xSQName = new XSQName();
                    xSQName.setFacets(simpleType);
                    return xSQName;
                }
                case 1: {
                    if (simpleType.hasFacet("enumeration")) {
                        Object object;
                        String string4 = simpleType.getName();
                        if (string4 == null) {
                            object = simpleType.getParent();
                            if (object instanceof ElementDecl) {
                                string4 = ((ElementDecl)object).getName();
                            } else if (object instanceof AttributeDecl) {
                                string4 = ((AttributeDecl)object).getName();
                            }
                            string4 = string4 + "Type";
                        }
                        object = JavaNaming.toJavaClassName(string4);
                        if (string == null) {
                            String string5 = simpleType.getSchema().getTargetNamespace();
                            string = SourceGenerator.lookupPackageNamespace(string5);
                        }
                        string = string != null && string.length() > 0 ? string + '.' + TYPES_PACKAGE : TYPES_PACKAGE;
                        object = string + '.' + (String)object;
                        xSType = new XSClass(new JClass((String)object));
                        xSType.setAsEnumertated(true);
                        break;
                    }
                    XSString xSString = new XSString();
                    if (!simpleType.isBuiltInType()) {
                        xSString.setFacets(simpleType);
                    }
                    xSType = xSString;
                    break;
                }
                case 37: {
                    XSShort xSShort = new XSShort(bl);
                    if (!simpleType.isBuiltInType()) {
                        xSShort.setFacets(simpleType);
                    }
                    return xSShort;
                }
                case 4: {
                    XSTime xSTime = new XSTime();
                    if (!simpleType.isBuiltInType()) {
                        xSTime.setFacets(simpleType);
                    }
                    return xSTime;
                }
                default: {
                    String string6 = simpleType.getName();
                    if (string6 == null || string6.length() == 0) {
                        string6 = simpleType.getBuiltInBaseType().getName();
                    }
                    String string7 = "Warning: The W3C datatype '" + string6;
                    string7 = string7 + "' is not currently supported by Castor Source Generator.";
                    System.out.println(string7);
                    String string8 = JavaNaming.toJavaClassName(string6);
                    xSType = new XSClass(new JClass(string8));
                }
            }
        }
        return xSType;
    }

    public static XSType convertType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("java.lang.Boolean")) {
            return new XSBoolean(true);
        }
        if (string.equals("boolean")) {
            return new XSBoolean(false);
        }
        if (string.equals("java.lang.Byte")) {
            return new XSByte(true);
        }
        if (string.equals("byte")) {
            return new XSBoolean(false);
        }
        if (string.equals("org.exolab.castor.types.Date")) {
            return new XSDateTime();
        }
        if (string.equals("org.exolab.castor.types.Guration")) {
            return new XSDuration();
        }
        if (string.equals("org.exolab.castor.types.GDay")) {
            return new XSGDay();
        }
        if (string.equals("org.exolab.castor.types.GMonth")) {
            return new XSGMonth();
        }
        if (string.equals("org.exolab.castor.types.GMonthDay")) {
            return new XSGMonthDay();
        }
        if (string.equals("org.exolab.castor.types.GYear")) {
            return new XSGYear();
        }
        if (string.equals("org.exolab.castor.types.GYearMonth")) {
            return new XSGYearMonth();
        }
        if (string.equals("org.exolab.castor.types.Time")) {
            return new XSTime();
        }
        if (string.equals("java.util.Date")) {
            return new XSDate();
        }
        if (string.equals("java.math.BigDecimal")) {
            return new XSDecimal();
        }
        if (string.equals("java.lang.Double")) {
            return new XSDouble(true);
        }
        if (string.equals("double")) {
            return new XSDouble(false);
        }
        if (string.equals("java.lang.Float")) {
            return new XSFloat(true);
        }
        if (string.equals("float")) {
            return new XSDouble(false);
        }
        if (string.equals("java.lang.Integer")) {
            return new XSInteger();
        }
        if (string.equals("int")) {
            return new XSInt();
        }
        if (string.equals("java.lang.Short")) {
            return new XSShort(true);
        }
        if (string.equals("short")) {
            return new XSShort(false);
        }
        if (string.equals("java.lang.String")) {
            return new XSString();
        }
        return new XSClass(new JClass(string));
    }

    private static SimpleType findCommonType(Union union) {
        SimpleType simpleType = null;
        Enumeration enumeration = union.getMemberTypes();
        while (enumeration.hasMoreElements()) {
            SimpleType simpleType2 = (SimpleType)enumeration.nextElement();
            simpleType2 = simpleType2.getBuiltInBaseType();
            if (simpleType == null) {
                simpleType = simpleType2;
                continue;
            }
            if ((simpleType = TypeConversion.compare(simpleType, simpleType2)) == null) break;
        }
        return simpleType;
    }

    private static SimpleType compare(SimpleType simpleType, SimpleType simpleType2) {
        int n;
        int n2 = simpleType.getTypeCode();
        if (n2 == (n = simpleType2.getTypeCode())) {
            return simpleType;
        }
        if (TypeConversion.isNumeric(simpleType) ? TypeConversion.isNumeric(simpleType2) : !TypeConversion.isString(simpleType) || TypeConversion.isString(simpleType2)) {
            // empty if block
        }
        Schema schema = simpleType.getSchema();
        return schema.getSimpleType("string", schema.getSchemaNamespace());
    }

    private static boolean isNumeric(SimpleType simpleType) {
        int n = simpleType.getTypeCode();
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    private static boolean isString(SimpleType simpleType) {
        int n = simpleType.getTypeCode();
        switch (n) {
            case 1: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDateOrTime(SimpleType simpleType) {
        int n = simpleType.getTypeCode();
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    class TypeNames {
        protected static final String BOOLEAN_PRIMITIVE = "boolean";
        protected static final String BOOLEAN_OBJECT = "java.lang.Boolean";
        protected static final String BYTE_PRIMITIVE = "byte";
        protected static final String BYTE_OBJECT = "java.lang.Byte";
        protected static final String DATE = "java.util.Date";
        protected static final String CASTOR_DATE = "org.exolab.castor.types.Date";
        protected static final String CASTOR_TIME = "org.exolab.castor.types.Time";
        protected static final String CASTOR_DURATION = "org.exolab.castor.types.Guration";
        protected static final String CASTOR_GMONTH = "org.exolab.castor.types.GMonth";
        protected static final String CASTOR_GMONTHDAY = "org.exolab.castor.types.GMonthDay";
        protected static final String CASTOR_GYEAR = "org.exolab.castor.types.GYear";
        protected static final String CASTOR_GYEARMONTH = "org.exolab.castor.types.GYearMonth";
        protected static final String CASTOR_GDAY = "org.exolab.castor.types.GDay";
        protected static final String DECIMAL = "java.math.BigDecimal";
        protected static final String DOUBLE_PRIMITIVE = "double";
        protected static final String DOUBLE_OBJECT = "java.lang.Double";
        protected static final String FLOAT_PRIMITIVE = "float";
        protected static final String FLOAT_OBJECT = "java.lang.Float";
        protected static final String INT = "int";
        protected static final String INTEGER = "java.lang.Integer";
        protected static final String SHORT_PRIMITIVE = "short";
        protected static final String SHORT_OBJECT = "java.lang.Short";
        protected static final String STRING = "java.lang.String";

        TypeNames() {
        }
    }
}

