/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.exolab.castor.builder.binding.Binding;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.ComponentBindingType;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.IncludeType;
import org.exolab.castor.builder.binding.NamingXMLType;
import org.exolab.castor.builder.binding.PackageType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BindingLoader {
    private ExtendedBinding _binding;
    private BindingResolver _resolver;
    static /* synthetic */ Class class$org$exolab$castor$builder$binding$Binding;

    public void loadBinding(String string) throws BindingException {
        try {
            InputSource inputSource = this._resolver.resolveEntity(null, string);
            if (inputSource == null) {
                inputSource = new InputSource(string);
            }
            if (inputSource.getSystemId() == null) {
                inputSource.setSystemId(string);
            }
            this.loadBinding(inputSource);
        }
        catch (SAXException sAXException) {
            throw new BindingException(sAXException);
        }
        catch (IOException iOException) {
            throw new BindingException(iOException);
        }
    }

    public void loadBinding(InputSource inputSource) throws BindingException {
        Binding binding = null;
        if (this._binding == null) {
            this._binding = new ExtendedBinding();
        }
        Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$builder$binding$Binding == null ? (class$org$exolab$castor$builder$binding$Binding = BindingLoader.class$("org.exolab.castor.builder.binding.Binding")) : class$org$exolab$castor$builder$binding$Binding);
        unmarshaller.setValidation(true);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            binding = (Binding)unmarshaller.unmarshal(inputSource);
            this._binding.setDefaultBindingType(binding.getDefaultBindingType());
            Enumeration enumeration = binding.enumeratePackage();
            while (enumeration.hasMoreElements()) {
                serializable = (PackageType)enumeration.nextElement();
                this._binding.addPackage((PackageType)serializable);
            }
            serializable = binding.getNamingXML();
            if (serializable != null) {
                this._binding.setNamingXML((NamingXMLType)serializable);
            }
            Enumeration enumeration2 = binding.enumerateElementBinding();
            while (enumeration2.hasMoreElements()) {
                object4 = (ComponentBindingType)enumeration2.nextElement();
                this._binding.addElementBinding((ComponentBindingType)object4);
            }
            object4 = binding.enumerateAttributeBinding();
            while (object4.hasMoreElements()) {
                object3 = (ComponentBindingType)object4.nextElement();
                this._binding.addAttributeBinding((ComponentBindingType)object3);
            }
            object3 = binding.enumerateComplexTypeBinding();
            while (object3.hasMoreElements()) {
                object2 = (ComponentBindingType)object3.nextElement();
                this._binding.addComplexTypeBinding((ComponentBindingType)object2);
            }
            object2 = binding.enumerateGroupBinding();
            while (object2.hasMoreElements()) {
                object = (ComponentBindingType)object2.nextElement();
                this._binding.addGroupBinding((ComponentBindingType)object);
            }
            object = this._binding.enumerateInclude();
            while (object.hasMoreElements()) {
                IncludeType includeType = (IncludeType)object.nextElement();
                try {
                    this.loadBinding(includeType.getURI());
                }
                catch (Exception exception) {
                    throw new BindingException(exception);
                }
            }
        }
        catch (MarshalException marshalException) {
            throw new BindingException(marshalException);
        }
        catch (ValidationException validationException) {
            throw new BindingException(validationException);
        }
    }

    public ExtendedBinding getBinding() {
        return this._binding;
    }

    public void setBaseURL(String string) {
        try {
            this._resolver.setBaseURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
    }

    public static ExtendedBinding createBinding(InputSource inputSource) throws BindingException {
        BindingLoader bindingLoader = new BindingLoader();
        bindingLoader.loadBinding(inputSource);
        return bindingLoader.getBinding();
    }

    public static ExtendedBinding createBinding(String string) throws BindingException {
        BindingLoader bindingLoader = new BindingLoader();
        InputSource inputSource = new InputSource(string);
        bindingLoader.loadBinding(inputSource);
        return bindingLoader.getBinding();
    }

    private void validate() throws BindingException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BindingResolver
    implements EntityResolver {
        private static final String BINDING_PUBLICID = "-//EXOLAB/Castor Binding Schema Version 1.0//EN";
        private static final String BINDING_SYSTEMID = "http://exolab.castor.org/binding.xsd";
        private static final String BINDING_RESOURCE = "/org/exolab/castor/builder/binding/binding.xsd";
        private URL _baseUrl;

        BindingResolver() {
        }

        public void setBaseURL(URL uRL) {
            this._baseUrl = uRL;
        }

        public URL getBaseURL() {
            return this._baseUrl;
        }

        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            InputSource inputSource = null;
            if (string != null && string.equals(BINDING_PUBLICID)) {
                inputSource = new InputSource(this.getClass().getResourceAsStream(BINDING_RESOURCE));
                inputSource.setPublicId(string);
                return inputSource;
            }
            if (string2 != null && string2.equals(BINDING_SYSTEMID)) {
                inputSource = new InputSource(this.getClass().getResourceAsStream(BINDING_RESOURCE));
                inputSource.setSystemId(string2);
                return inputSource;
            }
            if (string2 != null && this._baseUrl != null) {
                try {
                    URL uRL = new URL(string2);
                    inputSource = new InputSource(uRL.openStream());
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        URL uRL = new URL(this._baseUrl, string2);
                        inputSource = new InputSource(uRL.openStream());
                        inputSource.setSystemId(string2);
                        return inputSource;
                    }
                    catch (MalformedURLException malformedURLException2) {
                        throw new SAXException(malformedURLException2);
                    }
                }
            }
            return null;
        }
    }
}

