/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.SearchDescriptor;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public abstract class Producer {
    protected DocumentHandler _docHandler;
    private boolean _namespace;
    private boolean _insideDirectory;
    private boolean _insideSchema;

    public Producer(DocumentHandler documentHandler, boolean bl) {
        this._docHandler = documentHandler;
        this._namespace = bl;
    }

    public void startDocument() throws SAXException {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        if (this._namespace) {
            attributeListImpl.addAttribute("xmlns:dsml", "CDATA", "http://www.dsml.org/DSML");
        } else {
            attributeListImpl.addAttribute("xmlns", "CDATA", "http://www.dsml.org/DSML");
        }
        this._docHandler.startElement(this.prefix("dsml"), attributeListImpl);
    }

    public void endDocument() throws SAXException {
        this.leaveDirectory();
        this.leaveSchema();
        this._docHandler.endElement(this.prefix("dsml"));
    }

    public void produce(ImportDescriptor importDescriptor) throws SAXException {
        this.leaveDirectory();
        this.leaveSchema();
        importDescriptor.produce(this._docHandler);
    }

    public void produce(SearchDescriptor searchDescriptor) throws SAXException {
        this.leaveDirectory();
        this.leaveSchema();
        searchDescriptor.produce(this._docHandler);
    }

    protected void enterDirectory() throws SAXException {
        if (!this._insideDirectory) {
            this._insideDirectory = true;
            this._docHandler.startElement(this.prefix("directory-entries"), new AttributeListImpl());
        }
    }

    protected void leaveDirectory() throws SAXException {
        if (this._insideDirectory) {
            this._insideDirectory = false;
            this._docHandler.endElement(this.prefix("directory-entries"));
        }
    }

    protected void enterSchema() throws SAXException {
        if (!this._insideSchema) {
            this._insideSchema = true;
            this._docHandler.startElement(this.prefix("directory-schema"), new AttributeListImpl());
        }
    }

    protected void leaveSchema() throws SAXException {
        if (this._insideSchema) {
            this._insideSchema = false;
            this._docHandler.endElement(this.prefix("directory-schema"));
        }
    }

    protected String prefix(String string) {
        if (this._namespace) {
            return "dsml:" + string;
        }
        return string;
    }
}

