/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public class JDBCQueryExpression
implements QueryExpression {
    protected Hashtable _tables = new Hashtable();
    protected Vector _cols = new Vector();
    protected Vector _conds = new Vector();
    protected Vector _joins = new Vector();
    protected String _select;
    protected String _where;
    protected String _order;
    protected String _limit;
    protected boolean _distinct = false;
    protected PersistenceFactory _factory;
    static /* synthetic */ Class class$org$exolab$castor$persist$spi$PersistenceFactory;

    public JDBCQueryExpression(PersistenceFactory persistenceFactory) {
        this._factory = persistenceFactory;
    }

    public void setDistinct(boolean bl) {
        this._distinct = bl;
    }

    public void addColumn(String string, String string2) {
        this._tables.put(string, string);
        this._cols.addElement(this._factory.quoteName(string + "." + string2));
    }

    public void addTable(String string) {
        this._tables.put(string, string);
    }

    public void addTable(String string, String string2) {
        this._tables.put(string2, string);
    }

    public void addParameter(String string, String string2, String string3) {
        this.addCondition(string, string2, string3, "?");
    }

    public void addCondition(String string, String string2, String string3, String string4) {
        this._tables.put(string, string);
        this._conds.addElement(this._factory.quoteName(string + "." + string2) + string3 + string4);
    }

    public String encodeColumn(String string, String string2) {
        return this._factory.quoteName(string + "." + string2);
    }

    public void addInnerJoin(String string, String string2, String string3, String string4) {
        this.addInnerJoin(string, string2, string, string3, string4, string3);
    }

    public void addInnerJoin(String string, String string2, String string3, String string4, String string5, String string6) {
        this._tables.put(string3, string);
        this._tables.put(string6, string4);
        Join join = new Join(string3, string2, string6, string5, false);
        int n = this._joins.indexOf(join);
        if (n < 0) {
            this._joins.add(join);
        } else {
            this._joins.set(n, join);
        }
    }

    public void addInnerJoin(String string, String[] stringArray, String string2, String[] stringArray2) {
        this.addInnerJoin(string, stringArray, string, string2, stringArray2, string2);
    }

    public void addInnerJoin(String string, String[] stringArray, String string2, String string3, String[] stringArray2, String string4) {
        this._tables.put(string2, string);
        this._tables.put(string4, string3);
        Join join = new Join(string2, stringArray, string4, stringArray2, false);
        int n = this._joins.indexOf(join);
        if (n < 0) {
            this._joins.add(join);
        } else {
            this._joins.set(n, join);
        }
    }

    public void addOuterJoin(String string, String string2, String string3, String string4) {
        this.addOuterJoin(string, string2, string3, string4, string3);
    }

    public void addOuterJoin(String string, String string2, String string3, String string4, String string5) {
        this._tables.put(string, string);
        this._tables.put(string5, string3);
        Join join = new Join(string, string2, string5, string4, true);
        int n = this._joins.indexOf(join);
        if (n < 0) {
            this._joins.add(join);
        }
    }

    public void addOuterJoin(String string, String[] stringArray, String string2, String[] stringArray2) {
        this.addOuterJoin(string, stringArray, string2, stringArray2, string2);
    }

    public void addOuterJoin(String string, String[] stringArray, String string2, String[] stringArray2, String string3) {
        this._tables.put(string, string);
        this._tables.put(string3, string2);
        Join join = new Join(string, stringArray, string3, stringArray2, true);
        int n = this._joins.indexOf(join);
        if (n < 0) {
            this._joins.add(join);
        }
    }

    public void addSelect(String string) {
        this._select = string;
    }

    public void addWhereClause(String string) {
        this._where = string;
    }

    public void addOrderClause(String string) {
        this._order = string;
    }

    public void addLimitClause(String string) {
        this._limit = string;
    }

    protected String getColumnList() {
        if (this._cols.size() == 0 && this._select == null) {
            return "1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = 0;
        while (n < this._cols.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)this._cols.elementAt(n));
            ++n;
        }
        if (this._select != null) {
            if (n > 0) {
                stringBuffer.append(",").append(this._select);
            } else {
                stringBuffer.append(this._select);
            }
        }
        return stringBuffer.toString();
    }

    protected boolean addWhereClause(StringBuffer stringBuffer, boolean bl) {
        if (this._conds.size() > 0) {
            if (bl) {
                stringBuffer.append(" WHERE ");
                bl = false;
            } else {
                stringBuffer.append(" AND ");
            }
            int n = 0;
            while (n < this._conds.size()) {
                if (n > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append((String)this._conds.elementAt(n));
                ++n;
            }
        }
        if (this._where != null) {
            if (bl) {
                stringBuffer.append(" WHERE ");
                bl = false;
            } else {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append('(');
            stringBuffer.append(this._where);
            stringBuffer.append(')');
        }
        return bl;
    }

    public String getStatement(boolean bl) {
        return this.getStandardStatement(bl, true).toString();
    }

    protected StringBuffer getStandardStatement(boolean bl, boolean bl2) {
        int n;
        String string;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        if (this._distinct) {
            stringBuffer.append(" DISTINCT ");
        }
        if (this._select == null) {
            stringBuffer.append(this.getColumnList());
        } else {
            stringBuffer.append(this._select).append(" ");
        }
        stringBuffer.append(" FROM ");
        Hashtable hashtable = (Hashtable)this._tables.clone();
        boolean bl3 = true;
        int n2 = 0;
        while (n2 < this._joins.size()) {
            Join join = (Join)this._joins.elementAt(n2);
            if (join.outer && !vector.contains(join.leftTable)) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuffer.append(",");
                }
                if (bl2) {
                    stringBuffer.append("{oj ");
                }
                stringBuffer.append(this._factory.quoteName(join.leftTable));
                stringBuffer.append(" LEFT OUTER JOIN ");
                string = (String)hashtable.get(join.rightTable);
                if (join.rightTable.equals(string)) {
                    stringBuffer.append(this._factory.quoteName(string));
                } else {
                    stringBuffer.append(this._factory.quoteName(string) + " " + this._factory.quoteName(join.rightTable));
                }
                stringBuffer.append(" ON ");
                int n3 = 0;
                while (n3 < join.leftColumns.length) {
                    if (n3 > 0) {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[n3])).append("=");
                    stringBuffer.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[n3]));
                    ++n3;
                }
                hashtable.remove(join.leftTable);
                hashtable.remove(join.rightTable);
                n = n2 + 1;
                while (n < this._joins.size()) {
                    Join join2 = (Join)this._joins.elementAt(n);
                    if (join2.outer && join.leftTable.equals(join2.leftTable)) {
                        stringBuffer.append(" LEFT OUTER JOIN ");
                        string = (String)hashtable.get(join2.rightTable);
                        if (join2.rightTable.equals(string)) {
                            stringBuffer.append(this._factory.quoteName(string));
                        } else {
                            stringBuffer.append(this._factory.quoteName(string) + " " + this._factory.quoteName(join2.rightTable));
                        }
                        stringBuffer.append(" ON ");
                        int n4 = 0;
                        while (n4 < join2.leftColumns.length) {
                            if (n4 > 0) {
                                stringBuffer.append(" AND ");
                            }
                            stringBuffer.append(this._factory.quoteName(join2.leftTable + "." + join2.leftColumns[n4])).append("=");
                            stringBuffer.append(this._factory.quoteName(join2.rightTable + "." + join2.rightColumns[n4]));
                            ++n4;
                        }
                        hashtable.remove(join2.rightTable);
                    }
                    ++n;
                }
                if (bl2) {
                    stringBuffer.append("}");
                }
                vector.addElement(join.leftTable);
            }
            ++n2;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            if (bl3) {
                bl3 = false;
            } else {
                stringBuffer.append(",");
            }
            String string2 = (String)enumeration.nextElement();
            string = (String)hashtable.get(string2);
            if (string2.equals(string)) {
                stringBuffer.append(this._factory.quoteName(string));
                continue;
            }
            stringBuffer.append(this._factory.quoteName(string) + " " + this._factory.quoteName(string2));
        }
        bl3 = true;
        int n5 = 0;
        while (n5 < this._joins.size()) {
            Join join = (Join)this._joins.elementAt(n5);
            if (!join.outer) {
                if (bl3) {
                    stringBuffer.append(" WHERE ");
                    bl3 = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = 0;
                while (n < join.leftColumns.length) {
                    if (n > 0) {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[n])).append("=");
                    stringBuffer.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[n]));
                    ++n;
                }
            }
            ++n5;
        }
        bl3 = this.addWhereClause(stringBuffer, bl3);
        if (this._order != null) {
            stringBuffer.append(" ORDER BY ").append(this._order);
        }
        return stringBuffer;
    }

    public String toString() {
        return "<" + this.getStatement(false) + ">";
    }

    public Object clone() {
        JDBCQueryExpression jDBCQueryExpression;
        try {
            jDBCQueryExpression = (JDBCQueryExpression)this.getClass().getConstructor(class$org$exolab$castor$persist$spi$PersistenceFactory == null ? (class$org$exolab$castor$persist$spi$PersistenceFactory = JDBCQueryExpression.class$("org.exolab.castor.persist.spi.PersistenceFactory")) : class$org$exolab$castor$persist$spi$PersistenceFactory).newInstance(this._factory);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        jDBCQueryExpression._tables = (Hashtable)this._tables.clone();
        jDBCQueryExpression._conds = (Vector)this._conds.clone();
        jDBCQueryExpression._cols = (Vector)this._cols.clone();
        jDBCQueryExpression._joins = (Vector)this._joins.clone();
        return jDBCQueryExpression;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Join {
        final String leftTable;
        final String[] leftColumns;
        final String rightTable;
        final String[] rightColumns;
        final boolean outer;

        Join(String string, String string2, String string3, String string4, boolean bl) {
            this.leftTable = string;
            this.leftColumns = new String[]{string2};
            this.rightTable = string3;
            this.rightColumns = new String[]{string4};
            this.outer = bl;
        }

        Join(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
            this.leftTable = string;
            this.leftColumns = (String[])stringArray.clone();
            this.rightTable = string2;
            this.rightColumns = (String[])stringArray2.clone();
            this.outer = bl;
        }

        public int hashCode() {
            return this.leftTable.hashCode() ^ this.rightTable.hashCode();
        }

        public boolean equals(Object object) {
            Join join = (Join)object;
            if (!this.leftTable.equals(join.leftTable) || !this.rightTable.equals(join.rightTable) || this.leftColumns.length != join.leftColumns.length || this.rightColumns.length != join.rightColumns.length) {
                return false;
            }
            int n = 0;
            while (n < this.leftColumns.length) {
                if (!this.leftColumns[n].equals(join.leftColumns[n])) {
                    return false;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.rightColumns.length) {
                if (!this.rightColumns[n2].equals(join.rightColumns[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public String toString() {
            return this.leftTable + "." + this.leftColumns[0] + (this.outer ? "*=" : "=") + this.rightTable + "." + this.rightColumns[0];
        }
    }
}

