/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.jdo.oql.Lexer;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.Parser;
import org.exolab.castor.jdo.oql.Token;
import org.exolab.castor.jdo.oql.TokenTypes;

public class ParseTest
implements TokenTypes {
    public static final int NODE_TYPES = 1;
    public static final int NODE_VALUES = 2;
    private static Hashtable tokenTypes = new Hashtable();

    public static void main(String[] stringArray) {
        try {
            Lexer lexer = new Lexer(stringArray[0]);
            Parser parser = new Parser(lexer);
            ParseTreeNode parseTreeNode = parser.getParseTree();
            System.out.println(ParseTest.treeToString(parseTreeNode, 1));
            System.out.println(ParseTest.treeToString(parseTreeNode, 2));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static String treeToString(ParseTreeNode parseTreeNode, int n) {
        String string = "";
        Token token = parseTreeNode.getToken();
        string = n == 1 ? (String)tokenTypes.get(new Integer(token.getTokenType())) : token.getTokenValue();
        if (!parseTreeNode.isLeaf()) {
            string = "( " + string;
            Enumeration enumeration = parseTreeNode.children();
            while (enumeration.hasMoreElements()) {
                string = string + " , " + ParseTest.treeToString((ParseTreeNode)enumeration.nextElement(), n);
            }
            string = string + " )";
        }
        return string;
    }

    static {
        tokenTypes.put(new Integer(0), "END_OF_QUERY");
        tokenTypes.put(new Integer(1), "KEYWORD_SELECT");
        tokenTypes.put(new Integer(2), "IDENTIFIER");
        tokenTypes.put(new Integer(3), "KEYWORD_AS");
        tokenTypes.put(new Integer(4), "COLON");
        tokenTypes.put(new Integer(5), "KEYWORD_FROM");
        tokenTypes.put(new Integer(6), "KEYWORD_IN");
        tokenTypes.put(new Integer(7), "KEYWORD_WHERE");
        tokenTypes.put(new Integer(8), "KEYWORD_OR");
        tokenTypes.put(new Integer(9), "KEYWORD_AND");
        tokenTypes.put(new Integer(10), "EQUAL");
        tokenTypes.put(new Integer(11), "NOT_EQUAL");
        tokenTypes.put(new Integer(12), "KEYWORD_LIKE");
        tokenTypes.put(new Integer(13), "LT");
        tokenTypes.put(new Integer(14), "LTE");
        tokenTypes.put(new Integer(15), "GT");
        tokenTypes.put(new Integer(16), "GTE");
        tokenTypes.put(new Integer(17), "PLUS");
        tokenTypes.put(new Integer(18), "MINUS");
        tokenTypes.put(new Integer(19), "CONCAT");
        tokenTypes.put(new Integer(20), "TIMES");
        tokenTypes.put(new Integer(21), "DIVIDE");
        tokenTypes.put(new Integer(22), "KEYWORD_MOD");
        tokenTypes.put(new Integer(23), "KEYWORD_ABS");
        tokenTypes.put(new Integer(24), "KEYWORD_NOT");
        tokenTypes.put(new Integer(25), "LPAREN");
        tokenTypes.put(new Integer(26), "RPAREN");
        tokenTypes.put(new Integer(27), "DOLLAR");
        tokenTypes.put(new Integer(28), "KEYWORD_NIL");
        tokenTypes.put(new Integer(29), "KEYWORD_UNDEFINED");
        tokenTypes.put(new Integer(32), "BOOLEAN_LITERAL");
        tokenTypes.put(new Integer(33), "LONG_LITERAL");
        tokenTypes.put(new Integer(34), "DOUBLE_LITERAL");
        tokenTypes.put(new Integer(35), "CHAR_LITERAL");
        tokenTypes.put(new Integer(36), "STRING_LITERAL");
        tokenTypes.put(new Integer(37), "DATE_LITERAL");
        tokenTypes.put(new Integer(38), "TIME_LITERAL");
        tokenTypes.put(new Integer(39), "TIMESTAMP_LITERAL");
        tokenTypes.put(new Integer(40), "KEYWORD_BETWEEN");
    }
}

